/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1beta2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.artifactregistry.v1beta2.ArtifactRegistryClient;
import com.google.devtools.artifactregistry.v1beta2.CreateRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.CreateTagRequest;
import com.google.devtools.artifactregistry.v1beta2.DeletePackageRequest;
import com.google.devtools.artifactregistry.v1beta2.DeleteRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.DeleteTagRequest;
import com.google.devtools.artifactregistry.v1beta2.DeleteVersionRequest;
import com.google.devtools.artifactregistry.v1beta2.File;
import com.google.devtools.artifactregistry.v1beta2.GetFileRequest;
import com.google.devtools.artifactregistry.v1beta2.GetPackageRequest;
import com.google.devtools.artifactregistry.v1beta2.GetRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.GetTagRequest;
import com.google.devtools.artifactregistry.v1beta2.GetVersionRequest;
import com.google.devtools.artifactregistry.v1beta2.ListFilesRequest;
import com.google.devtools.artifactregistry.v1beta2.ListFilesResponse;
import com.google.devtools.artifactregistry.v1beta2.ListPackagesRequest;
import com.google.devtools.artifactregistry.v1beta2.ListPackagesResponse;
import com.google.devtools.artifactregistry.v1beta2.ListRepositoriesRequest;
import com.google.devtools.artifactregistry.v1beta2.ListRepositoriesResponse;
import com.google.devtools.artifactregistry.v1beta2.ListTagsRequest;
import com.google.devtools.artifactregistry.v1beta2.ListTagsResponse;
import com.google.devtools.artifactregistry.v1beta2.ListVersionsRequest;
import com.google.devtools.artifactregistry.v1beta2.ListVersionsResponse;
import com.google.devtools.artifactregistry.v1beta2.OperationMetadata;
import com.google.devtools.artifactregistry.v1beta2.Package;
import com.google.devtools.artifactregistry.v1beta2.Repository;
import com.google.devtools.artifactregistry.v1beta2.Tag;
import com.google.devtools.artifactregistry.v1beta2.UpdateRepositoryRequest;
import com.google.devtools.artifactregistry.v1beta2.UpdateTagRequest;
import com.google.devtools.artifactregistry.v1beta2.Version;
import com.google.devtools.artifactregistry.v1beta2.stub.ArtifactRegistryStub;
import com.google.devtools.artifactregistry.v1beta2.stub.ArtifactRegistryStubSettings;
import com.google.devtools.artifactregistry.v1beta2.stub.GrpcArtifactRegistryCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcArtifactRegistryStub
extends ArtifactRegistryStub {
    private static final MethodDescriptor<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListRepositories").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRepositoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRepositoriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRepositoryRequest, Repository> getRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Repository.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateRepositoryRequest, Operation> createRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/CreateRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateRepositoryRequest, Repository> updateRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/UpdateRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Repository.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteRepositoryRequest, Operation> deleteRepositoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeleteRepository").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRepositoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPackagesRequest, ListPackagesResponse> listPackagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListPackages").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPackagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPackagesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPackageRequest, Package> getPackageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetPackage").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPackageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Package.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePackageRequest, Operation> deletePackageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeletePackage").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePackageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListVersionsRequest, ListVersionsResponse> listVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetVersionRequest, Version> getVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Version.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteVersionRequest, Operation> deleteVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeleteVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListFilesRequest, ListFilesResponse> listFilesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListFiles").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFilesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFilesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetFileRequest, File> getFileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetFile").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)File.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTagsRequest, ListTagsResponse> listTagsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListTags").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTagsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTagsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTagRequest, Tag> getTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetTag").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tag.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateTagRequest, Tag> createTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/CreateTag").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tag.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTagRequest, Tag> updateTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/UpdateTag").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tag.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTagRequest, Empty> deleteTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeleteTag").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.artifactregistry.v1beta2.ArtifactRegistry/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable;
    private final UnaryCallable<ListRepositoriesRequest, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable;
    private final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable;
    private final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable;
    private final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable;
    private final UnaryCallable<UpdateRepositoryRequest, Repository> updateRepositoryCallable;
    private final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable;
    private final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable;
    private final UnaryCallable<ListPackagesRequest, ListPackagesResponse> listPackagesCallable;
    private final UnaryCallable<ListPackagesRequest, ArtifactRegistryClient.ListPackagesPagedResponse> listPackagesPagedCallable;
    private final UnaryCallable<GetPackageRequest, Package> getPackageCallable;
    private final UnaryCallable<DeletePackageRequest, Operation> deletePackageCallable;
    private final OperationCallable<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationCallable;
    private final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable;
    private final UnaryCallable<ListVersionsRequest, ArtifactRegistryClient.ListVersionsPagedResponse> listVersionsPagedCallable;
    private final UnaryCallable<GetVersionRequest, Version> getVersionCallable;
    private final UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable;
    private final OperationCallable<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationCallable;
    private final UnaryCallable<ListFilesRequest, ListFilesResponse> listFilesCallable;
    private final UnaryCallable<ListFilesRequest, ArtifactRegistryClient.ListFilesPagedResponse> listFilesPagedCallable;
    private final UnaryCallable<GetFileRequest, File> getFileCallable;
    private final UnaryCallable<ListTagsRequest, ListTagsResponse> listTagsCallable;
    private final UnaryCallable<ListTagsRequest, ArtifactRegistryClient.ListTagsPagedResponse> listTagsPagedCallable;
    private final UnaryCallable<GetTagRequest, Tag> getTagCallable;
    private final UnaryCallable<CreateTagRequest, Tag> createTagCallable;
    private final UnaryCallable<UpdateTagRequest, Tag> updateTagCallable;
    private final UnaryCallable<DeleteTagRequest, Empty> deleteTagCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcArtifactRegistryStub create(ArtifactRegistryStubSettings settings) throws IOException {
        return new GrpcArtifactRegistryStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcArtifactRegistryStub create(ClientContext clientContext) throws IOException {
        return new GrpcArtifactRegistryStub(ArtifactRegistryStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcArtifactRegistryStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcArtifactRegistryStub(ArtifactRegistryStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcArtifactRegistryStub(ArtifactRegistryStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcArtifactRegistryCallableFactory());
    }

    protected GrpcArtifactRegistryStub(ArtifactRegistryStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listRepositoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRepositoriesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListRepositoriesRequest>(){

            public Map<String, String> extract(ListRepositoriesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRepositoryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetRepositoryRequest>(){

            public Map<String, String> extract(GetRepositoryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createRepositoryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateRepositoryRequest>(){

            public Map<String, String> extract(CreateRepositoryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateRepositoryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateRepositoryRequest>(){

            public Map<String, String> extract(UpdateRepositoryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"repository.name", (Object)String.valueOf(request.getRepository().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteRepositoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRepositoryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteRepositoryRequest>(){

            public Map<String, String> extract(DeleteRepositoryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listPackagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPackagesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListPackagesRequest>(){

            public Map<String, String> extract(ListPackagesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getPackageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPackageMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetPackageRequest>(){

            public Map<String, String> extract(GetPackageRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deletePackageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePackageMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeletePackageRequest>(){

            public Map<String, String> extract(DeletePackageRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listVersionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListVersionsRequest>(){

            public Map<String, String> extract(ListVersionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetVersionRequest>(){

            public Map<String, String> extract(GetVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteVersionRequest>(){

            public Map<String, String> extract(DeleteVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listFilesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFilesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListFilesRequest>(){

            public Map<String, String> extract(ListFilesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getFileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFileMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetFileRequest>(){

            public Map<String, String> extract(GetFileRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listTagsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTagsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListTagsRequest>(){

            public Map<String, String> extract(ListTagsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTagMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetTagRequest>(){

            public Map<String, String> extract(GetTagRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTagMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateTagRequest>(){

            public Map<String, String> extract(CreateTagRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTagMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateTagRequest>(){

            public Map<String, String> extract(UpdateTagRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"tag.name", (Object)String.valueOf(request.getTag().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTagMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteTagRequest>(){

            public Map<String, String> extract(DeleteTagRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SetIamPolicyRequest>(){

            public Map<String, String> extract(SetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetIamPolicyRequest>(){

            public Map<String, String> extract(GetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<TestIamPermissionsRequest>(){

            public Map<String, String> extract(TestIamPermissionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        this.listRepositoriesCallable = callableFactory.createUnaryCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.listRepositoriesPagedCallable = callableFactory.createPagedCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.getRepositoryCallable = callableFactory.createUnaryCallable(getRepositoryTransportSettings, settings.getRepositorySettings(), clientContext);
        this.createRepositoryCallable = callableFactory.createUnaryCallable(createRepositoryTransportSettings, settings.createRepositorySettings(), clientContext);
        this.createRepositoryOperationCallable = callableFactory.createOperationCallable(createRepositoryTransportSettings, settings.createRepositoryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateRepositoryCallable = callableFactory.createUnaryCallable(updateRepositoryTransportSettings, settings.updateRepositorySettings(), clientContext);
        this.deleteRepositoryCallable = callableFactory.createUnaryCallable(deleteRepositoryTransportSettings, settings.deleteRepositorySettings(), clientContext);
        this.deleteRepositoryOperationCallable = callableFactory.createOperationCallable(deleteRepositoryTransportSettings, settings.deleteRepositoryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listPackagesCallable = callableFactory.createUnaryCallable(listPackagesTransportSettings, settings.listPackagesSettings(), clientContext);
        this.listPackagesPagedCallable = callableFactory.createPagedCallable(listPackagesTransportSettings, settings.listPackagesSettings(), clientContext);
        this.getPackageCallable = callableFactory.createUnaryCallable(getPackageTransportSettings, settings.getPackageSettings(), clientContext);
        this.deletePackageCallable = callableFactory.createUnaryCallable(deletePackageTransportSettings, settings.deletePackageSettings(), clientContext);
        this.deletePackageOperationCallable = callableFactory.createOperationCallable(deletePackageTransportSettings, settings.deletePackageOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listVersionsCallable = callableFactory.createUnaryCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.listVersionsPagedCallable = callableFactory.createPagedCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.getVersionCallable = callableFactory.createUnaryCallable(getVersionTransportSettings, settings.getVersionSettings(), clientContext);
        this.deleteVersionCallable = callableFactory.createUnaryCallable(deleteVersionTransportSettings, settings.deleteVersionSettings(), clientContext);
        this.deleteVersionOperationCallable = callableFactory.createOperationCallable(deleteVersionTransportSettings, settings.deleteVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listFilesCallable = callableFactory.createUnaryCallable(listFilesTransportSettings, settings.listFilesSettings(), clientContext);
        this.listFilesPagedCallable = callableFactory.createPagedCallable(listFilesTransportSettings, settings.listFilesSettings(), clientContext);
        this.getFileCallable = callableFactory.createUnaryCallable(getFileTransportSettings, settings.getFileSettings(), clientContext);
        this.listTagsCallable = callableFactory.createUnaryCallable(listTagsTransportSettings, settings.listTagsSettings(), clientContext);
        this.listTagsPagedCallable = callableFactory.createPagedCallable(listTagsTransportSettings, settings.listTagsSettings(), clientContext);
        this.getTagCallable = callableFactory.createUnaryCallable(getTagTransportSettings, settings.getTagSettings(), clientContext);
        this.createTagCallable = callableFactory.createUnaryCallable(createTagTransportSettings, settings.createTagSettings(), clientContext);
        this.updateTagCallable = callableFactory.createUnaryCallable(updateTagTransportSettings, settings.updateTagSettings(), clientContext);
        this.deleteTagCallable = callableFactory.createUnaryCallable(deleteTagTransportSettings, settings.deleteTagSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.listRepositoriesCallable;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, ArtifactRegistryClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.listRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.getRepositoryCallable;
    }

    @Override
    public UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.createRepositoryCallable;
    }

    @Override
    public OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.createRepositoryOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateRepositoryRequest, Repository> updateRepositoryCallable() {
        return this.updateRepositoryCallable;
    }

    @Override
    public UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.deleteRepositoryCallable;
    }

    @Override
    public OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.deleteRepositoryOperationCallable;
    }

    @Override
    public UnaryCallable<ListPackagesRequest, ListPackagesResponse> listPackagesCallable() {
        return this.listPackagesCallable;
    }

    @Override
    public UnaryCallable<ListPackagesRequest, ArtifactRegistryClient.ListPackagesPagedResponse> listPackagesPagedCallable() {
        return this.listPackagesPagedCallable;
    }

    @Override
    public UnaryCallable<GetPackageRequest, Package> getPackageCallable() {
        return this.getPackageCallable;
    }

    @Override
    public UnaryCallable<DeletePackageRequest, Operation> deletePackageCallable() {
        return this.deletePackageCallable;
    }

    @Override
    public OperationCallable<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationCallable() {
        return this.deletePackageOperationCallable;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.listVersionsCallable;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, ArtifactRegistryClient.ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.listVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.getVersionCallable;
    }

    @Override
    public UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable() {
        return this.deleteVersionCallable;
    }

    @Override
    public OperationCallable<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationCallable() {
        return this.deleteVersionOperationCallable;
    }

    @Override
    public UnaryCallable<ListFilesRequest, ListFilesResponse> listFilesCallable() {
        return this.listFilesCallable;
    }

    @Override
    public UnaryCallable<ListFilesRequest, ArtifactRegistryClient.ListFilesPagedResponse> listFilesPagedCallable() {
        return this.listFilesPagedCallable;
    }

    @Override
    public UnaryCallable<GetFileRequest, File> getFileCallable() {
        return this.getFileCallable;
    }

    @Override
    public UnaryCallable<ListTagsRequest, ListTagsResponse> listTagsCallable() {
        return this.listTagsCallable;
    }

    @Override
    public UnaryCallable<ListTagsRequest, ArtifactRegistryClient.ListTagsPagedResponse> listTagsPagedCallable() {
        return this.listTagsPagedCallable;
    }

    @Override
    public UnaryCallable<GetTagRequest, Tag> getTagCallable() {
        return this.getTagCallable;
    }

    @Override
    public UnaryCallable<CreateTagRequest, Tag> createTagCallable() {
        return this.createTagCallable;
    }

    @Override
    public UnaryCallable<UpdateTagRequest, Tag> updateTagCallable() {
        return this.updateTagCallable;
    }

    @Override
    public UnaryCallable<DeleteTagRequest, Empty> deleteTagCallable() {
        return this.deleteTagCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

