/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apphub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apphub.v1.AppHubClient;
import com.google.cloud.apphub.v1.Application;
import com.google.cloud.apphub.v1.CreateApplicationRequest;
import com.google.cloud.apphub.v1.CreateServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.CreateServiceRequest;
import com.google.cloud.apphub.v1.CreateWorkloadRequest;
import com.google.cloud.apphub.v1.DeleteApplicationRequest;
import com.google.cloud.apphub.v1.DeleteServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.DeleteServiceRequest;
import com.google.cloud.apphub.v1.DeleteWorkloadRequest;
import com.google.cloud.apphub.v1.DetachServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.DetachServiceProjectAttachmentResponse;
import com.google.cloud.apphub.v1.DiscoveredService;
import com.google.cloud.apphub.v1.DiscoveredWorkload;
import com.google.cloud.apphub.v1.GetApplicationRequest;
import com.google.cloud.apphub.v1.GetDiscoveredServiceRequest;
import com.google.cloud.apphub.v1.GetDiscoveredWorkloadRequest;
import com.google.cloud.apphub.v1.GetServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.GetServiceRequest;
import com.google.cloud.apphub.v1.GetWorkloadRequest;
import com.google.cloud.apphub.v1.ListApplicationsRequest;
import com.google.cloud.apphub.v1.ListApplicationsResponse;
import com.google.cloud.apphub.v1.ListDiscoveredServicesRequest;
import com.google.cloud.apphub.v1.ListDiscoveredServicesResponse;
import com.google.cloud.apphub.v1.ListDiscoveredWorkloadsRequest;
import com.google.cloud.apphub.v1.ListDiscoveredWorkloadsResponse;
import com.google.cloud.apphub.v1.ListServiceProjectAttachmentsRequest;
import com.google.cloud.apphub.v1.ListServiceProjectAttachmentsResponse;
import com.google.cloud.apphub.v1.ListServicesRequest;
import com.google.cloud.apphub.v1.ListServicesResponse;
import com.google.cloud.apphub.v1.ListWorkloadsRequest;
import com.google.cloud.apphub.v1.ListWorkloadsResponse;
import com.google.cloud.apphub.v1.LookupDiscoveredServiceRequest;
import com.google.cloud.apphub.v1.LookupDiscoveredServiceResponse;
import com.google.cloud.apphub.v1.LookupDiscoveredWorkloadRequest;
import com.google.cloud.apphub.v1.LookupDiscoveredWorkloadResponse;
import com.google.cloud.apphub.v1.LookupServiceProjectAttachmentRequest;
import com.google.cloud.apphub.v1.LookupServiceProjectAttachmentResponse;
import com.google.cloud.apphub.v1.OperationMetadata;
import com.google.cloud.apphub.v1.Service;
import com.google.cloud.apphub.v1.ServiceProjectAttachment;
import com.google.cloud.apphub.v1.UpdateApplicationRequest;
import com.google.cloud.apphub.v1.UpdateServiceRequest;
import com.google.cloud.apphub.v1.UpdateWorkloadRequest;
import com.google.cloud.apphub.v1.Workload;
import com.google.cloud.apphub.v1.stub.AppHubStub;
import com.google.cloud.apphub.v1.stub.GrpcAppHubStub;
import com.google.cloud.apphub.v1.stub.HttpJsonAppHubStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AppHubStubSettings
extends StubSettings<AppHubStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<LookupServiceProjectAttachmentRequest, LookupServiceProjectAttachmentResponse> lookupServiceProjectAttachmentSettings;
    private final PagedCallSettings<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, AppHubClient.ListServiceProjectAttachmentsPagedResponse> listServiceProjectAttachmentsSettings;
    private final UnaryCallSettings<CreateServiceProjectAttachmentRequest, Operation> createServiceProjectAttachmentSettings;
    private final OperationCallSettings<CreateServiceProjectAttachmentRequest, ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentOperationSettings;
    private final UnaryCallSettings<GetServiceProjectAttachmentRequest, ServiceProjectAttachment> getServiceProjectAttachmentSettings;
    private final UnaryCallSettings<DeleteServiceProjectAttachmentRequest, Operation> deleteServiceProjectAttachmentSettings;
    private final OperationCallSettings<DeleteServiceProjectAttachmentRequest, Empty, OperationMetadata> deleteServiceProjectAttachmentOperationSettings;
    private final UnaryCallSettings<DetachServiceProjectAttachmentRequest, DetachServiceProjectAttachmentResponse> detachServiceProjectAttachmentSettings;
    private final PagedCallSettings<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, AppHubClient.ListDiscoveredServicesPagedResponse> listDiscoveredServicesSettings;
    private final UnaryCallSettings<GetDiscoveredServiceRequest, DiscoveredService> getDiscoveredServiceSettings;
    private final UnaryCallSettings<LookupDiscoveredServiceRequest, LookupDiscoveredServiceResponse> lookupDiscoveredServiceSettings;
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, AppHubClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<CreateServiceRequest, Operation> createServiceSettings;
    private final OperationCallSettings<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final UnaryCallSettings<UpdateServiceRequest, Operation> updateServiceSettings;
    private final OperationCallSettings<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings;
    private final UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings;
    private final OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings;
    private final PagedCallSettings<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, AppHubClient.ListDiscoveredWorkloadsPagedResponse> listDiscoveredWorkloadsSettings;
    private final UnaryCallSettings<GetDiscoveredWorkloadRequest, DiscoveredWorkload> getDiscoveredWorkloadSettings;
    private final UnaryCallSettings<LookupDiscoveredWorkloadRequest, LookupDiscoveredWorkloadResponse> lookupDiscoveredWorkloadSettings;
    private final PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, AppHubClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
    private final UnaryCallSettings<CreateWorkloadRequest, Operation> createWorkloadSettings;
    private final OperationCallSettings<CreateWorkloadRequest, Workload, OperationMetadata> createWorkloadOperationSettings;
    private final UnaryCallSettings<GetWorkloadRequest, Workload> getWorkloadSettings;
    private final UnaryCallSettings<UpdateWorkloadRequest, Operation> updateWorkloadSettings;
    private final OperationCallSettings<UpdateWorkloadRequest, Workload, OperationMetadata> updateWorkloadOperationSettings;
    private final UnaryCallSettings<DeleteWorkloadRequest, Operation> deleteWorkloadSettings;
    private final OperationCallSettings<DeleteWorkloadRequest, Empty, OperationMetadata> deleteWorkloadOperationSettings;
    private final PagedCallSettings<ListApplicationsRequest, ListApplicationsResponse, AppHubClient.ListApplicationsPagedResponse> listApplicationsSettings;
    private final UnaryCallSettings<CreateApplicationRequest, Operation> createApplicationSettings;
    private final OperationCallSettings<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings;
    private final UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings;
    private final UnaryCallSettings<UpdateApplicationRequest, Operation> updateApplicationSettings;
    private final OperationCallSettings<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings;
    private final UnaryCallSettings<DeleteApplicationRequest, Operation> deleteApplicationSettings;
    private final OperationCallSettings<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AppHubClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment> LIST_SERVICE_PROJECT_ATTACHMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceProjectAttachmentsRequest injectToken(ListServiceProjectAttachmentsRequest payload, String token) {
            return ListServiceProjectAttachmentsRequest.newBuilder((ListServiceProjectAttachmentsRequest)payload).setPageToken(token).build();
        }

        public ListServiceProjectAttachmentsRequest injectPageSize(ListServiceProjectAttachmentsRequest payload, int pageSize) {
            return ListServiceProjectAttachmentsRequest.newBuilder((ListServiceProjectAttachmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceProjectAttachmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceProjectAttachmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceProjectAttachment> extractResources(ListServiceProjectAttachmentsResponse payload) {
            return payload.getServiceProjectAttachmentsList();
        }
    };
    private static final PagedListDescriptor<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService> LIST_DISCOVERED_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService>(){

        public String emptyToken() {
            return "";
        }

        public ListDiscoveredServicesRequest injectToken(ListDiscoveredServicesRequest payload, String token) {
            return ListDiscoveredServicesRequest.newBuilder((ListDiscoveredServicesRequest)payload).setPageToken(token).build();
        }

        public ListDiscoveredServicesRequest injectPageSize(ListDiscoveredServicesRequest payload, int pageSize) {
            return ListDiscoveredServicesRequest.newBuilder((ListDiscoveredServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDiscoveredServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDiscoveredServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DiscoveredService> extractResources(ListDiscoveredServicesResponse payload) {
            return payload.getDiscoveredServicesList();
        }
    };
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload> LIST_DISCOVERED_WORKLOADS_PAGE_STR_DESC = new PagedListDescriptor<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload>(){

        public String emptyToken() {
            return "";
        }

        public ListDiscoveredWorkloadsRequest injectToken(ListDiscoveredWorkloadsRequest payload, String token) {
            return ListDiscoveredWorkloadsRequest.newBuilder((ListDiscoveredWorkloadsRequest)payload).setPageToken(token).build();
        }

        public ListDiscoveredWorkloadsRequest injectPageSize(ListDiscoveredWorkloadsRequest payload, int pageSize) {
            return ListDiscoveredWorkloadsRequest.newBuilder((ListDiscoveredWorkloadsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDiscoveredWorkloadsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDiscoveredWorkloadsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DiscoveredWorkload> extractResources(ListDiscoveredWorkloadsResponse payload) {
            return payload.getDiscoveredWorkloadsList();
        }
    };
    private static final PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, Workload> LIST_WORKLOADS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, Workload>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkloadsRequest injectToken(ListWorkloadsRequest payload, String token) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageToken(token).build();
        }

        public ListWorkloadsRequest injectPageSize(ListWorkloadsRequest payload, int pageSize) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkloadsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkloadsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Workload> extractResources(ListWorkloadsResponse payload) {
            return payload.getWorkloadsList();
        }
    };
    private static final PagedListDescriptor<ListApplicationsRequest, ListApplicationsResponse, Application> LIST_APPLICATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListApplicationsRequest, ListApplicationsResponse, Application>(){

        public String emptyToken() {
            return "";
        }

        public ListApplicationsRequest injectToken(ListApplicationsRequest payload, String token) {
            return ListApplicationsRequest.newBuilder((ListApplicationsRequest)payload).setPageToken(token).build();
        }

        public ListApplicationsRequest injectPageSize(ListApplicationsRequest payload, int pageSize) {
            return ListApplicationsRequest.newBuilder((ListApplicationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApplicationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApplicationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Application> extractResources(ListApplicationsResponse payload) {
            return payload.getApplicationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, AppHubClient.ListServiceProjectAttachmentsPagedResponse> LIST_SERVICE_PROJECT_ATTACHMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, AppHubClient.ListServiceProjectAttachmentsPagedResponse>(){

        public ApiFuture<AppHubClient.ListServiceProjectAttachmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse> callable, ListServiceProjectAttachmentsRequest request, ApiCallContext context, ApiFuture<ListServiceProjectAttachmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_PROJECT_ATTACHMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppHubClient.ListServiceProjectAttachmentsPagedResponse.createAsync((PageContext<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, ServiceProjectAttachment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, AppHubClient.ListDiscoveredServicesPagedResponse> LIST_DISCOVERED_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, AppHubClient.ListDiscoveredServicesPagedResponse>(){

        public ApiFuture<AppHubClient.ListDiscoveredServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse> callable, ListDiscoveredServicesRequest request, ApiCallContext context, ApiFuture<ListDiscoveredServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DISCOVERED_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppHubClient.ListDiscoveredServicesPagedResponse.createAsync((PageContext<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, DiscoveredService>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, AppHubClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, AppHubClient.ListServicesPagedResponse>(){

        public ApiFuture<AppHubClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppHubClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, AppHubClient.ListDiscoveredWorkloadsPagedResponse> LIST_DISCOVERED_WORKLOADS_PAGE_STR_FACT = new PagedListResponseFactory<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, AppHubClient.ListDiscoveredWorkloadsPagedResponse>(){

        public ApiFuture<AppHubClient.ListDiscoveredWorkloadsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse> callable, ListDiscoveredWorkloadsRequest request, ApiCallContext context, ApiFuture<ListDiscoveredWorkloadsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DISCOVERED_WORKLOADS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppHubClient.ListDiscoveredWorkloadsPagedResponse.createAsync((PageContext<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, DiscoveredWorkload>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, AppHubClient.ListWorkloadsPagedResponse> LIST_WORKLOADS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, AppHubClient.ListWorkloadsPagedResponse>(){

        public ApiFuture<AppHubClient.ListWorkloadsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> callable, ListWorkloadsRequest request, ApiCallContext context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKLOADS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppHubClient.ListWorkloadsPagedResponse.createAsync((PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApplicationsRequest, ListApplicationsResponse, AppHubClient.ListApplicationsPagedResponse> LIST_APPLICATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListApplicationsRequest, ListApplicationsResponse, AppHubClient.ListApplicationsPagedResponse>(){

        public ApiFuture<AppHubClient.ListApplicationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> callable, ListApplicationsRequest request, ApiCallContext context, ApiFuture<ListApplicationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APPLICATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppHubClient.ListApplicationsPagedResponse.createAsync((PageContext<ListApplicationsRequest, ListApplicationsResponse, Application>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AppHubClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AppHubClient.ListLocationsPagedResponse>(){

        public ApiFuture<AppHubClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppHubClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<LookupServiceProjectAttachmentRequest, LookupServiceProjectAttachmentResponse> lookupServiceProjectAttachmentSettings() {
        return this.lookupServiceProjectAttachmentSettings;
    }

    public PagedCallSettings<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, AppHubClient.ListServiceProjectAttachmentsPagedResponse> listServiceProjectAttachmentsSettings() {
        return this.listServiceProjectAttachmentsSettings;
    }

    public UnaryCallSettings<CreateServiceProjectAttachmentRequest, Operation> createServiceProjectAttachmentSettings() {
        return this.createServiceProjectAttachmentSettings;
    }

    public OperationCallSettings<CreateServiceProjectAttachmentRequest, ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentOperationSettings() {
        return this.createServiceProjectAttachmentOperationSettings;
    }

    public UnaryCallSettings<GetServiceProjectAttachmentRequest, ServiceProjectAttachment> getServiceProjectAttachmentSettings() {
        return this.getServiceProjectAttachmentSettings;
    }

    public UnaryCallSettings<DeleteServiceProjectAttachmentRequest, Operation> deleteServiceProjectAttachmentSettings() {
        return this.deleteServiceProjectAttachmentSettings;
    }

    public OperationCallSettings<DeleteServiceProjectAttachmentRequest, Empty, OperationMetadata> deleteServiceProjectAttachmentOperationSettings() {
        return this.deleteServiceProjectAttachmentOperationSettings;
    }

    public UnaryCallSettings<DetachServiceProjectAttachmentRequest, DetachServiceProjectAttachmentResponse> detachServiceProjectAttachmentSettings() {
        return this.detachServiceProjectAttachmentSettings;
    }

    public PagedCallSettings<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, AppHubClient.ListDiscoveredServicesPagedResponse> listDiscoveredServicesSettings() {
        return this.listDiscoveredServicesSettings;
    }

    public UnaryCallSettings<GetDiscoveredServiceRequest, DiscoveredService> getDiscoveredServiceSettings() {
        return this.getDiscoveredServiceSettings;
    }

    public UnaryCallSettings<LookupDiscoveredServiceRequest, LookupDiscoveredServiceResponse> lookupDiscoveredServiceSettings() {
        return this.lookupDiscoveredServiceSettings;
    }

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, AppHubClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<CreateServiceRequest, Operation> createServiceSettings() {
        return this.createServiceSettings;
    }

    public OperationCallSettings<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings() {
        return this.createServiceOperationSettings;
    }

    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    public UnaryCallSettings<UpdateServiceRequest, Operation> updateServiceSettings() {
        return this.updateServiceSettings;
    }

    public OperationCallSettings<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings() {
        return this.updateServiceOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings() {
        return this.deleteServiceSettings;
    }

    public OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings() {
        return this.deleteServiceOperationSettings;
    }

    public PagedCallSettings<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, AppHubClient.ListDiscoveredWorkloadsPagedResponse> listDiscoveredWorkloadsSettings() {
        return this.listDiscoveredWorkloadsSettings;
    }

    public UnaryCallSettings<GetDiscoveredWorkloadRequest, DiscoveredWorkload> getDiscoveredWorkloadSettings() {
        return this.getDiscoveredWorkloadSettings;
    }

    public UnaryCallSettings<LookupDiscoveredWorkloadRequest, LookupDiscoveredWorkloadResponse> lookupDiscoveredWorkloadSettings() {
        return this.lookupDiscoveredWorkloadSettings;
    }

    public PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, AppHubClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
        return this.listWorkloadsSettings;
    }

    public UnaryCallSettings<CreateWorkloadRequest, Operation> createWorkloadSettings() {
        return this.createWorkloadSettings;
    }

    public OperationCallSettings<CreateWorkloadRequest, Workload, OperationMetadata> createWorkloadOperationSettings() {
        return this.createWorkloadOperationSettings;
    }

    public UnaryCallSettings<GetWorkloadRequest, Workload> getWorkloadSettings() {
        return this.getWorkloadSettings;
    }

    public UnaryCallSettings<UpdateWorkloadRequest, Operation> updateWorkloadSettings() {
        return this.updateWorkloadSettings;
    }

    public OperationCallSettings<UpdateWorkloadRequest, Workload, OperationMetadata> updateWorkloadOperationSettings() {
        return this.updateWorkloadOperationSettings;
    }

    public UnaryCallSettings<DeleteWorkloadRequest, Operation> deleteWorkloadSettings() {
        return this.deleteWorkloadSettings;
    }

    public OperationCallSettings<DeleteWorkloadRequest, Empty, OperationMetadata> deleteWorkloadOperationSettings() {
        return this.deleteWorkloadOperationSettings;
    }

    public PagedCallSettings<ListApplicationsRequest, ListApplicationsResponse, AppHubClient.ListApplicationsPagedResponse> listApplicationsSettings() {
        return this.listApplicationsSettings;
    }

    public UnaryCallSettings<CreateApplicationRequest, Operation> createApplicationSettings() {
        return this.createApplicationSettings;
    }

    public OperationCallSettings<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings() {
        return this.createApplicationOperationSettings;
    }

    public UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings() {
        return this.getApplicationSettings;
    }

    public UnaryCallSettings<UpdateApplicationRequest, Operation> updateApplicationSettings() {
        return this.updateApplicationSettings;
    }

    public OperationCallSettings<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings() {
        return this.updateApplicationOperationSettings;
    }

    public UnaryCallSettings<DeleteApplicationRequest, Operation> deleteApplicationSettings() {
        return this.deleteApplicationSettings;
    }

    public OperationCallSettings<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings() {
        return this.deleteApplicationOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AppHubClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public AppHubStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAppHubStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAppHubStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apphub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apphub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apphub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AppHubStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AppHubStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AppHubStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AppHubStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AppHubStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.lookupServiceProjectAttachmentSettings = settingsBuilder.lookupServiceProjectAttachmentSettings().build();
        this.listServiceProjectAttachmentsSettings = settingsBuilder.listServiceProjectAttachmentsSettings().build();
        this.createServiceProjectAttachmentSettings = settingsBuilder.createServiceProjectAttachmentSettings().build();
        this.createServiceProjectAttachmentOperationSettings = settingsBuilder.createServiceProjectAttachmentOperationSettings().build();
        this.getServiceProjectAttachmentSettings = settingsBuilder.getServiceProjectAttachmentSettings().build();
        this.deleteServiceProjectAttachmentSettings = settingsBuilder.deleteServiceProjectAttachmentSettings().build();
        this.deleteServiceProjectAttachmentOperationSettings = settingsBuilder.deleteServiceProjectAttachmentOperationSettings().build();
        this.detachServiceProjectAttachmentSettings = settingsBuilder.detachServiceProjectAttachmentSettings().build();
        this.listDiscoveredServicesSettings = settingsBuilder.listDiscoveredServicesSettings().build();
        this.getDiscoveredServiceSettings = settingsBuilder.getDiscoveredServiceSettings().build();
        this.lookupDiscoveredServiceSettings = settingsBuilder.lookupDiscoveredServiceSettings().build();
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.createServiceSettings = settingsBuilder.createServiceSettings().build();
        this.createServiceOperationSettings = settingsBuilder.createServiceOperationSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.updateServiceSettings = settingsBuilder.updateServiceSettings().build();
        this.updateServiceOperationSettings = settingsBuilder.updateServiceOperationSettings().build();
        this.deleteServiceSettings = settingsBuilder.deleteServiceSettings().build();
        this.deleteServiceOperationSettings = settingsBuilder.deleteServiceOperationSettings().build();
        this.listDiscoveredWorkloadsSettings = settingsBuilder.listDiscoveredWorkloadsSettings().build();
        this.getDiscoveredWorkloadSettings = settingsBuilder.getDiscoveredWorkloadSettings().build();
        this.lookupDiscoveredWorkloadSettings = settingsBuilder.lookupDiscoveredWorkloadSettings().build();
        this.listWorkloadsSettings = settingsBuilder.listWorkloadsSettings().build();
        this.createWorkloadSettings = settingsBuilder.createWorkloadSettings().build();
        this.createWorkloadOperationSettings = settingsBuilder.createWorkloadOperationSettings().build();
        this.getWorkloadSettings = settingsBuilder.getWorkloadSettings().build();
        this.updateWorkloadSettings = settingsBuilder.updateWorkloadSettings().build();
        this.updateWorkloadOperationSettings = settingsBuilder.updateWorkloadOperationSettings().build();
        this.deleteWorkloadSettings = settingsBuilder.deleteWorkloadSettings().build();
        this.deleteWorkloadOperationSettings = settingsBuilder.deleteWorkloadOperationSettings().build();
        this.listApplicationsSettings = settingsBuilder.listApplicationsSettings().build();
        this.createApplicationSettings = settingsBuilder.createApplicationSettings().build();
        this.createApplicationOperationSettings = settingsBuilder.createApplicationOperationSettings().build();
        this.getApplicationSettings = settingsBuilder.getApplicationSettings().build();
        this.updateApplicationSettings = settingsBuilder.updateApplicationSettings().build();
        this.updateApplicationOperationSettings = settingsBuilder.updateApplicationOperationSettings().build();
        this.deleteApplicationSettings = settingsBuilder.deleteApplicationSettings().build();
        this.deleteApplicationOperationSettings = settingsBuilder.deleteApplicationOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AppHubStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<LookupServiceProjectAttachmentRequest, LookupServiceProjectAttachmentResponse> lookupServiceProjectAttachmentSettings;
        private final PagedCallSettings.Builder<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, AppHubClient.ListServiceProjectAttachmentsPagedResponse> listServiceProjectAttachmentsSettings;
        private final UnaryCallSettings.Builder<CreateServiceProjectAttachmentRequest, Operation> createServiceProjectAttachmentSettings;
        private final OperationCallSettings.Builder<CreateServiceProjectAttachmentRequest, ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentOperationSettings;
        private final UnaryCallSettings.Builder<GetServiceProjectAttachmentRequest, ServiceProjectAttachment> getServiceProjectAttachmentSettings;
        private final UnaryCallSettings.Builder<DeleteServiceProjectAttachmentRequest, Operation> deleteServiceProjectAttachmentSettings;
        private final OperationCallSettings.Builder<DeleteServiceProjectAttachmentRequest, Empty, OperationMetadata> deleteServiceProjectAttachmentOperationSettings;
        private final UnaryCallSettings.Builder<DetachServiceProjectAttachmentRequest, DetachServiceProjectAttachmentResponse> detachServiceProjectAttachmentSettings;
        private final PagedCallSettings.Builder<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, AppHubClient.ListDiscoveredServicesPagedResponse> listDiscoveredServicesSettings;
        private final UnaryCallSettings.Builder<GetDiscoveredServiceRequest, DiscoveredService> getDiscoveredServiceSettings;
        private final UnaryCallSettings.Builder<LookupDiscoveredServiceRequest, LookupDiscoveredServiceResponse> lookupDiscoveredServiceSettings;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, AppHubClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<CreateServiceRequest, Operation> createServiceSettings;
        private final OperationCallSettings.Builder<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final UnaryCallSettings.Builder<UpdateServiceRequest, Operation> updateServiceSettings;
        private final OperationCallSettings.Builder<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings;
        private final OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings;
        private final PagedCallSettings.Builder<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, AppHubClient.ListDiscoveredWorkloadsPagedResponse> listDiscoveredWorkloadsSettings;
        private final UnaryCallSettings.Builder<GetDiscoveredWorkloadRequest, DiscoveredWorkload> getDiscoveredWorkloadSettings;
        private final UnaryCallSettings.Builder<LookupDiscoveredWorkloadRequest, LookupDiscoveredWorkloadResponse> lookupDiscoveredWorkloadSettings;
        private final PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, AppHubClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
        private final UnaryCallSettings.Builder<CreateWorkloadRequest, Operation> createWorkloadSettings;
        private final OperationCallSettings.Builder<CreateWorkloadRequest, Workload, OperationMetadata> createWorkloadOperationSettings;
        private final UnaryCallSettings.Builder<GetWorkloadRequest, Workload> getWorkloadSettings;
        private final UnaryCallSettings.Builder<UpdateWorkloadRequest, Operation> updateWorkloadSettings;
        private final OperationCallSettings.Builder<UpdateWorkloadRequest, Workload, OperationMetadata> updateWorkloadOperationSettings;
        private final UnaryCallSettings.Builder<DeleteWorkloadRequest, Operation> deleteWorkloadSettings;
        private final OperationCallSettings.Builder<DeleteWorkloadRequest, Empty, OperationMetadata> deleteWorkloadOperationSettings;
        private final PagedCallSettings.Builder<ListApplicationsRequest, ListApplicationsResponse, AppHubClient.ListApplicationsPagedResponse> listApplicationsSettings;
        private final UnaryCallSettings.Builder<CreateApplicationRequest, Operation> createApplicationSettings;
        private final OperationCallSettings.Builder<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings;
        private final UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings;
        private final UnaryCallSettings.Builder<UpdateApplicationRequest, Operation> updateApplicationSettings;
        private final OperationCallSettings.Builder<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteApplicationRequest, Operation> deleteApplicationSettings;
        private final OperationCallSettings.Builder<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AppHubClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.lookupServiceProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServiceProjectAttachmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_PROJECT_ATTACHMENTS_PAGE_STR_FACT);
            this.createServiceProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceProjectAttachmentOperationSettings = OperationCallSettings.newBuilder();
            this.getServiceProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceProjectAttachmentOperationSettings = OperationCallSettings.newBuilder();
            this.detachServiceProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDiscoveredServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DISCOVERED_SERVICES_PAGE_STR_FACT);
            this.getDiscoveredServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupDiscoveredServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.createServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceOperationSettings = OperationCallSettings.newBuilder();
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceOperationSettings = OperationCallSettings.newBuilder();
            this.listDiscoveredWorkloadsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DISCOVERED_WORKLOADS_PAGE_STR_FACT);
            this.getDiscoveredWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupDiscoveredWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkloadsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKLOADS_PAGE_STR_FACT);
            this.createWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkloadOperationSettings = OperationCallSettings.newBuilder();
            this.getWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkloadOperationSettings = OperationCallSettings.newBuilder();
            this.deleteWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkloadOperationSettings = OperationCallSettings.newBuilder();
            this.listApplicationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APPLICATIONS_PAGE_STR_FACT);
            this.createApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.getApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.lookupServiceProjectAttachmentSettings, this.listServiceProjectAttachmentsSettings, this.createServiceProjectAttachmentSettings, this.getServiceProjectAttachmentSettings, this.deleteServiceProjectAttachmentSettings, this.detachServiceProjectAttachmentSettings, this.listDiscoveredServicesSettings, this.getDiscoveredServiceSettings, this.lookupDiscoveredServiceSettings, this.listServicesSettings, this.createServiceSettings, this.getServiceSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateServiceSettings, this.deleteServiceSettings, this.listDiscoveredWorkloadsSettings, this.getDiscoveredWorkloadSettings, this.lookupDiscoveredWorkloadSettings, this.listWorkloadsSettings, this.createWorkloadSettings, this.getWorkloadSettings, this.updateWorkloadSettings, this.deleteWorkloadSettings, this.listApplicationsSettings, this.createApplicationSettings, this.getApplicationSettings, this.updateApplicationSettings, this.deleteApplicationSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AppHubStubSettings settings) {
            super((StubSettings)settings);
            this.lookupServiceProjectAttachmentSettings = settings.lookupServiceProjectAttachmentSettings.toBuilder();
            this.listServiceProjectAttachmentsSettings = settings.listServiceProjectAttachmentsSettings.toBuilder();
            this.createServiceProjectAttachmentSettings = settings.createServiceProjectAttachmentSettings.toBuilder();
            this.createServiceProjectAttachmentOperationSettings = settings.createServiceProjectAttachmentOperationSettings.toBuilder();
            this.getServiceProjectAttachmentSettings = settings.getServiceProjectAttachmentSettings.toBuilder();
            this.deleteServiceProjectAttachmentSettings = settings.deleteServiceProjectAttachmentSettings.toBuilder();
            this.deleteServiceProjectAttachmentOperationSettings = settings.deleteServiceProjectAttachmentOperationSettings.toBuilder();
            this.detachServiceProjectAttachmentSettings = settings.detachServiceProjectAttachmentSettings.toBuilder();
            this.listDiscoveredServicesSettings = settings.listDiscoveredServicesSettings.toBuilder();
            this.getDiscoveredServiceSettings = settings.getDiscoveredServiceSettings.toBuilder();
            this.lookupDiscoveredServiceSettings = settings.lookupDiscoveredServiceSettings.toBuilder();
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.createServiceSettings = settings.createServiceSettings.toBuilder();
            this.createServiceOperationSettings = settings.createServiceOperationSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.updateServiceSettings = settings.updateServiceSettings.toBuilder();
            this.updateServiceOperationSettings = settings.updateServiceOperationSettings.toBuilder();
            this.deleteServiceSettings = settings.deleteServiceSettings.toBuilder();
            this.deleteServiceOperationSettings = settings.deleteServiceOperationSettings.toBuilder();
            this.listDiscoveredWorkloadsSettings = settings.listDiscoveredWorkloadsSettings.toBuilder();
            this.getDiscoveredWorkloadSettings = settings.getDiscoveredWorkloadSettings.toBuilder();
            this.lookupDiscoveredWorkloadSettings = settings.lookupDiscoveredWorkloadSettings.toBuilder();
            this.listWorkloadsSettings = settings.listWorkloadsSettings.toBuilder();
            this.createWorkloadSettings = settings.createWorkloadSettings.toBuilder();
            this.createWorkloadOperationSettings = settings.createWorkloadOperationSettings.toBuilder();
            this.getWorkloadSettings = settings.getWorkloadSettings.toBuilder();
            this.updateWorkloadSettings = settings.updateWorkloadSettings.toBuilder();
            this.updateWorkloadOperationSettings = settings.updateWorkloadOperationSettings.toBuilder();
            this.deleteWorkloadSettings = settings.deleteWorkloadSettings.toBuilder();
            this.deleteWorkloadOperationSettings = settings.deleteWorkloadOperationSettings.toBuilder();
            this.listApplicationsSettings = settings.listApplicationsSettings.toBuilder();
            this.createApplicationSettings = settings.createApplicationSettings.toBuilder();
            this.createApplicationOperationSettings = settings.createApplicationOperationSettings.toBuilder();
            this.getApplicationSettings = settings.getApplicationSettings.toBuilder();
            this.updateApplicationSettings = settings.updateApplicationSettings.toBuilder();
            this.updateApplicationOperationSettings = settings.updateApplicationOperationSettings.toBuilder();
            this.deleteApplicationSettings = settings.deleteApplicationSettings.toBuilder();
            this.deleteApplicationOperationSettings = settings.deleteApplicationOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.lookupServiceProjectAttachmentSettings, this.listServiceProjectAttachmentsSettings, this.createServiceProjectAttachmentSettings, this.getServiceProjectAttachmentSettings, this.deleteServiceProjectAttachmentSettings, this.detachServiceProjectAttachmentSettings, this.listDiscoveredServicesSettings, this.getDiscoveredServiceSettings, this.lookupDiscoveredServiceSettings, this.listServicesSettings, this.createServiceSettings, this.getServiceSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateServiceSettings, this.deleteServiceSettings, this.listDiscoveredWorkloadsSettings, this.getDiscoveredWorkloadSettings, this.lookupDiscoveredWorkloadSettings, this.listWorkloadsSettings, this.createWorkloadSettings, this.getWorkloadSettings, this.updateWorkloadSettings, this.deleteWorkloadSettings, this.listApplicationsSettings, this.createApplicationSettings, this.getApplicationSettings, this.updateApplicationSettings, this.deleteApplicationSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AppHubStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AppHubStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AppHubStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AppHubStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AppHubStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AppHubStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AppHubStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AppHubStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.lookupServiceProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listServiceProjectAttachmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createServiceProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getServiceProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteServiceProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.detachServiceProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDiscoveredServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDiscoveredServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.lookupDiscoveredServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDiscoveredWorkloadsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDiscoveredWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.lookupDiscoveredWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listWorkloadsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listApplicationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createServiceProjectAttachmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceProjectAttachment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteServiceProjectAttachmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Service.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Service.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createWorkloadOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workload.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateWorkloadOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workload.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteWorkloadOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Application.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Application.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<LookupServiceProjectAttachmentRequest, LookupServiceProjectAttachmentResponse> lookupServiceProjectAttachmentSettings() {
            return this.lookupServiceProjectAttachmentSettings;
        }

        public PagedCallSettings.Builder<ListServiceProjectAttachmentsRequest, ListServiceProjectAttachmentsResponse, AppHubClient.ListServiceProjectAttachmentsPagedResponse> listServiceProjectAttachmentsSettings() {
            return this.listServiceProjectAttachmentsSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceProjectAttachmentRequest, Operation> createServiceProjectAttachmentSettings() {
            return this.createServiceProjectAttachmentSettings;
        }

        public OperationCallSettings.Builder<CreateServiceProjectAttachmentRequest, ServiceProjectAttachment, OperationMetadata> createServiceProjectAttachmentOperationSettings() {
            return this.createServiceProjectAttachmentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetServiceProjectAttachmentRequest, ServiceProjectAttachment> getServiceProjectAttachmentSettings() {
            return this.getServiceProjectAttachmentSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceProjectAttachmentRequest, Operation> deleteServiceProjectAttachmentSettings() {
            return this.deleteServiceProjectAttachmentSettings;
        }

        public OperationCallSettings.Builder<DeleteServiceProjectAttachmentRequest, Empty, OperationMetadata> deleteServiceProjectAttachmentOperationSettings() {
            return this.deleteServiceProjectAttachmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DetachServiceProjectAttachmentRequest, DetachServiceProjectAttachmentResponse> detachServiceProjectAttachmentSettings() {
            return this.detachServiceProjectAttachmentSettings;
        }

        public PagedCallSettings.Builder<ListDiscoveredServicesRequest, ListDiscoveredServicesResponse, AppHubClient.ListDiscoveredServicesPagedResponse> listDiscoveredServicesSettings() {
            return this.listDiscoveredServicesSettings;
        }

        public UnaryCallSettings.Builder<GetDiscoveredServiceRequest, DiscoveredService> getDiscoveredServiceSettings() {
            return this.getDiscoveredServiceSettings;
        }

        public UnaryCallSettings.Builder<LookupDiscoveredServiceRequest, LookupDiscoveredServiceResponse> lookupDiscoveredServiceSettings() {
            return this.lookupDiscoveredServiceSettings;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, AppHubClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceRequest, Operation> createServiceSettings() {
            return this.createServiceSettings;
        }

        public OperationCallSettings.Builder<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings() {
            return this.createServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceRequest, Operation> updateServiceSettings() {
            return this.updateServiceSettings;
        }

        public OperationCallSettings.Builder<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings() {
            return this.updateServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings() {
            return this.deleteServiceSettings;
        }

        public OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings() {
            return this.deleteServiceOperationSettings;
        }

        public PagedCallSettings.Builder<ListDiscoveredWorkloadsRequest, ListDiscoveredWorkloadsResponse, AppHubClient.ListDiscoveredWorkloadsPagedResponse> listDiscoveredWorkloadsSettings() {
            return this.listDiscoveredWorkloadsSettings;
        }

        public UnaryCallSettings.Builder<GetDiscoveredWorkloadRequest, DiscoveredWorkload> getDiscoveredWorkloadSettings() {
            return this.getDiscoveredWorkloadSettings;
        }

        public UnaryCallSettings.Builder<LookupDiscoveredWorkloadRequest, LookupDiscoveredWorkloadResponse> lookupDiscoveredWorkloadSettings() {
            return this.lookupDiscoveredWorkloadSettings;
        }

        public PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, AppHubClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
            return this.listWorkloadsSettings;
        }

        public UnaryCallSettings.Builder<CreateWorkloadRequest, Operation> createWorkloadSettings() {
            return this.createWorkloadSettings;
        }

        public OperationCallSettings.Builder<CreateWorkloadRequest, Workload, OperationMetadata> createWorkloadOperationSettings() {
            return this.createWorkloadOperationSettings;
        }

        public UnaryCallSettings.Builder<GetWorkloadRequest, Workload> getWorkloadSettings() {
            return this.getWorkloadSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkloadRequest, Operation> updateWorkloadSettings() {
            return this.updateWorkloadSettings;
        }

        public OperationCallSettings.Builder<UpdateWorkloadRequest, Workload, OperationMetadata> updateWorkloadOperationSettings() {
            return this.updateWorkloadOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkloadRequest, Operation> deleteWorkloadSettings() {
            return this.deleteWorkloadSettings;
        }

        public OperationCallSettings.Builder<DeleteWorkloadRequest, Empty, OperationMetadata> deleteWorkloadOperationSettings() {
            return this.deleteWorkloadOperationSettings;
        }

        public PagedCallSettings.Builder<ListApplicationsRequest, ListApplicationsResponse, AppHubClient.ListApplicationsPagedResponse> listApplicationsSettings() {
            return this.listApplicationsSettings;
        }

        public UnaryCallSettings.Builder<CreateApplicationRequest, Operation> createApplicationSettings() {
            return this.createApplicationSettings;
        }

        public OperationCallSettings.Builder<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings() {
            return this.createApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings() {
            return this.getApplicationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApplicationRequest, Operation> updateApplicationSettings() {
            return this.updateApplicationSettings;
        }

        public OperationCallSettings.Builder<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings() {
            return this.updateApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteApplicationRequest, Operation> deleteApplicationSettings() {
            return this.deleteApplicationSettings;
        }

        public OperationCallSettings.Builder<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings() {
            return this.deleteApplicationOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AppHubClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public AppHubStubSettings build() throws IOException {
            return new AppHubStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

