/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.appengine.v1.Application;
import com.google.appengine.v1.CreateApplicationRequest;
import com.google.appengine.v1.GetApplicationRequest;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.RepairApplicationRequest;
import com.google.appengine.v1.UpdateApplicationRequest;
import com.google.appengine.v1.stub.ApplicationsStub;
import com.google.appengine.v1.stub.GrpcApplicationsStub;
import com.google.appengine.v1.stub.HttpJsonApplicationsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ApplicationsStubSettings
extends StubSettings<ApplicationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/appengine.admin").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings;
    private final UnaryCallSettings<CreateApplicationRequest, Operation> createApplicationSettings;
    private final OperationCallSettings<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationSettings;
    private final UnaryCallSettings<UpdateApplicationRequest, Operation> updateApplicationSettings;
    private final OperationCallSettings<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationSettings;
    private final UnaryCallSettings<RepairApplicationRequest, Operation> repairApplicationSettings;
    private final OperationCallSettings<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationSettings;

    public UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings() {
        return this.getApplicationSettings;
    }

    public UnaryCallSettings<CreateApplicationRequest, Operation> createApplicationSettings() {
        return this.createApplicationSettings;
    }

    public OperationCallSettings<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationSettings() {
        return this.createApplicationOperationSettings;
    }

    public UnaryCallSettings<UpdateApplicationRequest, Operation> updateApplicationSettings() {
        return this.updateApplicationSettings;
    }

    public OperationCallSettings<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationSettings() {
        return this.updateApplicationOperationSettings;
    }

    public UnaryCallSettings<RepairApplicationRequest, Operation> repairApplicationSettings() {
        return this.repairApplicationSettings;
    }

    public OperationCallSettings<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationSettings() {
        return this.repairApplicationOperationSettings;
    }

    public ApplicationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcApplicationsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonApplicationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "appengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "appengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApplicationsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApplicationsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApplicationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApplicationsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApplicationsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getApplicationSettings = settingsBuilder.getApplicationSettings().build();
        this.createApplicationSettings = settingsBuilder.createApplicationSettings().build();
        this.createApplicationOperationSettings = settingsBuilder.createApplicationOperationSettings().build();
        this.updateApplicationSettings = settingsBuilder.updateApplicationSettings().build();
        this.updateApplicationOperationSettings = settingsBuilder.updateApplicationOperationSettings().build();
        this.repairApplicationSettings = settingsBuilder.repairApplicationSettings().build();
        this.repairApplicationOperationSettings = settingsBuilder.repairApplicationOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApplicationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings;
        private final UnaryCallSettings.Builder<CreateApplicationRequest, Operation> createApplicationSettings;
        private final OperationCallSettings.Builder<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationSettings;
        private final UnaryCallSettings.Builder<UpdateApplicationRequest, Operation> updateApplicationSettings;
        private final OperationCallSettings.Builder<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationSettings;
        private final UnaryCallSettings.Builder<RepairApplicationRequest, Operation> repairApplicationSettings;
        private final OperationCallSettings.Builder<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.updateApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.repairApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.repairApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getApplicationSettings, this.createApplicationSettings, this.updateApplicationSettings, this.repairApplicationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ApplicationsStubSettings settings) {
            super((StubSettings)settings);
            this.getApplicationSettings = settings.getApplicationSettings.toBuilder();
            this.createApplicationSettings = settings.createApplicationSettings.toBuilder();
            this.createApplicationOperationSettings = settings.createApplicationOperationSettings.toBuilder();
            this.updateApplicationSettings = settings.updateApplicationSettings.toBuilder();
            this.updateApplicationOperationSettings = settings.updateApplicationOperationSettings.toBuilder();
            this.repairApplicationSettings = settings.repairApplicationSettings.toBuilder();
            this.repairApplicationOperationSettings = settings.repairApplicationOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getApplicationSettings, this.createApplicationSettings, this.updateApplicationSettings, this.repairApplicationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApplicationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApplicationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApplicationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ApplicationsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ApplicationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ApplicationsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ApplicationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApplicationsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ApplicationsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ApplicationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.repairApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Application.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Application.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.repairApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Application.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings() {
            return this.getApplicationSettings;
        }

        public UnaryCallSettings.Builder<CreateApplicationRequest, Operation> createApplicationSettings() {
            return this.createApplicationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationSettings() {
            return this.createApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApplicationRequest, Operation> updateApplicationSettings() {
            return this.updateApplicationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationSettings() {
            return this.updateApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<RepairApplicationRequest, Operation> repairApplicationSettings() {
            return this.repairApplicationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationSettings() {
            return this.repairApplicationOperationSettings;
        }

        public ApplicationsStubSettings build() throws IOException {
            return new ApplicationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

