/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.AuthorizedCertificate;
import com.google.appengine.v1.AuthorizedCertificatesClient;
import com.google.appengine.v1.CreateAuthorizedCertificateRequest;
import com.google.appengine.v1.DeleteAuthorizedCertificateRequest;
import com.google.appengine.v1.GetAuthorizedCertificateRequest;
import com.google.appengine.v1.ListAuthorizedCertificatesRequest;
import com.google.appengine.v1.ListAuthorizedCertificatesResponse;
import com.google.appengine.v1.UpdateAuthorizedCertificateRequest;
import com.google.appengine.v1.stub.AuthorizedCertificatesStub;
import com.google.appengine.v1.stub.GrpcAuthorizedCertificatesStub;
import com.google.appengine.v1.stub.HttpJsonAuthorizedCertificatesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AuthorizedCertificatesStubSettings
extends StubSettings<AuthorizedCertificatesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/appengine.admin").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse> listAuthorizedCertificatesSettings;
    private final UnaryCallSettings<GetAuthorizedCertificateRequest, AuthorizedCertificate> getAuthorizedCertificateSettings;
    private final UnaryCallSettings<CreateAuthorizedCertificateRequest, AuthorizedCertificate> createAuthorizedCertificateSettings;
    private final UnaryCallSettings<UpdateAuthorizedCertificateRequest, AuthorizedCertificate> updateAuthorizedCertificateSettings;
    private final UnaryCallSettings<DeleteAuthorizedCertificateRequest, Empty> deleteAuthorizedCertificateSettings;
    private static final PagedListDescriptor<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificate> LIST_AUTHORIZED_CERTIFICATES_PAGE_STR_DESC = new PagedListDescriptor<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificate>(){

        public String emptyToken() {
            return "";
        }

        public ListAuthorizedCertificatesRequest injectToken(ListAuthorizedCertificatesRequest payload, String token) {
            return ListAuthorizedCertificatesRequest.newBuilder((ListAuthorizedCertificatesRequest)payload).setPageToken(token).build();
        }

        public ListAuthorizedCertificatesRequest injectPageSize(ListAuthorizedCertificatesRequest payload, int pageSize) {
            return ListAuthorizedCertificatesRequest.newBuilder((ListAuthorizedCertificatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAuthorizedCertificatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAuthorizedCertificatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AuthorizedCertificate> extractResources(ListAuthorizedCertificatesResponse payload) {
            return payload.getCertificatesList() == null ? ImmutableList.of() : payload.getCertificatesList();
        }
    };
    private static final PagedListResponseFactory<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse> LIST_AUTHORIZED_CERTIFICATES_PAGE_STR_FACT = new PagedListResponseFactory<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse>(){

        public ApiFuture<AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse> callable, ListAuthorizedCertificatesRequest request, ApiCallContext context, ApiFuture<ListAuthorizedCertificatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTHORIZED_CERTIFICATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse.createAsync((PageContext<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificate>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse> listAuthorizedCertificatesSettings() {
        return this.listAuthorizedCertificatesSettings;
    }

    public UnaryCallSettings<GetAuthorizedCertificateRequest, AuthorizedCertificate> getAuthorizedCertificateSettings() {
        return this.getAuthorizedCertificateSettings;
    }

    public UnaryCallSettings<CreateAuthorizedCertificateRequest, AuthorizedCertificate> createAuthorizedCertificateSettings() {
        return this.createAuthorizedCertificateSettings;
    }

    public UnaryCallSettings<UpdateAuthorizedCertificateRequest, AuthorizedCertificate> updateAuthorizedCertificateSettings() {
        return this.updateAuthorizedCertificateSettings;
    }

    public UnaryCallSettings<DeleteAuthorizedCertificateRequest, Empty> deleteAuthorizedCertificateSettings() {
        return this.deleteAuthorizedCertificateSettings;
    }

    public AuthorizedCertificatesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAuthorizedCertificatesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAuthorizedCertificatesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return AuthorizedCertificatesStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "appengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "appengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "appengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AuthorizedCertificatesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AuthorizedCertificatesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AuthorizedCertificatesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AuthorizedCertificatesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AuthorizedCertificatesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAuthorizedCertificatesSettings = settingsBuilder.listAuthorizedCertificatesSettings().build();
        this.getAuthorizedCertificateSettings = settingsBuilder.getAuthorizedCertificateSettings().build();
        this.createAuthorizedCertificateSettings = settingsBuilder.createAuthorizedCertificateSettings().build();
        this.updateAuthorizedCertificateSettings = settingsBuilder.updateAuthorizedCertificateSettings().build();
        this.deleteAuthorizedCertificateSettings = settingsBuilder.deleteAuthorizedCertificateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AuthorizedCertificatesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse> listAuthorizedCertificatesSettings;
        private final UnaryCallSettings.Builder<GetAuthorizedCertificateRequest, AuthorizedCertificate> getAuthorizedCertificateSettings;
        private final UnaryCallSettings.Builder<CreateAuthorizedCertificateRequest, AuthorizedCertificate> createAuthorizedCertificateSettings;
        private final UnaryCallSettings.Builder<UpdateAuthorizedCertificateRequest, AuthorizedCertificate> updateAuthorizedCertificateSettings;
        private final UnaryCallSettings.Builder<DeleteAuthorizedCertificateRequest, Empty> deleteAuthorizedCertificateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAuthorizedCertificatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTHORIZED_CERTIFICATES_PAGE_STR_FACT);
            this.getAuthorizedCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAuthorizedCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAuthorizedCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAuthorizedCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAuthorizedCertificatesSettings, this.getAuthorizedCertificateSettings, this.createAuthorizedCertificateSettings, this.updateAuthorizedCertificateSettings, this.deleteAuthorizedCertificateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AuthorizedCertificatesStubSettings settings) {
            super((StubSettings)settings);
            this.listAuthorizedCertificatesSettings = settings.listAuthorizedCertificatesSettings.toBuilder();
            this.getAuthorizedCertificateSettings = settings.getAuthorizedCertificateSettings.toBuilder();
            this.createAuthorizedCertificateSettings = settings.createAuthorizedCertificateSettings.toBuilder();
            this.updateAuthorizedCertificateSettings = settings.updateAuthorizedCertificateSettings.toBuilder();
            this.deleteAuthorizedCertificateSettings = settings.deleteAuthorizedCertificateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAuthorizedCertificatesSettings, this.getAuthorizedCertificateSettings, this.createAuthorizedCertificateSettings, this.updateAuthorizedCertificateSettings, this.deleteAuthorizedCertificateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AuthorizedCertificatesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AuthorizedCertificatesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AuthorizedCertificatesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AuthorizedCertificatesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AuthorizedCertificatesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AuthorizedCertificatesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AuthorizedCertificatesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AuthorizedCertificatesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAuthorizedCertificatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getAuthorizedCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createAuthorizedCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateAuthorizedCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteAuthorizedCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAuthorizedCertificatesRequest, ListAuthorizedCertificatesResponse, AuthorizedCertificatesClient.ListAuthorizedCertificatesPagedResponse> listAuthorizedCertificatesSettings() {
            return this.listAuthorizedCertificatesSettings;
        }

        public UnaryCallSettings.Builder<GetAuthorizedCertificateRequest, AuthorizedCertificate> getAuthorizedCertificateSettings() {
            return this.getAuthorizedCertificateSettings;
        }

        public UnaryCallSettings.Builder<CreateAuthorizedCertificateRequest, AuthorizedCertificate> createAuthorizedCertificateSettings() {
            return this.createAuthorizedCertificateSettings;
        }

        public UnaryCallSettings.Builder<UpdateAuthorizedCertificateRequest, AuthorizedCertificate> updateAuthorizedCertificateSettings() {
            return this.updateAuthorizedCertificateSettings;
        }

        public UnaryCallSettings.Builder<DeleteAuthorizedCertificateRequest, Empty> deleteAuthorizedCertificateSettings() {
            return this.deleteAuthorizedCertificateSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return AuthorizedCertificatesStubSettings.getDefaultEndpoint();
        }

        public AuthorizedCertificatesStubSettings build() throws IOException {
            return new AuthorizedCertificatesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

