/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.CreateVersionMetadataV1;
import com.google.appengine.v1.CreateVersionRequest;
import com.google.appengine.v1.DeleteVersionRequest;
import com.google.appengine.v1.GetVersionRequest;
import com.google.appengine.v1.ListVersionsRequest;
import com.google.appengine.v1.ListVersionsResponse;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.UpdateVersionRequest;
import com.google.appengine.v1.Version;
import com.google.appengine.v1.VersionsClient;
import com.google.appengine.v1.stub.GrpcVersionsStub;
import com.google.appengine.v1.stub.VersionsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class VersionsStubSettings
extends StubSettings<VersionsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/appengine.admin").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListVersionsRequest, ListVersionsResponse, VersionsClient.ListVersionsPagedResponse> listVersionsSettings;
    private final UnaryCallSettings<GetVersionRequest, Version> getVersionSettings;
    private final UnaryCallSettings<CreateVersionRequest, Operation> createVersionSettings;
    private final OperationCallSettings<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationSettings;
    private final UnaryCallSettings<UpdateVersionRequest, Operation> updateVersionSettings;
    private final OperationCallSettings<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationSettings;
    private final UnaryCallSettings<DeleteVersionRequest, Operation> deleteVersionSettings;
    private final OperationCallSettings<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationSettings;
    private static final PagedListDescriptor<ListVersionsRequest, ListVersionsResponse, Version> LIST_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListVersionsRequest, ListVersionsResponse, Version>(){

        public String emptyToken() {
            return "";
        }

        public ListVersionsRequest injectToken(ListVersionsRequest payload, String token) {
            return ListVersionsRequest.newBuilder((ListVersionsRequest)payload).setPageToken(token).build();
        }

        public ListVersionsRequest injectPageSize(ListVersionsRequest payload, int pageSize) {
            return ListVersionsRequest.newBuilder((ListVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Version> extractResources(ListVersionsResponse payload) {
            return payload.getVersionsList() == null ? ImmutableList.of() : payload.getVersionsList();
        }
    };
    private static final PagedListResponseFactory<ListVersionsRequest, ListVersionsResponse, VersionsClient.ListVersionsPagedResponse> LIST_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListVersionsRequest, ListVersionsResponse, VersionsClient.ListVersionsPagedResponse>(){

        public ApiFuture<VersionsClient.ListVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVersionsRequest, ListVersionsResponse> callable, ListVersionsRequest request, ApiCallContext context, ApiFuture<ListVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VersionsClient.ListVersionsPagedResponse.createAsync((PageContext<ListVersionsRequest, ListVersionsResponse, Version>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListVersionsRequest, ListVersionsResponse, VersionsClient.ListVersionsPagedResponse> listVersionsSettings() {
        return this.listVersionsSettings;
    }

    public UnaryCallSettings<GetVersionRequest, Version> getVersionSettings() {
        return this.getVersionSettings;
    }

    public UnaryCallSettings<CreateVersionRequest, Operation> createVersionSettings() {
        return this.createVersionSettings;
    }

    public OperationCallSettings<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationSettings() {
        return this.createVersionOperationSettings;
    }

    public UnaryCallSettings<UpdateVersionRequest, Operation> updateVersionSettings() {
        return this.updateVersionSettings;
    }

    public OperationCallSettings<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationSettings() {
        return this.updateVersionOperationSettings;
    }

    public UnaryCallSettings<DeleteVersionRequest, Operation> deleteVersionSettings() {
        return this.deleteVersionSettings;
    }

    public OperationCallSettings<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationSettings() {
        return this.deleteVersionOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VersionsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcVersionsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "appengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "appengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VersionsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VersionsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VersionsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listVersionsSettings = settingsBuilder.listVersionsSettings().build();
        this.getVersionSettings = settingsBuilder.getVersionSettings().build();
        this.createVersionSettings = settingsBuilder.createVersionSettings().build();
        this.createVersionOperationSettings = settingsBuilder.createVersionOperationSettings().build();
        this.updateVersionSettings = settingsBuilder.updateVersionSettings().build();
        this.updateVersionOperationSettings = settingsBuilder.updateVersionOperationSettings().build();
        this.deleteVersionSettings = settingsBuilder.deleteVersionSettings().build();
        this.deleteVersionOperationSettings = settingsBuilder.deleteVersionOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VersionsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListVersionsRequest, ListVersionsResponse, VersionsClient.ListVersionsPagedResponse> listVersionsSettings;
        private final UnaryCallSettings.Builder<GetVersionRequest, Version> getVersionSettings;
        private final UnaryCallSettings.Builder<CreateVersionRequest, Operation> createVersionSettings;
        private final OperationCallSettings.Builder<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateVersionRequest, Operation> updateVersionSettings;
        private final OperationCallSettings.Builder<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteVersionRequest, Operation> deleteVersionSettings;
        private final OperationCallSettings.Builder<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VERSIONS_PAGE_STR_FACT);
            this.getVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVersionOperationSettings = OperationCallSettings.newBuilder();
            this.updateVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVersionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteVersionOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listVersionsSettings, this.getVersionSettings, this.createVersionSettings, this.updateVersionSettings, this.deleteVersionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(VersionsStubSettings settings) {
            super((StubSettings)settings);
            this.listVersionsSettings = settings.listVersionsSettings.toBuilder();
            this.getVersionSettings = settings.getVersionSettings.toBuilder();
            this.createVersionSettings = settings.createVersionSettings.toBuilder();
            this.createVersionOperationSettings = settings.createVersionOperationSettings.toBuilder();
            this.updateVersionSettings = settings.updateVersionSettings.toBuilder();
            this.updateVersionOperationSettings = settings.updateVersionOperationSettings.toBuilder();
            this.deleteVersionSettings = settings.deleteVersionSettings.toBuilder();
            this.deleteVersionOperationSettings = settings.deleteVersionOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listVersionsSettings, this.getVersionSettings, this.createVersionSettings, this.updateVersionSettings, this.deleteVersionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VersionsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VersionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VersionsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(VersionsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(VersionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Version.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateVersionMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Version.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteVersionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListVersionsRequest, ListVersionsResponse, VersionsClient.ListVersionsPagedResponse> listVersionsSettings() {
            return this.listVersionsSettings;
        }

        public UnaryCallSettings.Builder<GetVersionRequest, Version> getVersionSettings() {
            return this.getVersionSettings;
        }

        public UnaryCallSettings.Builder<CreateVersionRequest, Operation> createVersionSettings() {
            return this.createVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationSettings() {
            return this.createVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateVersionRequest, Operation> updateVersionSettings() {
            return this.updateVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationSettings() {
            return this.updateVersionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteVersionRequest, Operation> deleteVersionSettings() {
            return this.deleteVersionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationSettings() {
            return this.deleteVersionOperationSettings;
        }

        public VersionsStubSettings build() throws IOException {
            return new VersionsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

