/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.apikeys.v2.stub;

import com.google.api.apikeys.v2.ApiKeysClient;
import com.google.api.apikeys.v2.CreateKeyRequest;
import com.google.api.apikeys.v2.DeleteKeyRequest;
import com.google.api.apikeys.v2.GetKeyRequest;
import com.google.api.apikeys.v2.GetKeyStringRequest;
import com.google.api.apikeys.v2.GetKeyStringResponse;
import com.google.api.apikeys.v2.Key;
import com.google.api.apikeys.v2.ListKeysRequest;
import com.google.api.apikeys.v2.ListKeysResponse;
import com.google.api.apikeys.v2.LookupKeyRequest;
import com.google.api.apikeys.v2.LookupKeyResponse;
import com.google.api.apikeys.v2.UndeleteKeyRequest;
import com.google.api.apikeys.v2.UpdateKeyRequest;
import com.google.api.apikeys.v2.stub.ApiKeysStub;
import com.google.api.apikeys.v2.stub.ApiKeysStubSettings;
import com.google.api.apikeys.v2.stub.HttpJsonApiKeysCallableFactory;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonApiKeysStub
extends ApiKeysStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Key.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateKeyRequest, Operation> createKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/CreateKey").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/keys", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "keyId", (Object)request.getKeyId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("key", (Message)request.getKey(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListKeysRequest, ListKeysResponse> listKeysMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/ListKeys").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/keys", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListKeysResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetKeyRequest, Key> getKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/GetKey").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/keys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Key.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetKeyStringRequest, GetKeyStringResponse> getKeyStringMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/GetKeyString").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/keys/*}/keyString", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GetKeyStringResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateKeyRequest, Operation> updateKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/UpdateKey").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{key.name=projects/*/locations/*/keys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "key.name", (Object)request.getKey().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("key", (Message)request.getKey(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteKeyRequest, Operation> deleteKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/DeleteKey").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/keys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UndeleteKeyRequest, Operation> undeleteKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/UndeleteKey").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/keys/*}:undelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<LookupKeyRequest, LookupKeyResponse> lookupKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.apikeys.v2.ApiKeys/LookupKey").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/keys:lookupKey", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "keyString", (Object)request.getKeyString());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)LookupKeyResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateKeyRequest, Operation> createKeyCallable;
    private final OperationCallable<CreateKeyRequest, Key, Empty> createKeyOperationCallable;
    private final UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable;
    private final UnaryCallable<ListKeysRequest, ApiKeysClient.ListKeysPagedResponse> listKeysPagedCallable;
    private final UnaryCallable<GetKeyRequest, Key> getKeyCallable;
    private final UnaryCallable<GetKeyStringRequest, GetKeyStringResponse> getKeyStringCallable;
    private final UnaryCallable<UpdateKeyRequest, Operation> updateKeyCallable;
    private final OperationCallable<UpdateKeyRequest, Key, Empty> updateKeyOperationCallable;
    private final UnaryCallable<DeleteKeyRequest, Operation> deleteKeyCallable;
    private final OperationCallable<DeleteKeyRequest, Key, Empty> deleteKeyOperationCallable;
    private final UnaryCallable<UndeleteKeyRequest, Operation> undeleteKeyCallable;
    private final OperationCallable<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationCallable;
    private final UnaryCallable<LookupKeyRequest, LookupKeyResponse> lookupKeyCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonApiKeysStub create(ApiKeysStubSettings settings) throws IOException {
        return new HttpJsonApiKeysStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonApiKeysStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonApiKeysStub(ApiKeysStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonApiKeysStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonApiKeysStub(ApiKeysStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonApiKeysStub(ApiKeysStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonApiKeysCallableFactory());
    }

    protected HttpJsonApiKeysStub(ApiKeysStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listKeysTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listKeysMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getKeyStringTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getKeyStringMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings undeleteKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(undeleteKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings lookupKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(lookupKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createKeyCallable = callableFactory.createUnaryCallable(createKeyTransportSettings, settings.createKeySettings(), clientContext);
        this.createKeyOperationCallable = callableFactory.createOperationCallable(createKeyTransportSettings, settings.createKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listKeysCallable = callableFactory.createUnaryCallable(listKeysTransportSettings, settings.listKeysSettings(), clientContext);
        this.listKeysPagedCallable = callableFactory.createPagedCallable(listKeysTransportSettings, settings.listKeysSettings(), clientContext);
        this.getKeyCallable = callableFactory.createUnaryCallable(getKeyTransportSettings, settings.getKeySettings(), clientContext);
        this.getKeyStringCallable = callableFactory.createUnaryCallable(getKeyStringTransportSettings, settings.getKeyStringSettings(), clientContext);
        this.updateKeyCallable = callableFactory.createUnaryCallable(updateKeyTransportSettings, settings.updateKeySettings(), clientContext);
        this.updateKeyOperationCallable = callableFactory.createOperationCallable(updateKeyTransportSettings, settings.updateKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteKeyCallable = callableFactory.createUnaryCallable(deleteKeyTransportSettings, settings.deleteKeySettings(), clientContext);
        this.deleteKeyOperationCallable = callableFactory.createOperationCallable(deleteKeyTransportSettings, settings.deleteKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.undeleteKeyCallable = callableFactory.createUnaryCallable(undeleteKeyTransportSettings, settings.undeleteKeySettings(), clientContext);
        this.undeleteKeyOperationCallable = callableFactory.createOperationCallable(undeleteKeyTransportSettings, settings.undeleteKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.lookupKeyCallable = callableFactory.createUnaryCallable(lookupKeyTransportSettings, settings.lookupKeySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createKeyMethodDescriptor);
        methodDescriptors.add(listKeysMethodDescriptor);
        methodDescriptors.add(getKeyMethodDescriptor);
        methodDescriptors.add(getKeyStringMethodDescriptor);
        methodDescriptors.add(updateKeyMethodDescriptor);
        methodDescriptors.add(deleteKeyMethodDescriptor);
        methodDescriptors.add(undeleteKeyMethodDescriptor);
        methodDescriptors.add(lookupKeyMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateKeyRequest, Operation> createKeyCallable() {
        return this.createKeyCallable;
    }

    @Override
    public OperationCallable<CreateKeyRequest, Key, Empty> createKeyOperationCallable() {
        return this.createKeyOperationCallable;
    }

    @Override
    public UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable() {
        return this.listKeysCallable;
    }

    @Override
    public UnaryCallable<ListKeysRequest, ApiKeysClient.ListKeysPagedResponse> listKeysPagedCallable() {
        return this.listKeysPagedCallable;
    }

    @Override
    public UnaryCallable<GetKeyRequest, Key> getKeyCallable() {
        return this.getKeyCallable;
    }

    @Override
    public UnaryCallable<GetKeyStringRequest, GetKeyStringResponse> getKeyStringCallable() {
        return this.getKeyStringCallable;
    }

    @Override
    public UnaryCallable<UpdateKeyRequest, Operation> updateKeyCallable() {
        return this.updateKeyCallable;
    }

    @Override
    public OperationCallable<UpdateKeyRequest, Key, Empty> updateKeyOperationCallable() {
        return this.updateKeyOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteKeyRequest, Operation> deleteKeyCallable() {
        return this.deleteKeyCallable;
    }

    @Override
    public OperationCallable<DeleteKeyRequest, Key, Empty> deleteKeyOperationCallable() {
        return this.deleteKeyOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteKeyRequest, Operation> undeleteKeyCallable() {
        return this.undeleteKeyCallable;
    }

    @Override
    public OperationCallable<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationCallable() {
        return this.undeleteKeyOperationCallable;
    }

    @Override
    public UnaryCallable<LookupKeyRequest, LookupKeyResponse> lookupKeyCallable() {
        return this.lookupKeyCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

