/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubPluginSettings;
import com.google.cloud.apihub.v1.DisablePluginRequest;
import com.google.cloud.apihub.v1.EnablePluginRequest;
import com.google.cloud.apihub.v1.GetPluginRequest;
import com.google.cloud.apihub.v1.Plugin;
import com.google.cloud.apihub.v1.PluginName;
import com.google.cloud.apihub.v1.stub.ApiHubPluginStub;
import com.google.cloud.apihub.v1.stub.ApiHubPluginStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiHubPluginClient
implements BackgroundResource {
    private final ApiHubPluginSettings settings;
    private final ApiHubPluginStub stub;

    public static final ApiHubPluginClient create() throws IOException {
        return ApiHubPluginClient.create(ApiHubPluginSettings.newBuilder().build());
    }

    public static final ApiHubPluginClient create(ApiHubPluginSettings settings) throws IOException {
        return new ApiHubPluginClient(settings);
    }

    public static final ApiHubPluginClient create(ApiHubPluginStub stub) {
        return new ApiHubPluginClient(stub);
    }

    protected ApiHubPluginClient(ApiHubPluginSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiHubPluginStubSettings)settings.getStubSettings()).createStub();
    }

    protected ApiHubPluginClient(ApiHubPluginStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ApiHubPluginSettings getSettings() {
        return this.settings;
    }

    public ApiHubPluginStub getStub() {
        return this.stub;
    }

    public final Plugin getPlugin(PluginName name) {
        GetPluginRequest request = GetPluginRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPlugin(request);
    }

    public final Plugin getPlugin(String name) {
        GetPluginRequest request = GetPluginRequest.newBuilder().setName(name).build();
        return this.getPlugin(request);
    }

    public final Plugin getPlugin(GetPluginRequest request) {
        return (Plugin)this.getPluginCallable().call((Object)request);
    }

    public final UnaryCallable<GetPluginRequest, Plugin> getPluginCallable() {
        return this.stub.getPluginCallable();
    }

    public final Plugin enablePlugin(PluginName name) {
        EnablePluginRequest request = EnablePluginRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.enablePlugin(request);
    }

    public final Plugin enablePlugin(String name) {
        EnablePluginRequest request = EnablePluginRequest.newBuilder().setName(name).build();
        return this.enablePlugin(request);
    }

    public final Plugin enablePlugin(EnablePluginRequest request) {
        return (Plugin)this.enablePluginCallable().call((Object)request);
    }

    public final UnaryCallable<EnablePluginRequest, Plugin> enablePluginCallable() {
        return this.stub.enablePluginCallable();
    }

    public final Plugin disablePlugin(PluginName name) {
        DisablePluginRequest request = DisablePluginRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disablePlugin(request);
    }

    public final Plugin disablePlugin(String name) {
        DisablePluginRequest request = DisablePluginRequest.newBuilder().setName(name).build();
        return this.disablePlugin(request);
    }

    public final Plugin disablePlugin(DisablePluginRequest request) {
        return (Plugin)this.disablePluginCallable().call((Object)request);
    }

    public final UnaryCallable<DisablePluginRequest, Plugin> disablePluginCallable() {
        return this.stub.disablePluginCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

