/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ActionExecutionDetail;
import com.google.cloud.apihub.v1.ApiHubPluginSettings;
import com.google.cloud.apihub.v1.CreatePluginInstanceRequest;
import com.google.cloud.apihub.v1.CreatePluginRequest;
import com.google.cloud.apihub.v1.DeletePluginInstanceRequest;
import com.google.cloud.apihub.v1.DeletePluginRequest;
import com.google.cloud.apihub.v1.DisablePluginInstanceActionRequest;
import com.google.cloud.apihub.v1.DisablePluginInstanceActionResponse;
import com.google.cloud.apihub.v1.DisablePluginRequest;
import com.google.cloud.apihub.v1.EnablePluginInstanceActionRequest;
import com.google.cloud.apihub.v1.EnablePluginInstanceActionResponse;
import com.google.cloud.apihub.v1.EnablePluginRequest;
import com.google.cloud.apihub.v1.ExecutePluginInstanceActionRequest;
import com.google.cloud.apihub.v1.ExecutePluginInstanceActionResponse;
import com.google.cloud.apihub.v1.GetPluginInstanceRequest;
import com.google.cloud.apihub.v1.GetPluginRequest;
import com.google.cloud.apihub.v1.ListPluginInstancesRequest;
import com.google.cloud.apihub.v1.ListPluginInstancesResponse;
import com.google.cloud.apihub.v1.ListPluginsRequest;
import com.google.cloud.apihub.v1.ListPluginsResponse;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.OperationMetadata;
import com.google.cloud.apihub.v1.Plugin;
import com.google.cloud.apihub.v1.PluginInstance;
import com.google.cloud.apihub.v1.PluginInstanceName;
import com.google.cloud.apihub.v1.PluginName;
import com.google.cloud.apihub.v1.UpdatePluginInstanceRequest;
import com.google.cloud.apihub.v1.stub.ApiHubPluginStub;
import com.google.cloud.apihub.v1.stub.ApiHubPluginStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiHubPluginClient
implements BackgroundResource {
    private final ApiHubPluginSettings settings;
    private final ApiHubPluginStub stub;
    private final OperationsClient httpJsonOperationsClient;

    public static final ApiHubPluginClient create() throws IOException {
        return ApiHubPluginClient.create(ApiHubPluginSettings.newBuilder().build());
    }

    public static final ApiHubPluginClient create(ApiHubPluginSettings settings) throws IOException {
        return new ApiHubPluginClient(settings);
    }

    public static final ApiHubPluginClient create(ApiHubPluginStub stub) {
        return new ApiHubPluginClient(stub);
    }

    protected ApiHubPluginClient(ApiHubPluginSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiHubPluginStubSettings)settings.getStubSettings()).createStub();
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ApiHubPluginClient(ApiHubPluginStub stub) {
        this.settings = null;
        this.stub = stub;
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ApiHubPluginSettings getSettings() {
        return this.settings;
    }

    public ApiHubPluginStub getStub() {
        return this.stub;
    }

    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Plugin getPlugin(PluginName name) {
        GetPluginRequest request = GetPluginRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPlugin(request);
    }

    public final Plugin getPlugin(String name) {
        GetPluginRequest request = GetPluginRequest.newBuilder().setName(name).build();
        return this.getPlugin(request);
    }

    public final Plugin getPlugin(GetPluginRequest request) {
        return (Plugin)this.getPluginCallable().call((Object)request);
    }

    public final UnaryCallable<GetPluginRequest, Plugin> getPluginCallable() {
        return this.stub.getPluginCallable();
    }

    public final Plugin enablePlugin(PluginName name) {
        EnablePluginRequest request = EnablePluginRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.enablePlugin(request);
    }

    public final Plugin enablePlugin(String name) {
        EnablePluginRequest request = EnablePluginRequest.newBuilder().setName(name).build();
        return this.enablePlugin(request);
    }

    public final Plugin enablePlugin(EnablePluginRequest request) {
        return (Plugin)this.enablePluginCallable().call((Object)request);
    }

    public final UnaryCallable<EnablePluginRequest, Plugin> enablePluginCallable() {
        return this.stub.enablePluginCallable();
    }

    public final Plugin disablePlugin(PluginName name) {
        DisablePluginRequest request = DisablePluginRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disablePlugin(request);
    }

    public final Plugin disablePlugin(String name) {
        DisablePluginRequest request = DisablePluginRequest.newBuilder().setName(name).build();
        return this.disablePlugin(request);
    }

    public final Plugin disablePlugin(DisablePluginRequest request) {
        return (Plugin)this.disablePluginCallable().call((Object)request);
    }

    public final UnaryCallable<DisablePluginRequest, Plugin> disablePluginCallable() {
        return this.stub.disablePluginCallable();
    }

    public final Plugin createPlugin(LocationName parent, Plugin plugin, String pluginId) {
        CreatePluginRequest request = CreatePluginRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPlugin(plugin).setPluginId(pluginId).build();
        return this.createPlugin(request);
    }

    public final Plugin createPlugin(String parent, Plugin plugin, String pluginId) {
        CreatePluginRequest request = CreatePluginRequest.newBuilder().setParent(parent).setPlugin(plugin).setPluginId(pluginId).build();
        return this.createPlugin(request);
    }

    public final Plugin createPlugin(CreatePluginRequest request) {
        return (Plugin)this.createPluginCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePluginRequest, Plugin> createPluginCallable() {
        return this.stub.createPluginCallable();
    }

    public final ListPluginsPagedResponse listPlugins(LocationName parent) {
        ListPluginsRequest request = ListPluginsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPlugins(request);
    }

    public final ListPluginsPagedResponse listPlugins(String parent) {
        ListPluginsRequest request = ListPluginsRequest.newBuilder().setParent(parent).build();
        return this.listPlugins(request);
    }

    public final ListPluginsPagedResponse listPlugins(ListPluginsRequest request) {
        return (ListPluginsPagedResponse)((Object)this.listPluginsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPluginsRequest, ListPluginsPagedResponse> listPluginsPagedCallable() {
        return this.stub.listPluginsPagedCallable();
    }

    public final UnaryCallable<ListPluginsRequest, ListPluginsResponse> listPluginsCallable() {
        return this.stub.listPluginsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePluginAsync(PluginName name) {
        DeletePluginRequest request = DeletePluginRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePluginAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePluginAsync(String name) {
        DeletePluginRequest request = DeletePluginRequest.newBuilder().setName(name).build();
        return this.deletePluginAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePluginAsync(DeletePluginRequest request) {
        return this.deletePluginOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePluginRequest, Empty, OperationMetadata> deletePluginOperationCallable() {
        return this.stub.deletePluginOperationCallable();
    }

    public final UnaryCallable<DeletePluginRequest, Operation> deletePluginCallable() {
        return this.stub.deletePluginCallable();
    }

    public final OperationFuture<PluginInstance, OperationMetadata> createPluginInstanceAsync(PluginName parent, PluginInstance pluginInstance, String pluginInstanceId) {
        CreatePluginInstanceRequest request = CreatePluginInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPluginInstance(pluginInstance).setPluginInstanceId(pluginInstanceId).build();
        return this.createPluginInstanceAsync(request);
    }

    public final OperationFuture<PluginInstance, OperationMetadata> createPluginInstanceAsync(String parent, PluginInstance pluginInstance, String pluginInstanceId) {
        CreatePluginInstanceRequest request = CreatePluginInstanceRequest.newBuilder().setParent(parent).setPluginInstance(pluginInstance).setPluginInstanceId(pluginInstanceId).build();
        return this.createPluginInstanceAsync(request);
    }

    public final OperationFuture<PluginInstance, OperationMetadata> createPluginInstanceAsync(CreatePluginInstanceRequest request) {
        return this.createPluginInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePluginInstanceRequest, PluginInstance, OperationMetadata> createPluginInstanceOperationCallable() {
        return this.stub.createPluginInstanceOperationCallable();
    }

    public final UnaryCallable<CreatePluginInstanceRequest, Operation> createPluginInstanceCallable() {
        return this.stub.createPluginInstanceCallable();
    }

    public final OperationFuture<ExecutePluginInstanceActionResponse, OperationMetadata> executePluginInstanceActionAsync(PluginInstanceName name, ActionExecutionDetail actionExecutionDetail) {
        ExecutePluginInstanceActionRequest request = ExecutePluginInstanceActionRequest.newBuilder().setName(name == null ? null : name.toString()).setActionExecutionDetail(actionExecutionDetail).build();
        return this.executePluginInstanceActionAsync(request);
    }

    public final OperationFuture<ExecutePluginInstanceActionResponse, OperationMetadata> executePluginInstanceActionAsync(String name, ActionExecutionDetail actionExecutionDetail) {
        ExecutePluginInstanceActionRequest request = ExecutePluginInstanceActionRequest.newBuilder().setName(name).setActionExecutionDetail(actionExecutionDetail).build();
        return this.executePluginInstanceActionAsync(request);
    }

    public final OperationFuture<ExecutePluginInstanceActionResponse, OperationMetadata> executePluginInstanceActionAsync(ExecutePluginInstanceActionRequest request) {
        return this.executePluginInstanceActionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExecutePluginInstanceActionRequest, ExecutePluginInstanceActionResponse, OperationMetadata> executePluginInstanceActionOperationCallable() {
        return this.stub.executePluginInstanceActionOperationCallable();
    }

    public final UnaryCallable<ExecutePluginInstanceActionRequest, Operation> executePluginInstanceActionCallable() {
        return this.stub.executePluginInstanceActionCallable();
    }

    public final PluginInstance getPluginInstance(PluginInstanceName name) {
        GetPluginInstanceRequest request = GetPluginInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPluginInstance(request);
    }

    public final PluginInstance getPluginInstance(String name) {
        GetPluginInstanceRequest request = GetPluginInstanceRequest.newBuilder().setName(name).build();
        return this.getPluginInstance(request);
    }

    public final PluginInstance getPluginInstance(GetPluginInstanceRequest request) {
        return (PluginInstance)this.getPluginInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetPluginInstanceRequest, PluginInstance> getPluginInstanceCallable() {
        return this.stub.getPluginInstanceCallable();
    }

    public final ListPluginInstancesPagedResponse listPluginInstances(PluginName parent) {
        ListPluginInstancesRequest request = ListPluginInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPluginInstances(request);
    }

    public final ListPluginInstancesPagedResponse listPluginInstances(String parent) {
        ListPluginInstancesRequest request = ListPluginInstancesRequest.newBuilder().setParent(parent).build();
        return this.listPluginInstances(request);
    }

    public final ListPluginInstancesPagedResponse listPluginInstances(ListPluginInstancesRequest request) {
        return (ListPluginInstancesPagedResponse)((Object)this.listPluginInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPluginInstancesRequest, ListPluginInstancesPagedResponse> listPluginInstancesPagedCallable() {
        return this.stub.listPluginInstancesPagedCallable();
    }

    public final UnaryCallable<ListPluginInstancesRequest, ListPluginInstancesResponse> listPluginInstancesCallable() {
        return this.stub.listPluginInstancesCallable();
    }

    public final OperationFuture<EnablePluginInstanceActionResponse, OperationMetadata> enablePluginInstanceActionAsync(PluginInstanceName name, String actionId) {
        EnablePluginInstanceActionRequest request = EnablePluginInstanceActionRequest.newBuilder().setName(name == null ? null : name.toString()).setActionId(actionId).build();
        return this.enablePluginInstanceActionAsync(request);
    }

    public final OperationFuture<EnablePluginInstanceActionResponse, OperationMetadata> enablePluginInstanceActionAsync(String name, String actionId) {
        EnablePluginInstanceActionRequest request = EnablePluginInstanceActionRequest.newBuilder().setName(name).setActionId(actionId).build();
        return this.enablePluginInstanceActionAsync(request);
    }

    public final OperationFuture<EnablePluginInstanceActionResponse, OperationMetadata> enablePluginInstanceActionAsync(EnablePluginInstanceActionRequest request) {
        return this.enablePluginInstanceActionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnablePluginInstanceActionRequest, EnablePluginInstanceActionResponse, OperationMetadata> enablePluginInstanceActionOperationCallable() {
        return this.stub.enablePluginInstanceActionOperationCallable();
    }

    public final UnaryCallable<EnablePluginInstanceActionRequest, Operation> enablePluginInstanceActionCallable() {
        return this.stub.enablePluginInstanceActionCallable();
    }

    public final OperationFuture<DisablePluginInstanceActionResponse, OperationMetadata> disablePluginInstanceActionAsync(PluginInstanceName name, String actionId) {
        DisablePluginInstanceActionRequest request = DisablePluginInstanceActionRequest.newBuilder().setName(name == null ? null : name.toString()).setActionId(actionId).build();
        return this.disablePluginInstanceActionAsync(request);
    }

    public final OperationFuture<DisablePluginInstanceActionResponse, OperationMetadata> disablePluginInstanceActionAsync(String name, String actionId) {
        DisablePluginInstanceActionRequest request = DisablePluginInstanceActionRequest.newBuilder().setName(name).setActionId(actionId).build();
        return this.disablePluginInstanceActionAsync(request);
    }

    public final OperationFuture<DisablePluginInstanceActionResponse, OperationMetadata> disablePluginInstanceActionAsync(DisablePluginInstanceActionRequest request) {
        return this.disablePluginInstanceActionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisablePluginInstanceActionRequest, DisablePluginInstanceActionResponse, OperationMetadata> disablePluginInstanceActionOperationCallable() {
        return this.stub.disablePluginInstanceActionOperationCallable();
    }

    public final UnaryCallable<DisablePluginInstanceActionRequest, Operation> disablePluginInstanceActionCallable() {
        return this.stub.disablePluginInstanceActionCallable();
    }

    public final PluginInstance updatePluginInstance(PluginInstance pluginInstance, FieldMask updateMask) {
        UpdatePluginInstanceRequest request = UpdatePluginInstanceRequest.newBuilder().setPluginInstance(pluginInstance).setUpdateMask(updateMask).build();
        return this.updatePluginInstance(request);
    }

    public final PluginInstance updatePluginInstance(UpdatePluginInstanceRequest request) {
        return (PluginInstance)this.updatePluginInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePluginInstanceRequest, PluginInstance> updatePluginInstanceCallable() {
        return this.stub.updatePluginInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePluginInstanceAsync(PluginInstanceName name) {
        DeletePluginInstanceRequest request = DeletePluginInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePluginInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePluginInstanceAsync(String name) {
        DeletePluginInstanceRequest request = DeletePluginInstanceRequest.newBuilder().setName(name).build();
        return this.deletePluginInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePluginInstanceAsync(DeletePluginInstanceRequest request) {
        return this.deletePluginInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePluginInstanceRequest, Empty, OperationMetadata> deletePluginInstanceOperationCallable() {
        return this.stub.deletePluginInstanceOperationCallable();
    }

    public final UnaryCallable<DeletePluginInstanceRequest, Operation> deletePluginInstanceCallable() {
        return this.stub.deletePluginInstanceCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPluginInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPluginInstancesRequest, ListPluginInstancesResponse, PluginInstance, ListPluginInstancesPage, ListPluginInstancesFixedSizeCollection> {
        private ListPluginInstancesFixedSizeCollection(List<ListPluginInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPluginInstancesFixedSizeCollection createEmptyCollection() {
            return new ListPluginInstancesFixedSizeCollection(null, 0);
        }

        protected ListPluginInstancesFixedSizeCollection createCollection(List<ListPluginInstancesPage> pages, int collectionSize) {
            return new ListPluginInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPluginInstancesPage
    extends AbstractPage<ListPluginInstancesRequest, ListPluginInstancesResponse, PluginInstance, ListPluginInstancesPage> {
        private ListPluginInstancesPage(PageContext<ListPluginInstancesRequest, ListPluginInstancesResponse, PluginInstance> context, ListPluginInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListPluginInstancesPage createEmptyPage() {
            return new ListPluginInstancesPage(null, null);
        }

        protected ListPluginInstancesPage createPage(PageContext<ListPluginInstancesRequest, ListPluginInstancesResponse, PluginInstance> context, ListPluginInstancesResponse response) {
            return new ListPluginInstancesPage(context, response);
        }

        public ApiFuture<ListPluginInstancesPage> createPageAsync(PageContext<ListPluginInstancesRequest, ListPluginInstancesResponse, PluginInstance> context, ApiFuture<ListPluginInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPluginInstancesPagedResponse
    extends AbstractPagedListResponse<ListPluginInstancesRequest, ListPluginInstancesResponse, PluginInstance, ListPluginInstancesPage, ListPluginInstancesFixedSizeCollection> {
        public static ApiFuture<ListPluginInstancesPagedResponse> createAsync(PageContext<ListPluginInstancesRequest, ListPluginInstancesResponse, PluginInstance> context, ApiFuture<ListPluginInstancesResponse> futureResponse) {
            ApiFuture<ListPluginInstancesPage> futurePage = ListPluginInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPluginInstancesPagedResponse((ListPluginInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPluginInstancesPagedResponse(ListPluginInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPluginInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPluginsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPluginsRequest, ListPluginsResponse, Plugin, ListPluginsPage, ListPluginsFixedSizeCollection> {
        private ListPluginsFixedSizeCollection(List<ListPluginsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPluginsFixedSizeCollection createEmptyCollection() {
            return new ListPluginsFixedSizeCollection(null, 0);
        }

        protected ListPluginsFixedSizeCollection createCollection(List<ListPluginsPage> pages, int collectionSize) {
            return new ListPluginsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPluginsPage
    extends AbstractPage<ListPluginsRequest, ListPluginsResponse, Plugin, ListPluginsPage> {
        private ListPluginsPage(PageContext<ListPluginsRequest, ListPluginsResponse, Plugin> context, ListPluginsResponse response) {
            super(context, (Object)response);
        }

        private static ListPluginsPage createEmptyPage() {
            return new ListPluginsPage(null, null);
        }

        protected ListPluginsPage createPage(PageContext<ListPluginsRequest, ListPluginsResponse, Plugin> context, ListPluginsResponse response) {
            return new ListPluginsPage(context, response);
        }

        public ApiFuture<ListPluginsPage> createPageAsync(PageContext<ListPluginsRequest, ListPluginsResponse, Plugin> context, ApiFuture<ListPluginsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPluginsPagedResponse
    extends AbstractPagedListResponse<ListPluginsRequest, ListPluginsResponse, Plugin, ListPluginsPage, ListPluginsFixedSizeCollection> {
        public static ApiFuture<ListPluginsPagedResponse> createAsync(PageContext<ListPluginsRequest, ListPluginsResponse, Plugin> context, ApiFuture<ListPluginsResponse> futureResponse) {
            ApiFuture<ListPluginsPage> futurePage = ListPluginsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPluginsPagedResponse((ListPluginsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPluginsPagedResponse(ListPluginsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPluginsFixedSizeCollection.createEmptyCollection());
        }
    }
}

