/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubPluginClient;
import com.google.cloud.apihub.v1.DisablePluginRequest;
import com.google.cloud.apihub.v1.EnablePluginRequest;
import com.google.cloud.apihub.v1.GetPluginRequest;
import com.google.cloud.apihub.v1.Plugin;
import com.google.cloud.apihub.v1.stub.ApiHubPluginStub;
import com.google.cloud.apihub.v1.stub.ApiHubPluginStubSettings;
import com.google.cloud.apihub.v1.stub.GrpcApiHubPluginCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcApiHubPluginStub
extends ApiHubPluginStub {
    private static final MethodDescriptor<GetPluginRequest, Plugin> getPluginMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubPlugin/GetPlugin").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPluginRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Plugin.getDefaultInstance())).build();
    private static final MethodDescriptor<EnablePluginRequest, Plugin> enablePluginMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubPlugin/EnablePlugin").setRequestMarshaller(ProtoUtils.marshaller((Message)EnablePluginRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Plugin.getDefaultInstance())).build();
    private static final MethodDescriptor<DisablePluginRequest, Plugin> disablePluginMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubPlugin/DisablePlugin").setRequestMarshaller(ProtoUtils.marshaller((Message)DisablePluginRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Plugin.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<GetPluginRequest, Plugin> getPluginCallable;
    private final UnaryCallable<EnablePluginRequest, Plugin> enablePluginCallable;
    private final UnaryCallable<DisablePluginRequest, Plugin> disablePluginCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ApiHubPluginClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcApiHubPluginStub create(ApiHubPluginStubSettings settings) throws IOException {
        return new GrpcApiHubPluginStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcApiHubPluginStub create(ClientContext clientContext) throws IOException {
        return new GrpcApiHubPluginStub(ApiHubPluginStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcApiHubPluginStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcApiHubPluginStub(ApiHubPluginStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcApiHubPluginStub(ApiHubPluginStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcApiHubPluginCallableFactory());
    }

    protected GrpcApiHubPluginStub(ApiHubPluginStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getPluginTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPluginMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings enablePluginTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(enablePluginMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings disablePluginTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(disablePluginMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getPluginCallable = callableFactory.createUnaryCallable(getPluginTransportSettings, settings.getPluginSettings(), clientContext);
        this.enablePluginCallable = callableFactory.createUnaryCallable(enablePluginTransportSettings, settings.enablePluginSettings(), clientContext);
        this.disablePluginCallable = callableFactory.createUnaryCallable(disablePluginTransportSettings, settings.disablePluginSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetPluginRequest, Plugin> getPluginCallable() {
        return this.getPluginCallable;
    }

    @Override
    public UnaryCallable<EnablePluginRequest, Plugin> enablePluginCallable() {
        return this.enablePluginCallable;
    }

    @Override
    public UnaryCallable<DisablePluginRequest, Plugin> disablePluginCallable() {
        return this.disablePluginCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ApiHubPluginClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

