/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.CreateHostProjectRegistrationRequest;
import com.google.cloud.apihub.v1.GetHostProjectRegistrationRequest;
import com.google.cloud.apihub.v1.HostProjectRegistration;
import com.google.cloud.apihub.v1.HostProjectRegistrationName;
import com.google.cloud.apihub.v1.HostProjectRegistrationServiceSettings;
import com.google.cloud.apihub.v1.ListHostProjectRegistrationsRequest;
import com.google.cloud.apihub.v1.ListHostProjectRegistrationsResponse;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.stub.HostProjectRegistrationServiceStub;
import com.google.cloud.apihub.v1.stub.HostProjectRegistrationServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class HostProjectRegistrationServiceClient
implements BackgroundResource {
    private final HostProjectRegistrationServiceSettings settings;
    private final HostProjectRegistrationServiceStub stub;

    public static final HostProjectRegistrationServiceClient create() throws IOException {
        return HostProjectRegistrationServiceClient.create(HostProjectRegistrationServiceSettings.newBuilder().build());
    }

    public static final HostProjectRegistrationServiceClient create(HostProjectRegistrationServiceSettings settings) throws IOException {
        return new HostProjectRegistrationServiceClient(settings);
    }

    public static final HostProjectRegistrationServiceClient create(HostProjectRegistrationServiceStub stub) {
        return new HostProjectRegistrationServiceClient(stub);
    }

    protected HostProjectRegistrationServiceClient(HostProjectRegistrationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HostProjectRegistrationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected HostProjectRegistrationServiceClient(HostProjectRegistrationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final HostProjectRegistrationServiceSettings getSettings() {
        return this.settings;
    }

    public HostProjectRegistrationServiceStub getStub() {
        return this.stub;
    }

    public final HostProjectRegistration createHostProjectRegistration(LocationName parent, HostProjectRegistration hostProjectRegistration, String hostProjectRegistrationId) {
        CreateHostProjectRegistrationRequest request = CreateHostProjectRegistrationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHostProjectRegistration(hostProjectRegistration).setHostProjectRegistrationId(hostProjectRegistrationId).build();
        return this.createHostProjectRegistration(request);
    }

    public final HostProjectRegistration createHostProjectRegistration(String parent, HostProjectRegistration hostProjectRegistration, String hostProjectRegistrationId) {
        CreateHostProjectRegistrationRequest request = CreateHostProjectRegistrationRequest.newBuilder().setParent(parent).setHostProjectRegistration(hostProjectRegistration).setHostProjectRegistrationId(hostProjectRegistrationId).build();
        return this.createHostProjectRegistration(request);
    }

    public final HostProjectRegistration createHostProjectRegistration(CreateHostProjectRegistrationRequest request) {
        return (HostProjectRegistration)this.createHostProjectRegistrationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateHostProjectRegistrationRequest, HostProjectRegistration> createHostProjectRegistrationCallable() {
        return this.stub.createHostProjectRegistrationCallable();
    }

    public final HostProjectRegistration getHostProjectRegistration(HostProjectRegistrationName name) {
        GetHostProjectRegistrationRequest request = GetHostProjectRegistrationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHostProjectRegistration(request);
    }

    public final HostProjectRegistration getHostProjectRegistration(String name) {
        GetHostProjectRegistrationRequest request = GetHostProjectRegistrationRequest.newBuilder().setName(name).build();
        return this.getHostProjectRegistration(request);
    }

    public final HostProjectRegistration getHostProjectRegistration(GetHostProjectRegistrationRequest request) {
        return (HostProjectRegistration)this.getHostProjectRegistrationCallable().call((Object)request);
    }

    public final UnaryCallable<GetHostProjectRegistrationRequest, HostProjectRegistration> getHostProjectRegistrationCallable() {
        return this.stub.getHostProjectRegistrationCallable();
    }

    public final ListHostProjectRegistrationsPagedResponse listHostProjectRegistrations(LocationName parent) {
        ListHostProjectRegistrationsRequest request = ListHostProjectRegistrationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHostProjectRegistrations(request);
    }

    public final ListHostProjectRegistrationsPagedResponse listHostProjectRegistrations(String parent) {
        ListHostProjectRegistrationsRequest request = ListHostProjectRegistrationsRequest.newBuilder().setParent(parent).build();
        return this.listHostProjectRegistrations(request);
    }

    public final ListHostProjectRegistrationsPagedResponse listHostProjectRegistrations(ListHostProjectRegistrationsRequest request) {
        return (ListHostProjectRegistrationsPagedResponse)((Object)this.listHostProjectRegistrationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsPagedResponse> listHostProjectRegistrationsPagedCallable() {
        return this.stub.listHostProjectRegistrationsPagedCallable();
    }

    public final UnaryCallable<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse> listHostProjectRegistrationsCallable() {
        return this.stub.listHostProjectRegistrationsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHostProjectRegistrationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration, ListHostProjectRegistrationsPage, ListHostProjectRegistrationsFixedSizeCollection> {
        private ListHostProjectRegistrationsFixedSizeCollection(List<ListHostProjectRegistrationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHostProjectRegistrationsFixedSizeCollection createEmptyCollection() {
            return new ListHostProjectRegistrationsFixedSizeCollection(null, 0);
        }

        protected ListHostProjectRegistrationsFixedSizeCollection createCollection(List<ListHostProjectRegistrationsPage> pages, int collectionSize) {
            return new ListHostProjectRegistrationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHostProjectRegistrationsPage
    extends AbstractPage<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration, ListHostProjectRegistrationsPage> {
        private ListHostProjectRegistrationsPage(PageContext<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration> context, ListHostProjectRegistrationsResponse response) {
            super(context, (Object)response);
        }

        private static ListHostProjectRegistrationsPage createEmptyPage() {
            return new ListHostProjectRegistrationsPage(null, null);
        }

        protected ListHostProjectRegistrationsPage createPage(PageContext<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration> context, ListHostProjectRegistrationsResponse response) {
            return new ListHostProjectRegistrationsPage(context, response);
        }

        public ApiFuture<ListHostProjectRegistrationsPage> createPageAsync(PageContext<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration> context, ApiFuture<ListHostProjectRegistrationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHostProjectRegistrationsPagedResponse
    extends AbstractPagedListResponse<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration, ListHostProjectRegistrationsPage, ListHostProjectRegistrationsFixedSizeCollection> {
        public static ApiFuture<ListHostProjectRegistrationsPagedResponse> createAsync(PageContext<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration> context, ApiFuture<ListHostProjectRegistrationsResponse> futureResponse) {
            ApiFuture<ListHostProjectRegistrationsPage> futurePage = ListHostProjectRegistrationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHostProjectRegistrationsPagedResponse((ListHostProjectRegistrationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHostProjectRegistrationsPagedResponse(ListHostProjectRegistrationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHostProjectRegistrationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

