/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.Api;
import com.google.cloud.apihub.v1.ApiHubSettings;
import com.google.cloud.apihub.v1.ApiName;
import com.google.cloud.apihub.v1.ApiOperation;
import com.google.cloud.apihub.v1.ApiOperationName;
import com.google.cloud.apihub.v1.Attribute;
import com.google.cloud.apihub.v1.AttributeName;
import com.google.cloud.apihub.v1.CreateApiRequest;
import com.google.cloud.apihub.v1.CreateAttributeRequest;
import com.google.cloud.apihub.v1.CreateDeploymentRequest;
import com.google.cloud.apihub.v1.CreateExternalApiRequest;
import com.google.cloud.apihub.v1.CreateSpecRequest;
import com.google.cloud.apihub.v1.CreateVersionRequest;
import com.google.cloud.apihub.v1.Definition;
import com.google.cloud.apihub.v1.DefinitionName;
import com.google.cloud.apihub.v1.DeleteApiRequest;
import com.google.cloud.apihub.v1.DeleteAttributeRequest;
import com.google.cloud.apihub.v1.DeleteDeploymentRequest;
import com.google.cloud.apihub.v1.DeleteExternalApiRequest;
import com.google.cloud.apihub.v1.DeleteSpecRequest;
import com.google.cloud.apihub.v1.DeleteVersionRequest;
import com.google.cloud.apihub.v1.Deployment;
import com.google.cloud.apihub.v1.DeploymentName;
import com.google.cloud.apihub.v1.ExternalApi;
import com.google.cloud.apihub.v1.ExternalApiName;
import com.google.cloud.apihub.v1.GetApiOperationRequest;
import com.google.cloud.apihub.v1.GetApiRequest;
import com.google.cloud.apihub.v1.GetAttributeRequest;
import com.google.cloud.apihub.v1.GetDefinitionRequest;
import com.google.cloud.apihub.v1.GetDeploymentRequest;
import com.google.cloud.apihub.v1.GetExternalApiRequest;
import com.google.cloud.apihub.v1.GetSpecContentsRequest;
import com.google.cloud.apihub.v1.GetSpecRequest;
import com.google.cloud.apihub.v1.GetVersionRequest;
import com.google.cloud.apihub.v1.ListApiOperationsRequest;
import com.google.cloud.apihub.v1.ListApiOperationsResponse;
import com.google.cloud.apihub.v1.ListApisRequest;
import com.google.cloud.apihub.v1.ListApisResponse;
import com.google.cloud.apihub.v1.ListAttributesRequest;
import com.google.cloud.apihub.v1.ListAttributesResponse;
import com.google.cloud.apihub.v1.ListDeploymentsRequest;
import com.google.cloud.apihub.v1.ListDeploymentsResponse;
import com.google.cloud.apihub.v1.ListExternalApisRequest;
import com.google.cloud.apihub.v1.ListExternalApisResponse;
import com.google.cloud.apihub.v1.ListSpecsRequest;
import com.google.cloud.apihub.v1.ListSpecsResponse;
import com.google.cloud.apihub.v1.ListVersionsRequest;
import com.google.cloud.apihub.v1.ListVersionsResponse;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.SearchResourcesRequest;
import com.google.cloud.apihub.v1.SearchResourcesResponse;
import com.google.cloud.apihub.v1.SearchResult;
import com.google.cloud.apihub.v1.Spec;
import com.google.cloud.apihub.v1.SpecContents;
import com.google.cloud.apihub.v1.SpecName;
import com.google.cloud.apihub.v1.UpdateApiRequest;
import com.google.cloud.apihub.v1.UpdateAttributeRequest;
import com.google.cloud.apihub.v1.UpdateDeploymentRequest;
import com.google.cloud.apihub.v1.UpdateExternalApiRequest;
import com.google.cloud.apihub.v1.UpdateSpecRequest;
import com.google.cloud.apihub.v1.UpdateVersionRequest;
import com.google.cloud.apihub.v1.Version;
import com.google.cloud.apihub.v1.VersionName;
import com.google.cloud.apihub.v1.stub.ApiHubStub;
import com.google.cloud.apihub.v1.stub.ApiHubStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiHubClient
implements BackgroundResource {
    private final ApiHubSettings settings;
    private final ApiHubStub stub;

    public static final ApiHubClient create() throws IOException {
        return ApiHubClient.create(ApiHubSettings.newBuilder().build());
    }

    public static final ApiHubClient create(ApiHubSettings settings) throws IOException {
        return new ApiHubClient(settings);
    }

    public static final ApiHubClient create(ApiHubStub stub) {
        return new ApiHubClient(stub);
    }

    protected ApiHubClient(ApiHubSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiHubStubSettings)settings.getStubSettings()).createStub();
    }

    protected ApiHubClient(ApiHubStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ApiHubSettings getSettings() {
        return this.settings;
    }

    public ApiHubStub getStub() {
        return this.stub;
    }

    public final Api createApi(LocationName parent, Api api, String apiId) {
        CreateApiRequest request = CreateApiRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApi(api).setApiId(apiId).build();
        return this.createApi(request);
    }

    public final Api createApi(String parent, Api api, String apiId) {
        CreateApiRequest request = CreateApiRequest.newBuilder().setParent(parent).setApi(api).setApiId(apiId).build();
        return this.createApi(request);
    }

    public final Api createApi(CreateApiRequest request) {
        return (Api)this.createApiCallable().call((Object)request);
    }

    public final UnaryCallable<CreateApiRequest, Api> createApiCallable() {
        return this.stub.createApiCallable();
    }

    public final Api getApi(ApiName name) {
        GetApiRequest request = GetApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApi(request);
    }

    public final Api getApi(String name) {
        GetApiRequest request = GetApiRequest.newBuilder().setName(name).build();
        return this.getApi(request);
    }

    public final Api getApi(GetApiRequest request) {
        return (Api)this.getApiCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiRequest, Api> getApiCallable() {
        return this.stub.getApiCallable();
    }

    public final ListApisPagedResponse listApis(LocationName parent) {
        ListApisRequest request = ListApisRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApis(request);
    }

    public final ListApisPagedResponse listApis(String parent) {
        ListApisRequest request = ListApisRequest.newBuilder().setParent(parent).build();
        return this.listApis(request);
    }

    public final ListApisPagedResponse listApis(ListApisRequest request) {
        return (ListApisPagedResponse)((Object)this.listApisPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApisRequest, ListApisPagedResponse> listApisPagedCallable() {
        return this.stub.listApisPagedCallable();
    }

    public final UnaryCallable<ListApisRequest, ListApisResponse> listApisCallable() {
        return this.stub.listApisCallable();
    }

    public final Api updateApi(Api api, FieldMask updateMask) {
        UpdateApiRequest request = UpdateApiRequest.newBuilder().setApi(api).setUpdateMask(updateMask).build();
        return this.updateApi(request);
    }

    public final Api updateApi(UpdateApiRequest request) {
        return (Api)this.updateApiCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateApiRequest, Api> updateApiCallable() {
        return this.stub.updateApiCallable();
    }

    public final void deleteApi(ApiName name) {
        DeleteApiRequest request = DeleteApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteApi(request);
    }

    public final void deleteApi(String name) {
        DeleteApiRequest request = DeleteApiRequest.newBuilder().setName(name).build();
        this.deleteApi(request);
    }

    public final void deleteApi(DeleteApiRequest request) {
        this.deleteApiCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApiRequest, Empty> deleteApiCallable() {
        return this.stub.deleteApiCallable();
    }

    public final Version createVersion(ApiName parent, Version version, String versionId) {
        CreateVersionRequest request = CreateVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVersion(version).setVersionId(versionId).build();
        return this.createVersion(request);
    }

    public final Version createVersion(String parent, Version version, String versionId) {
        CreateVersionRequest request = CreateVersionRequest.newBuilder().setParent(parent).setVersion(version).setVersionId(versionId).build();
        return this.createVersion(request);
    }

    public final Version createVersion(CreateVersionRequest request) {
        return (Version)this.createVersionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateVersionRequest, Version> createVersionCallable() {
        return this.stub.createVersionCallable();
    }

    public final Version getVersion(VersionName name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVersion(request);
    }

    public final Version getVersion(String name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name).build();
        return this.getVersion(request);
    }

    public final Version getVersion(GetVersionRequest request) {
        return (Version)this.getVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.stub.getVersionCallable();
    }

    public final ListVersionsPagedResponse listVersions(ApiName parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(String parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(ListVersionsRequest request) {
        return (ListVersionsPagedResponse)((Object)this.listVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.stub.listVersionsPagedCallable();
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.stub.listVersionsCallable();
    }

    public final Version updateVersion(Version version, FieldMask updateMask) {
        UpdateVersionRequest request = UpdateVersionRequest.newBuilder().setVersion(version).setUpdateMask(updateMask).build();
        return this.updateVersion(request);
    }

    public final Version updateVersion(UpdateVersionRequest request) {
        return (Version)this.updateVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable() {
        return this.stub.updateVersionCallable();
    }

    public final void deleteVersion(VersionName name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteVersion(request);
    }

    public final void deleteVersion(String name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name).build();
        this.deleteVersion(request);
    }

    public final void deleteVersion(DeleteVersionRequest request) {
        this.deleteVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVersionRequest, Empty> deleteVersionCallable() {
        return this.stub.deleteVersionCallable();
    }

    public final Spec createSpec(VersionName parent, Spec spec, String specId) {
        CreateSpecRequest request = CreateSpecRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSpec(spec).setSpecId(specId).build();
        return this.createSpec(request);
    }

    public final Spec createSpec(String parent, Spec spec, String specId) {
        CreateSpecRequest request = CreateSpecRequest.newBuilder().setParent(parent).setSpec(spec).setSpecId(specId).build();
        return this.createSpec(request);
    }

    public final Spec createSpec(CreateSpecRequest request) {
        return (Spec)this.createSpecCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSpecRequest, Spec> createSpecCallable() {
        return this.stub.createSpecCallable();
    }

    public final Spec getSpec(SpecName name) {
        GetSpecRequest request = GetSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpec(request);
    }

    public final Spec getSpec(String name) {
        GetSpecRequest request = GetSpecRequest.newBuilder().setName(name).build();
        return this.getSpec(request);
    }

    public final Spec getSpec(GetSpecRequest request) {
        return (Spec)this.getSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpecRequest, Spec> getSpecCallable() {
        return this.stub.getSpecCallable();
    }

    public final SpecContents getSpecContents(SpecName name) {
        GetSpecContentsRequest request = GetSpecContentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpecContents(request);
    }

    public final SpecContents getSpecContents(String name) {
        GetSpecContentsRequest request = GetSpecContentsRequest.newBuilder().setName(name).build();
        return this.getSpecContents(request);
    }

    public final SpecContents getSpecContents(GetSpecContentsRequest request) {
        return (SpecContents)this.getSpecContentsCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpecContentsRequest, SpecContents> getSpecContentsCallable() {
        return this.stub.getSpecContentsCallable();
    }

    public final ListSpecsPagedResponse listSpecs(VersionName parent) {
        ListSpecsRequest request = ListSpecsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSpecs(request);
    }

    public final ListSpecsPagedResponse listSpecs(String parent) {
        ListSpecsRequest request = ListSpecsRequest.newBuilder().setParent(parent).build();
        return this.listSpecs(request);
    }

    public final ListSpecsPagedResponse listSpecs(ListSpecsRequest request) {
        return (ListSpecsPagedResponse)((Object)this.listSpecsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSpecsRequest, ListSpecsPagedResponse> listSpecsPagedCallable() {
        return this.stub.listSpecsPagedCallable();
    }

    public final UnaryCallable<ListSpecsRequest, ListSpecsResponse> listSpecsCallable() {
        return this.stub.listSpecsCallable();
    }

    public final Spec updateSpec(Spec spec, FieldMask updateMask) {
        UpdateSpecRequest request = UpdateSpecRequest.newBuilder().setSpec(spec).setUpdateMask(updateMask).build();
        return this.updateSpec(request);
    }

    public final Spec updateSpec(UpdateSpecRequest request) {
        return (Spec)this.updateSpecCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSpecRequest, Spec> updateSpecCallable() {
        return this.stub.updateSpecCallable();
    }

    public final void deleteSpec(SpecName name) {
        DeleteSpecRequest request = DeleteSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSpec(request);
    }

    public final void deleteSpec(String name) {
        DeleteSpecRequest request = DeleteSpecRequest.newBuilder().setName(name).build();
        this.deleteSpec(request);
    }

    public final void deleteSpec(DeleteSpecRequest request) {
        this.deleteSpecCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSpecRequest, Empty> deleteSpecCallable() {
        return this.stub.deleteSpecCallable();
    }

    public final ApiOperation getApiOperation(ApiOperationName name) {
        GetApiOperationRequest request = GetApiOperationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApiOperation(request);
    }

    public final ApiOperation getApiOperation(String name) {
        GetApiOperationRequest request = GetApiOperationRequest.newBuilder().setName(name).build();
        return this.getApiOperation(request);
    }

    public final ApiOperation getApiOperation(GetApiOperationRequest request) {
        return (ApiOperation)this.getApiOperationCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiOperationRequest, ApiOperation> getApiOperationCallable() {
        return this.stub.getApiOperationCallable();
    }

    public final ListApiOperationsPagedResponse listApiOperations(VersionName parent) {
        ListApiOperationsRequest request = ListApiOperationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApiOperations(request);
    }

    public final ListApiOperationsPagedResponse listApiOperations(String parent) {
        ListApiOperationsRequest request = ListApiOperationsRequest.newBuilder().setParent(parent).build();
        return this.listApiOperations(request);
    }

    public final ListApiOperationsPagedResponse listApiOperations(ListApiOperationsRequest request) {
        return (ListApiOperationsPagedResponse)((Object)this.listApiOperationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApiOperationsRequest, ListApiOperationsPagedResponse> listApiOperationsPagedCallable() {
        return this.stub.listApiOperationsPagedCallable();
    }

    public final UnaryCallable<ListApiOperationsRequest, ListApiOperationsResponse> listApiOperationsCallable() {
        return this.stub.listApiOperationsCallable();
    }

    public final Definition getDefinition(DefinitionName name) {
        GetDefinitionRequest request = GetDefinitionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDefinition(request);
    }

    public final Definition getDefinition(String name) {
        GetDefinitionRequest request = GetDefinitionRequest.newBuilder().setName(name).build();
        return this.getDefinition(request);
    }

    public final Definition getDefinition(GetDefinitionRequest request) {
        return (Definition)this.getDefinitionCallable().call((Object)request);
    }

    public final UnaryCallable<GetDefinitionRequest, Definition> getDefinitionCallable() {
        return this.stub.getDefinitionCallable();
    }

    public final Deployment createDeployment(LocationName parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeployment(request);
    }

    public final Deployment createDeployment(String parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeployment(request);
    }

    public final Deployment createDeployment(CreateDeploymentRequest request) {
        return (Deployment)this.createDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeploymentRequest, Deployment> createDeploymentCallable() {
        return this.stub.createDeploymentCallable();
    }

    public final Deployment getDeployment(DeploymentName name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(String name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(GetDeploymentRequest request) {
        return (Deployment)this.getDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.stub.getDeploymentCallable();
    }

    public final ListDeploymentsPagedResponse listDeployments(LocationName parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(String parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(ListDeploymentsRequest request) {
        return (ListDeploymentsPagedResponse)((Object)this.listDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.stub.listDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.stub.listDeploymentsCallable();
    }

    public final Deployment updateDeployment(Deployment deployment, FieldMask updateMask) {
        UpdateDeploymentRequest request = UpdateDeploymentRequest.newBuilder().setDeployment(deployment).setUpdateMask(updateMask).build();
        return this.updateDeployment(request);
    }

    public final Deployment updateDeployment(UpdateDeploymentRequest request) {
        return (Deployment)this.updateDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDeploymentRequest, Deployment> updateDeploymentCallable() {
        return this.stub.updateDeploymentCallable();
    }

    public final void deleteDeployment(DeploymentName name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDeployment(request);
    }

    public final void deleteDeployment(String name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name).build();
        this.deleteDeployment(request);
    }

    public final void deleteDeployment(DeleteDeploymentRequest request) {
        this.deleteDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDeploymentRequest, Empty> deleteDeploymentCallable() {
        return this.stub.deleteDeploymentCallable();
    }

    public final Attribute createAttribute(LocationName parent, Attribute attribute, String attributeId) {
        CreateAttributeRequest request = CreateAttributeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAttribute(attribute).setAttributeId(attributeId).build();
        return this.createAttribute(request);
    }

    public final Attribute createAttribute(String parent, Attribute attribute, String attributeId) {
        CreateAttributeRequest request = CreateAttributeRequest.newBuilder().setParent(parent).setAttribute(attribute).setAttributeId(attributeId).build();
        return this.createAttribute(request);
    }

    public final Attribute createAttribute(CreateAttributeRequest request) {
        return (Attribute)this.createAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAttributeRequest, Attribute> createAttributeCallable() {
        return this.stub.createAttributeCallable();
    }

    public final Attribute getAttribute(AttributeName name) {
        GetAttributeRequest request = GetAttributeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttribute(request);
    }

    public final Attribute getAttribute(String name) {
        GetAttributeRequest request = GetAttributeRequest.newBuilder().setName(name).build();
        return this.getAttribute(request);
    }

    public final Attribute getAttribute(GetAttributeRequest request) {
        return (Attribute)this.getAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<GetAttributeRequest, Attribute> getAttributeCallable() {
        return this.stub.getAttributeCallable();
    }

    public final Attribute updateAttribute(Attribute attribute, FieldMask updateMask) {
        UpdateAttributeRequest request = UpdateAttributeRequest.newBuilder().setAttribute(attribute).setUpdateMask(updateMask).build();
        return this.updateAttribute(request);
    }

    public final Attribute updateAttribute(UpdateAttributeRequest request) {
        return (Attribute)this.updateAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAttributeRequest, Attribute> updateAttributeCallable() {
        return this.stub.updateAttributeCallable();
    }

    public final void deleteAttribute(AttributeName name) {
        DeleteAttributeRequest request = DeleteAttributeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAttribute(request);
    }

    public final void deleteAttribute(String name) {
        DeleteAttributeRequest request = DeleteAttributeRequest.newBuilder().setName(name).build();
        this.deleteAttribute(request);
    }

    public final void deleteAttribute(DeleteAttributeRequest request) {
        this.deleteAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAttributeRequest, Empty> deleteAttributeCallable() {
        return this.stub.deleteAttributeCallable();
    }

    public final ListAttributesPagedResponse listAttributes(LocationName parent) {
        ListAttributesRequest request = ListAttributesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAttributes(request);
    }

    public final ListAttributesPagedResponse listAttributes(String parent) {
        ListAttributesRequest request = ListAttributesRequest.newBuilder().setParent(parent).build();
        return this.listAttributes(request);
    }

    public final ListAttributesPagedResponse listAttributes(ListAttributesRequest request) {
        return (ListAttributesPagedResponse)((Object)this.listAttributesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAttributesRequest, ListAttributesPagedResponse> listAttributesPagedCallable() {
        return this.stub.listAttributesPagedCallable();
    }

    public final UnaryCallable<ListAttributesRequest, ListAttributesResponse> listAttributesCallable() {
        return this.stub.listAttributesCallable();
    }

    public final SearchResourcesPagedResponse searchResources(LocationName location, String query) {
        SearchResourcesRequest request = SearchResourcesRequest.newBuilder().setLocation(location == null ? null : location.toString()).setQuery(query).build();
        return this.searchResources(request);
    }

    public final SearchResourcesPagedResponse searchResources(String location, String query) {
        SearchResourcesRequest request = SearchResourcesRequest.newBuilder().setLocation(location).setQuery(query).build();
        return this.searchResources(request);
    }

    public final SearchResourcesPagedResponse searchResources(SearchResourcesRequest request) {
        return (SearchResourcesPagedResponse)((Object)this.searchResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchResourcesRequest, SearchResourcesPagedResponse> searchResourcesPagedCallable() {
        return this.stub.searchResourcesPagedCallable();
    }

    public final UnaryCallable<SearchResourcesRequest, SearchResourcesResponse> searchResourcesCallable() {
        return this.stub.searchResourcesCallable();
    }

    public final ExternalApi createExternalApi(LocationName parent, ExternalApi externalApi, String externalApiId) {
        CreateExternalApiRequest request = CreateExternalApiRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExternalApi(externalApi).setExternalApiId(externalApiId).build();
        return this.createExternalApi(request);
    }

    public final ExternalApi createExternalApi(String parent, ExternalApi externalApi, String externalApiId) {
        CreateExternalApiRequest request = CreateExternalApiRequest.newBuilder().setParent(parent).setExternalApi(externalApi).setExternalApiId(externalApiId).build();
        return this.createExternalApi(request);
    }

    public final ExternalApi createExternalApi(CreateExternalApiRequest request) {
        return (ExternalApi)this.createExternalApiCallable().call((Object)request);
    }

    public final UnaryCallable<CreateExternalApiRequest, ExternalApi> createExternalApiCallable() {
        return this.stub.createExternalApiCallable();
    }

    public final ExternalApi getExternalApi(ExternalApiName name) {
        GetExternalApiRequest request = GetExternalApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExternalApi(request);
    }

    public final ExternalApi getExternalApi(String name) {
        GetExternalApiRequest request = GetExternalApiRequest.newBuilder().setName(name).build();
        return this.getExternalApi(request);
    }

    public final ExternalApi getExternalApi(GetExternalApiRequest request) {
        return (ExternalApi)this.getExternalApiCallable().call((Object)request);
    }

    public final UnaryCallable<GetExternalApiRequest, ExternalApi> getExternalApiCallable() {
        return this.stub.getExternalApiCallable();
    }

    public final ExternalApi updateExternalApi(ExternalApi externalApi, FieldMask updateMask) {
        UpdateExternalApiRequest request = UpdateExternalApiRequest.newBuilder().setExternalApi(externalApi).setUpdateMask(updateMask).build();
        return this.updateExternalApi(request);
    }

    public final ExternalApi updateExternalApi(UpdateExternalApiRequest request) {
        return (ExternalApi)this.updateExternalApiCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateExternalApiRequest, ExternalApi> updateExternalApiCallable() {
        return this.stub.updateExternalApiCallable();
    }

    public final void deleteExternalApi(ExternalApiName name) {
        DeleteExternalApiRequest request = DeleteExternalApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteExternalApi(request);
    }

    public final void deleteExternalApi(String name) {
        DeleteExternalApiRequest request = DeleteExternalApiRequest.newBuilder().setName(name).build();
        this.deleteExternalApi(request);
    }

    public final void deleteExternalApi(DeleteExternalApiRequest request) {
        this.deleteExternalApiCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteExternalApiRequest, Empty> deleteExternalApiCallable() {
        return this.stub.deleteExternalApiCallable();
    }

    public final ListExternalApisPagedResponse listExternalApis(LocationName parent) {
        ListExternalApisRequest request = ListExternalApisRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExternalApis(request);
    }

    public final ListExternalApisPagedResponse listExternalApis(String parent) {
        ListExternalApisRequest request = ListExternalApisRequest.newBuilder().setParent(parent).build();
        return this.listExternalApis(request);
    }

    public final ListExternalApisPagedResponse listExternalApis(ListExternalApisRequest request) {
        return (ListExternalApisPagedResponse)((Object)this.listExternalApisPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExternalApisRequest, ListExternalApisPagedResponse> listExternalApisPagedCallable() {
        return this.stub.listExternalApisPagedCallable();
    }

    public final UnaryCallable<ListExternalApisRequest, ListExternalApisResponse> listExternalApisCallable() {
        return this.stub.listExternalApisCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExternalApisFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExternalApisRequest, ListExternalApisResponse, ExternalApi, ListExternalApisPage, ListExternalApisFixedSizeCollection> {
        private ListExternalApisFixedSizeCollection(List<ListExternalApisPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExternalApisFixedSizeCollection createEmptyCollection() {
            return new ListExternalApisFixedSizeCollection(null, 0);
        }

        protected ListExternalApisFixedSizeCollection createCollection(List<ListExternalApisPage> pages, int collectionSize) {
            return new ListExternalApisFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExternalApisPage
    extends AbstractPage<ListExternalApisRequest, ListExternalApisResponse, ExternalApi, ListExternalApisPage> {
        private ListExternalApisPage(PageContext<ListExternalApisRequest, ListExternalApisResponse, ExternalApi> context, ListExternalApisResponse response) {
            super(context, (Object)response);
        }

        private static ListExternalApisPage createEmptyPage() {
            return new ListExternalApisPage(null, null);
        }

        protected ListExternalApisPage createPage(PageContext<ListExternalApisRequest, ListExternalApisResponse, ExternalApi> context, ListExternalApisResponse response) {
            return new ListExternalApisPage(context, response);
        }

        public ApiFuture<ListExternalApisPage> createPageAsync(PageContext<ListExternalApisRequest, ListExternalApisResponse, ExternalApi> context, ApiFuture<ListExternalApisResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExternalApisPagedResponse
    extends AbstractPagedListResponse<ListExternalApisRequest, ListExternalApisResponse, ExternalApi, ListExternalApisPage, ListExternalApisFixedSizeCollection> {
        public static ApiFuture<ListExternalApisPagedResponse> createAsync(PageContext<ListExternalApisRequest, ListExternalApisResponse, ExternalApi> context, ApiFuture<ListExternalApisResponse> futureResponse) {
            ApiFuture<ListExternalApisPage> futurePage = ListExternalApisPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExternalApisPagedResponse((ListExternalApisPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExternalApisPagedResponse(ListExternalApisPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExternalApisFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchResourcesRequest, SearchResourcesResponse, SearchResult, SearchResourcesPage, SearchResourcesFixedSizeCollection> {
        private SearchResourcesFixedSizeCollection(List<SearchResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchResourcesFixedSizeCollection createEmptyCollection() {
            return new SearchResourcesFixedSizeCollection(null, 0);
        }

        protected SearchResourcesFixedSizeCollection createCollection(List<SearchResourcesPage> pages, int collectionSize) {
            return new SearchResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchResourcesPage
    extends AbstractPage<SearchResourcesRequest, SearchResourcesResponse, SearchResult, SearchResourcesPage> {
        private SearchResourcesPage(PageContext<SearchResourcesRequest, SearchResourcesResponse, SearchResult> context, SearchResourcesResponse response) {
            super(context, (Object)response);
        }

        private static SearchResourcesPage createEmptyPage() {
            return new SearchResourcesPage(null, null);
        }

        protected SearchResourcesPage createPage(PageContext<SearchResourcesRequest, SearchResourcesResponse, SearchResult> context, SearchResourcesResponse response) {
            return new SearchResourcesPage(context, response);
        }

        public ApiFuture<SearchResourcesPage> createPageAsync(PageContext<SearchResourcesRequest, SearchResourcesResponse, SearchResult> context, ApiFuture<SearchResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchResourcesPagedResponse
    extends AbstractPagedListResponse<SearchResourcesRequest, SearchResourcesResponse, SearchResult, SearchResourcesPage, SearchResourcesFixedSizeCollection> {
        public static ApiFuture<SearchResourcesPagedResponse> createAsync(PageContext<SearchResourcesRequest, SearchResourcesResponse, SearchResult> context, ApiFuture<SearchResourcesResponse> futureResponse) {
            ApiFuture<SearchResourcesPage> futurePage = SearchResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchResourcesPagedResponse((SearchResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchResourcesPagedResponse(SearchResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchResourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAttributesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAttributesRequest, ListAttributesResponse, Attribute, ListAttributesPage, ListAttributesFixedSizeCollection> {
        private ListAttributesFixedSizeCollection(List<ListAttributesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAttributesFixedSizeCollection createEmptyCollection() {
            return new ListAttributesFixedSizeCollection(null, 0);
        }

        protected ListAttributesFixedSizeCollection createCollection(List<ListAttributesPage> pages, int collectionSize) {
            return new ListAttributesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAttributesPage
    extends AbstractPage<ListAttributesRequest, ListAttributesResponse, Attribute, ListAttributesPage> {
        private ListAttributesPage(PageContext<ListAttributesRequest, ListAttributesResponse, Attribute> context, ListAttributesResponse response) {
            super(context, (Object)response);
        }

        private static ListAttributesPage createEmptyPage() {
            return new ListAttributesPage(null, null);
        }

        protected ListAttributesPage createPage(PageContext<ListAttributesRequest, ListAttributesResponse, Attribute> context, ListAttributesResponse response) {
            return new ListAttributesPage(context, response);
        }

        public ApiFuture<ListAttributesPage> createPageAsync(PageContext<ListAttributesRequest, ListAttributesResponse, Attribute> context, ApiFuture<ListAttributesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAttributesPagedResponse
    extends AbstractPagedListResponse<ListAttributesRequest, ListAttributesResponse, Attribute, ListAttributesPage, ListAttributesFixedSizeCollection> {
        public static ApiFuture<ListAttributesPagedResponse> createAsync(PageContext<ListAttributesRequest, ListAttributesResponse, Attribute> context, ApiFuture<ListAttributesResponse> futureResponse) {
            ApiFuture<ListAttributesPage> futurePage = ListAttributesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAttributesPagedResponse((ListAttributesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAttributesPagedResponse(ListAttributesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAttributesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        private ListDeploymentsFixedSizeCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentsFixedSizeCollection createCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            return new ListDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentsPage
    extends AbstractPage<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage> {
        private ListDeploymentsPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentsPage createEmptyPage() {
            return new ListDeploymentsPage(null, null);
        }

        protected ListDeploymentsPage createPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            return new ListDeploymentsPage(context, response);
        }

        public ApiFuture<ListDeploymentsPage> createPageAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentsPagedResponse> createAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            ApiFuture<ListDeploymentsPage> futurePage = ListDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentsPagedResponse((ListDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentsPagedResponse(ListDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApiOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation, ListApiOperationsPage, ListApiOperationsFixedSizeCollection> {
        private ListApiOperationsFixedSizeCollection(List<ListApiOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApiOperationsFixedSizeCollection createEmptyCollection() {
            return new ListApiOperationsFixedSizeCollection(null, 0);
        }

        protected ListApiOperationsFixedSizeCollection createCollection(List<ListApiOperationsPage> pages, int collectionSize) {
            return new ListApiOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApiOperationsPage
    extends AbstractPage<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation, ListApiOperationsPage> {
        private ListApiOperationsPage(PageContext<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation> context, ListApiOperationsResponse response) {
            super(context, (Object)response);
        }

        private static ListApiOperationsPage createEmptyPage() {
            return new ListApiOperationsPage(null, null);
        }

        protected ListApiOperationsPage createPage(PageContext<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation> context, ListApiOperationsResponse response) {
            return new ListApiOperationsPage(context, response);
        }

        public ApiFuture<ListApiOperationsPage> createPageAsync(PageContext<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation> context, ApiFuture<ListApiOperationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApiOperationsPagedResponse
    extends AbstractPagedListResponse<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation, ListApiOperationsPage, ListApiOperationsFixedSizeCollection> {
        public static ApiFuture<ListApiOperationsPagedResponse> createAsync(PageContext<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation> context, ApiFuture<ListApiOperationsResponse> futureResponse) {
            ApiFuture<ListApiOperationsPage> futurePage = ListApiOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApiOperationsPagedResponse((ListApiOperationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApiOperationsPagedResponse(ListApiOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApiOperationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSpecsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSpecsRequest, ListSpecsResponse, Spec, ListSpecsPage, ListSpecsFixedSizeCollection> {
        private ListSpecsFixedSizeCollection(List<ListSpecsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSpecsFixedSizeCollection createEmptyCollection() {
            return new ListSpecsFixedSizeCollection(null, 0);
        }

        protected ListSpecsFixedSizeCollection createCollection(List<ListSpecsPage> pages, int collectionSize) {
            return new ListSpecsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSpecsPage
    extends AbstractPage<ListSpecsRequest, ListSpecsResponse, Spec, ListSpecsPage> {
        private ListSpecsPage(PageContext<ListSpecsRequest, ListSpecsResponse, Spec> context, ListSpecsResponse response) {
            super(context, (Object)response);
        }

        private static ListSpecsPage createEmptyPage() {
            return new ListSpecsPage(null, null);
        }

        protected ListSpecsPage createPage(PageContext<ListSpecsRequest, ListSpecsResponse, Spec> context, ListSpecsResponse response) {
            return new ListSpecsPage(context, response);
        }

        public ApiFuture<ListSpecsPage> createPageAsync(PageContext<ListSpecsRequest, ListSpecsResponse, Spec> context, ApiFuture<ListSpecsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSpecsPagedResponse
    extends AbstractPagedListResponse<ListSpecsRequest, ListSpecsResponse, Spec, ListSpecsPage, ListSpecsFixedSizeCollection> {
        public static ApiFuture<ListSpecsPagedResponse> createAsync(PageContext<ListSpecsRequest, ListSpecsResponse, Spec> context, ApiFuture<ListSpecsResponse> futureResponse) {
            ApiFuture<ListSpecsPage> futurePage = ListSpecsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSpecsPagedResponse((ListSpecsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSpecsPagedResponse(ListSpecsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSpecsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        private ListVersionsFixedSizeCollection(List<ListVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVersionsFixedSizeCollection createEmptyCollection() {
            return new ListVersionsFixedSizeCollection(null, 0);
        }

        protected ListVersionsFixedSizeCollection createCollection(List<ListVersionsPage> pages, int collectionSize) {
            return new ListVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVersionsPage
    extends AbstractPage<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage> {
        private ListVersionsPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListVersionsPage createEmptyPage() {
            return new ListVersionsPage(null, null);
        }

        protected ListVersionsPage createPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            return new ListVersionsPage(context, response);
        }

        public ApiFuture<ListVersionsPage> createPageAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVersionsPagedResponse
    extends AbstractPagedListResponse<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        public static ApiFuture<ListVersionsPagedResponse> createAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            ApiFuture<ListVersionsPage> futurePage = ListVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVersionsPagedResponse((ListVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVersionsPagedResponse(ListVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApisFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApisRequest, ListApisResponse, Api, ListApisPage, ListApisFixedSizeCollection> {
        private ListApisFixedSizeCollection(List<ListApisPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApisFixedSizeCollection createEmptyCollection() {
            return new ListApisFixedSizeCollection(null, 0);
        }

        protected ListApisFixedSizeCollection createCollection(List<ListApisPage> pages, int collectionSize) {
            return new ListApisFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApisPage
    extends AbstractPage<ListApisRequest, ListApisResponse, Api, ListApisPage> {
        private ListApisPage(PageContext<ListApisRequest, ListApisResponse, Api> context, ListApisResponse response) {
            super(context, (Object)response);
        }

        private static ListApisPage createEmptyPage() {
            return new ListApisPage(null, null);
        }

        protected ListApisPage createPage(PageContext<ListApisRequest, ListApisResponse, Api> context, ListApisResponse response) {
            return new ListApisPage(context, response);
        }

        public ApiFuture<ListApisPage> createPageAsync(PageContext<ListApisRequest, ListApisResponse, Api> context, ApiFuture<ListApisResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApisPagedResponse
    extends AbstractPagedListResponse<ListApisRequest, ListApisResponse, Api, ListApisPage, ListApisFixedSizeCollection> {
        public static ApiFuture<ListApisPagedResponse> createAsync(PageContext<ListApisRequest, ListApisResponse, Api> context, ApiFuture<ListApisResponse> futureResponse) {
            ApiFuture<ListApisPage> futurePage = ListApisPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApisPagedResponse((ListApisPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApisPagedResponse(ListApisPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApisFixedSizeCollection.createEmptyCollection());
        }
    }
}

