/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubDependenciesClient;
import com.google.cloud.apihub.v1.CreateDependencyRequest;
import com.google.cloud.apihub.v1.DeleteDependencyRequest;
import com.google.cloud.apihub.v1.Dependency;
import com.google.cloud.apihub.v1.GetDependencyRequest;
import com.google.cloud.apihub.v1.ListDependenciesRequest;
import com.google.cloud.apihub.v1.ListDependenciesResponse;
import com.google.cloud.apihub.v1.UpdateDependencyRequest;
import com.google.cloud.apihub.v1.stub.ApiHubDependenciesStub;
import com.google.cloud.apihub.v1.stub.ApiHubDependenciesStubSettings;
import com.google.cloud.apihub.v1.stub.HttpJsonApiHubDependenciesCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonApiHubDependenciesStub
extends ApiHubDependenciesStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateDependencyRequest, Dependency> createDependencyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/CreateDependency").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/dependencies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "dependencyId", (Object)request.getDependencyId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dependency", (Message)request.getDependency(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Dependency.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDependencyRequest, Dependency> getDependencyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/GetDependency").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dependencies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Dependency.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateDependencyRequest, Dependency> updateDependencyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/UpdateDependency").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{dependency.name=projects/*/locations/*/dependencies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "dependency.name", (Object)request.getDependency().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dependency", (Message)request.getDependency(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Dependency.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteDependencyRequest, Empty> deleteDependencyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/DeleteDependency").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dependencies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDependenciesRequest, ListDependenciesResponse> listDependenciesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/ListDependencies").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/dependencies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDependenciesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateDependencyRequest, Dependency> createDependencyCallable;
    private final UnaryCallable<GetDependencyRequest, Dependency> getDependencyCallable;
    private final UnaryCallable<UpdateDependencyRequest, Dependency> updateDependencyCallable;
    private final UnaryCallable<DeleteDependencyRequest, Empty> deleteDependencyCallable;
    private final UnaryCallable<ListDependenciesRequest, ListDependenciesResponse> listDependenciesCallable;
    private final UnaryCallable<ListDependenciesRequest, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonApiHubDependenciesStub create(ApiHubDependenciesStubSettings settings) throws IOException {
        return new HttpJsonApiHubDependenciesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonApiHubDependenciesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonApiHubDependenciesStub(ApiHubDependenciesStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonApiHubDependenciesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonApiHubDependenciesStub(ApiHubDependenciesStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonApiHubDependenciesStub(ApiHubDependenciesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonApiHubDependenciesCallableFactory());
    }

    protected HttpJsonApiHubDependenciesStub(ApiHubDependenciesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createDependencyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDependencyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDependencyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDependencyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateDependencyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDependencyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dependency.name", String.valueOf(request.getDependency().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteDependencyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDependencyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listDependenciesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDependenciesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createDependencyCallable = callableFactory.createUnaryCallable(createDependencyTransportSettings, settings.createDependencySettings(), clientContext);
        this.getDependencyCallable = callableFactory.createUnaryCallable(getDependencyTransportSettings, settings.getDependencySettings(), clientContext);
        this.updateDependencyCallable = callableFactory.createUnaryCallable(updateDependencyTransportSettings, settings.updateDependencySettings(), clientContext);
        this.deleteDependencyCallable = callableFactory.createUnaryCallable(deleteDependencyTransportSettings, settings.deleteDependencySettings(), clientContext);
        this.listDependenciesCallable = callableFactory.createUnaryCallable(listDependenciesTransportSettings, settings.listDependenciesSettings(), clientContext);
        this.listDependenciesPagedCallable = callableFactory.createPagedCallable(listDependenciesTransportSettings, settings.listDependenciesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createDependencyMethodDescriptor);
        methodDescriptors.add(getDependencyMethodDescriptor);
        methodDescriptors.add(updateDependencyMethodDescriptor);
        methodDescriptors.add(deleteDependencyMethodDescriptor);
        methodDescriptors.add(listDependenciesMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateDependencyRequest, Dependency> createDependencyCallable() {
        return this.createDependencyCallable;
    }

    @Override
    public UnaryCallable<GetDependencyRequest, Dependency> getDependencyCallable() {
        return this.getDependencyCallable;
    }

    @Override
    public UnaryCallable<UpdateDependencyRequest, Dependency> updateDependencyCallable() {
        return this.updateDependencyCallable;
    }

    @Override
    public UnaryCallable<DeleteDependencyRequest, Empty> deleteDependencyCallable() {
        return this.deleteDependencyCallable;
    }

    @Override
    public UnaryCallable<ListDependenciesRequest, ListDependenciesResponse> listDependenciesCallable() {
        return this.listDependenciesCallable;
    }

    @Override
    public UnaryCallable<ListDependenciesRequest, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesPagedCallable() {
        return this.listDependenciesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

