/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.GetStyleGuideContentsRequest;
import com.google.cloud.apihub.v1.GetStyleGuideRequest;
import com.google.cloud.apihub.v1.LintSpecRequest;
import com.google.cloud.apihub.v1.LintingServiceClient;
import com.google.cloud.apihub.v1.StyleGuide;
import com.google.cloud.apihub.v1.StyleGuideContents;
import com.google.cloud.apihub.v1.UpdateStyleGuideRequest;
import com.google.cloud.apihub.v1.stub.GrpcLintingServiceCallableFactory;
import com.google.cloud.apihub.v1.stub.LintingServiceStub;
import com.google.cloud.apihub.v1.stub.LintingServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcLintingServiceStub
extends LintingServiceStub {
    private static final MethodDescriptor<GetStyleGuideRequest, StyleGuide> getStyleGuideMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.LintingService/GetStyleGuide").setRequestMarshaller(ProtoUtils.marshaller((Message)GetStyleGuideRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StyleGuide.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateStyleGuideRequest, StyleGuide> updateStyleGuideMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.LintingService/UpdateStyleGuide").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateStyleGuideRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StyleGuide.getDefaultInstance())).build();
    private static final MethodDescriptor<GetStyleGuideContentsRequest, StyleGuideContents> getStyleGuideContentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.LintingService/GetStyleGuideContents").setRequestMarshaller(ProtoUtils.marshaller((Message)GetStyleGuideContentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StyleGuideContents.getDefaultInstance())).build();
    private static final MethodDescriptor<LintSpecRequest, Empty> lintSpecMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.LintingService/LintSpec").setRequestMarshaller(ProtoUtils.marshaller((Message)LintSpecRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<GetStyleGuideRequest, StyleGuide> getStyleGuideCallable;
    private final UnaryCallable<UpdateStyleGuideRequest, StyleGuide> updateStyleGuideCallable;
    private final UnaryCallable<GetStyleGuideContentsRequest, StyleGuideContents> getStyleGuideContentsCallable;
    private final UnaryCallable<LintSpecRequest, Empty> lintSpecCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, LintingServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLintingServiceStub create(LintingServiceStubSettings settings) throws IOException {
        return new GrpcLintingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLintingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLintingServiceStub(LintingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLintingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLintingServiceStub(LintingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLintingServiceStub(LintingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLintingServiceCallableFactory());
    }

    protected GrpcLintingServiceStub(LintingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getStyleGuideTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getStyleGuideMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateStyleGuideTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateStyleGuideMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("style_guide.name", String.valueOf(request.getStyleGuide().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getStyleGuideContentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getStyleGuideContentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings lintSpecTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(lintSpecMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getStyleGuideCallable = callableFactory.createUnaryCallable(getStyleGuideTransportSettings, settings.getStyleGuideSettings(), clientContext);
        this.updateStyleGuideCallable = callableFactory.createUnaryCallable(updateStyleGuideTransportSettings, settings.updateStyleGuideSettings(), clientContext);
        this.getStyleGuideContentsCallable = callableFactory.createUnaryCallable(getStyleGuideContentsTransportSettings, settings.getStyleGuideContentsSettings(), clientContext);
        this.lintSpecCallable = callableFactory.createUnaryCallable(lintSpecTransportSettings, settings.lintSpecSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetStyleGuideRequest, StyleGuide> getStyleGuideCallable() {
        return this.getStyleGuideCallable;
    }

    @Override
    public UnaryCallable<UpdateStyleGuideRequest, StyleGuide> updateStyleGuideCallable() {
        return this.updateStyleGuideCallable;
    }

    @Override
    public UnaryCallable<GetStyleGuideContentsRequest, StyleGuideContents> getStyleGuideContentsCallable() {
        return this.getStyleGuideContentsCallable;
    }

    @Override
    public UnaryCallable<LintSpecRequest, Empty> lintSpecCallable() {
        return this.lintSpecCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, LintingServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

