/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeregistry.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigeeregistry.v1.CreateInstanceRequest;
import com.google.cloud.apigeeregistry.v1.DeleteInstanceRequest;
import com.google.cloud.apigeeregistry.v1.GetInstanceRequest;
import com.google.cloud.apigeeregistry.v1.Instance;
import com.google.cloud.apigeeregistry.v1.OperationMetadata;
import com.google.cloud.apigeeregistry.v1.ProvisioningClient;
import com.google.cloud.apigeeregistry.v1.stub.GrpcProvisioningCallableFactory;
import com.google.cloud.apigeeregistry.v1.stub.ProvisioningStub;
import com.google.cloud.apigeeregistry.v1.stub.ProvisioningStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcProvisioningStub
extends ProvisioningStub {
    private static final MethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigeeregistry.v1.Provisioning/CreateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigeeregistry.v1.Provisioning/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigeeregistry.v1.Provisioning/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ProvisioningClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProvisioningStub create(ProvisioningStubSettings settings) throws IOException {
        return new GrpcProvisioningStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProvisioningStub create(ClientContext clientContext) throws IOException {
        return new GrpcProvisioningStub(ProvisioningStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProvisioningStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProvisioningStub(ProvisioningStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProvisioningStub(ProvisioningStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProvisioningCallableFactory());
    }

    protected GrpcProvisioningStub(ProvisioningStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ProvisioningClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

