/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeregistry.v1.stub;

import com.google.api.HttpBody;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigeeregistry.v1.Api;
import com.google.cloud.apigeeregistry.v1.ApiDeployment;
import com.google.cloud.apigeeregistry.v1.ApiSpec;
import com.google.cloud.apigeeregistry.v1.ApiVersion;
import com.google.cloud.apigeeregistry.v1.Artifact;
import com.google.cloud.apigeeregistry.v1.CreateApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.CreateApiRequest;
import com.google.cloud.apigeeregistry.v1.CreateApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.CreateApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.CreateArtifactRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiDeploymentRevisionRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiSpecRevisionRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.DeleteArtifactRequest;
import com.google.cloud.apigeeregistry.v1.GetApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.GetApiRequest;
import com.google.cloud.apigeeregistry.v1.GetApiSpecContentsRequest;
import com.google.cloud.apigeeregistry.v1.GetApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.GetApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.GetArtifactContentsRequest;
import com.google.cloud.apigeeregistry.v1.GetArtifactRequest;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentRevisionsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentRevisionsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiSpecRevisionsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiSpecRevisionsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiSpecsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiSpecsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiVersionsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiVersionsResponse;
import com.google.cloud.apigeeregistry.v1.ListApisRequest;
import com.google.cloud.apigeeregistry.v1.ListApisResponse;
import com.google.cloud.apigeeregistry.v1.ListArtifactsRequest;
import com.google.cloud.apigeeregistry.v1.ListArtifactsResponse;
import com.google.cloud.apigeeregistry.v1.RegistryClient;
import com.google.cloud.apigeeregistry.v1.ReplaceArtifactRequest;
import com.google.cloud.apigeeregistry.v1.RollbackApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.RollbackApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.TagApiDeploymentRevisionRequest;
import com.google.cloud.apigeeregistry.v1.TagApiSpecRevisionRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.stub.GrpcRegistryStub;
import com.google.cloud.apigeeregistry.v1.stub.HttpJsonRegistryStub;
import com.google.cloud.apigeeregistry.v1.stub.RegistryStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegistryStubSettings
extends StubSettings<RegistryStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListApisRequest, ListApisResponse, RegistryClient.ListApisPagedResponse> listApisSettings;
    private final UnaryCallSettings<GetApiRequest, Api> getApiSettings;
    private final UnaryCallSettings<CreateApiRequest, Api> createApiSettings;
    private final UnaryCallSettings<UpdateApiRequest, Api> updateApiSettings;
    private final UnaryCallSettings<DeleteApiRequest, Empty> deleteApiSettings;
    private final PagedCallSettings<ListApiVersionsRequest, ListApiVersionsResponse, RegistryClient.ListApiVersionsPagedResponse> listApiVersionsSettings;
    private final UnaryCallSettings<GetApiVersionRequest, ApiVersion> getApiVersionSettings;
    private final UnaryCallSettings<CreateApiVersionRequest, ApiVersion> createApiVersionSettings;
    private final UnaryCallSettings<UpdateApiVersionRequest, ApiVersion> updateApiVersionSettings;
    private final UnaryCallSettings<DeleteApiVersionRequest, Empty> deleteApiVersionSettings;
    private final PagedCallSettings<ListApiSpecsRequest, ListApiSpecsResponse, RegistryClient.ListApiSpecsPagedResponse> listApiSpecsSettings;
    private final UnaryCallSettings<GetApiSpecRequest, ApiSpec> getApiSpecSettings;
    private final UnaryCallSettings<GetApiSpecContentsRequest, HttpBody> getApiSpecContentsSettings;
    private final UnaryCallSettings<CreateApiSpecRequest, ApiSpec> createApiSpecSettings;
    private final UnaryCallSettings<UpdateApiSpecRequest, ApiSpec> updateApiSpecSettings;
    private final UnaryCallSettings<DeleteApiSpecRequest, Empty> deleteApiSpecSettings;
    private final UnaryCallSettings<TagApiSpecRevisionRequest, ApiSpec> tagApiSpecRevisionSettings;
    private final PagedCallSettings<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, RegistryClient.ListApiSpecRevisionsPagedResponse> listApiSpecRevisionsSettings;
    private final UnaryCallSettings<RollbackApiSpecRequest, ApiSpec> rollbackApiSpecSettings;
    private final UnaryCallSettings<DeleteApiSpecRevisionRequest, ApiSpec> deleteApiSpecRevisionSettings;
    private final PagedCallSettings<ListApiDeploymentsRequest, ListApiDeploymentsResponse, RegistryClient.ListApiDeploymentsPagedResponse> listApiDeploymentsSettings;
    private final UnaryCallSettings<GetApiDeploymentRequest, ApiDeployment> getApiDeploymentSettings;
    private final UnaryCallSettings<CreateApiDeploymentRequest, ApiDeployment> createApiDeploymentSettings;
    private final UnaryCallSettings<UpdateApiDeploymentRequest, ApiDeployment> updateApiDeploymentSettings;
    private final UnaryCallSettings<DeleteApiDeploymentRequest, Empty> deleteApiDeploymentSettings;
    private final UnaryCallSettings<TagApiDeploymentRevisionRequest, ApiDeployment> tagApiDeploymentRevisionSettings;
    private final PagedCallSettings<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, RegistryClient.ListApiDeploymentRevisionsPagedResponse> listApiDeploymentRevisionsSettings;
    private final UnaryCallSettings<RollbackApiDeploymentRequest, ApiDeployment> rollbackApiDeploymentSettings;
    private final UnaryCallSettings<DeleteApiDeploymentRevisionRequest, ApiDeployment> deleteApiDeploymentRevisionSettings;
    private final PagedCallSettings<ListArtifactsRequest, ListArtifactsResponse, RegistryClient.ListArtifactsPagedResponse> listArtifactsSettings;
    private final UnaryCallSettings<GetArtifactRequest, Artifact> getArtifactSettings;
    private final UnaryCallSettings<GetArtifactContentsRequest, HttpBody> getArtifactContentsSettings;
    private final UnaryCallSettings<CreateArtifactRequest, Artifact> createArtifactSettings;
    private final UnaryCallSettings<ReplaceArtifactRequest, Artifact> replaceArtifactSettings;
    private final UnaryCallSettings<DeleteArtifactRequest, Empty> deleteArtifactSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RegistryClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListApisRequest, ListApisResponse, Api> LIST_APIS_PAGE_STR_DESC = new PagedListDescriptor<ListApisRequest, ListApisResponse, Api>(){

        public String emptyToken() {
            return "";
        }

        public ListApisRequest injectToken(ListApisRequest payload, String token) {
            return ListApisRequest.newBuilder((ListApisRequest)payload).setPageToken(token).build();
        }

        public ListApisRequest injectPageSize(ListApisRequest payload, int pageSize) {
            return ListApisRequest.newBuilder((ListApisRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApisRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApisResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Api> extractResources(ListApisResponse payload) {
            return payload.getApisList() == null ? ImmutableList.of() : payload.getApisList();
        }
    };
    private static final PagedListDescriptor<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion> LIST_API_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListApiVersionsRequest injectToken(ListApiVersionsRequest payload, String token) {
            return ListApiVersionsRequest.newBuilder((ListApiVersionsRequest)payload).setPageToken(token).build();
        }

        public ListApiVersionsRequest injectPageSize(ListApiVersionsRequest payload, int pageSize) {
            return ListApiVersionsRequest.newBuilder((ListApiVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApiVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApiVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApiVersion> extractResources(ListApiVersionsResponse payload) {
            return payload.getApiVersionsList() == null ? ImmutableList.of() : payload.getApiVersionsList();
        }
    };
    private static final PagedListDescriptor<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec> LIST_API_SPECS_PAGE_STR_DESC = new PagedListDescriptor<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec>(){

        public String emptyToken() {
            return "";
        }

        public ListApiSpecsRequest injectToken(ListApiSpecsRequest payload, String token) {
            return ListApiSpecsRequest.newBuilder((ListApiSpecsRequest)payload).setPageToken(token).build();
        }

        public ListApiSpecsRequest injectPageSize(ListApiSpecsRequest payload, int pageSize) {
            return ListApiSpecsRequest.newBuilder((ListApiSpecsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApiSpecsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApiSpecsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApiSpec> extractResources(ListApiSpecsResponse payload) {
            return payload.getApiSpecsList() == null ? ImmutableList.of() : payload.getApiSpecsList();
        }
    };
    private static final PagedListDescriptor<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec> LIST_API_SPEC_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec>(){

        public String emptyToken() {
            return "";
        }

        public ListApiSpecRevisionsRequest injectToken(ListApiSpecRevisionsRequest payload, String token) {
            return ListApiSpecRevisionsRequest.newBuilder((ListApiSpecRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListApiSpecRevisionsRequest injectPageSize(ListApiSpecRevisionsRequest payload, int pageSize) {
            return ListApiSpecRevisionsRequest.newBuilder((ListApiSpecRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApiSpecRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApiSpecRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApiSpec> extractResources(ListApiSpecRevisionsResponse payload) {
            return payload.getApiSpecsList() == null ? ImmutableList.of() : payload.getApiSpecsList();
        }
    };
    private static final PagedListDescriptor<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment> LIST_API_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment>(){

        public String emptyToken() {
            return "";
        }

        public ListApiDeploymentsRequest injectToken(ListApiDeploymentsRequest payload, String token) {
            return ListApiDeploymentsRequest.newBuilder((ListApiDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListApiDeploymentsRequest injectPageSize(ListApiDeploymentsRequest payload, int pageSize) {
            return ListApiDeploymentsRequest.newBuilder((ListApiDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApiDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApiDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApiDeployment> extractResources(ListApiDeploymentsResponse payload) {
            return payload.getApiDeploymentsList() == null ? ImmutableList.of() : payload.getApiDeploymentsList();
        }
    };
    private static final PagedListDescriptor<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment> LIST_API_DEPLOYMENT_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment>(){

        public String emptyToken() {
            return "";
        }

        public ListApiDeploymentRevisionsRequest injectToken(ListApiDeploymentRevisionsRequest payload, String token) {
            return ListApiDeploymentRevisionsRequest.newBuilder((ListApiDeploymentRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListApiDeploymentRevisionsRequest injectPageSize(ListApiDeploymentRevisionsRequest payload, int pageSize) {
            return ListApiDeploymentRevisionsRequest.newBuilder((ListApiDeploymentRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApiDeploymentRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApiDeploymentRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApiDeployment> extractResources(ListApiDeploymentRevisionsResponse payload) {
            return payload.getApiDeploymentsList() == null ? ImmutableList.of() : payload.getApiDeploymentsList();
        }
    };
    private static final PagedListDescriptor<ListArtifactsRequest, ListArtifactsResponse, Artifact> LIST_ARTIFACTS_PAGE_STR_DESC = new PagedListDescriptor<ListArtifactsRequest, ListArtifactsResponse, Artifact>(){

        public String emptyToken() {
            return "";
        }

        public ListArtifactsRequest injectToken(ListArtifactsRequest payload, String token) {
            return ListArtifactsRequest.newBuilder((ListArtifactsRequest)payload).setPageToken(token).build();
        }

        public ListArtifactsRequest injectPageSize(ListArtifactsRequest payload, int pageSize) {
            return ListArtifactsRequest.newBuilder((ListArtifactsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListArtifactsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListArtifactsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Artifact> extractResources(ListArtifactsResponse payload) {
            return payload.getArtifactsList() == null ? ImmutableList.of() : payload.getArtifactsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListApisRequest, ListApisResponse, RegistryClient.ListApisPagedResponse> LIST_APIS_PAGE_STR_FACT = new PagedListResponseFactory<ListApisRequest, ListApisResponse, RegistryClient.ListApisPagedResponse>(){

        public ApiFuture<RegistryClient.ListApisPagedResponse> getFuturePagedResponse(UnaryCallable<ListApisRequest, ListApisResponse> callable, ListApisRequest request, ApiCallContext context, ApiFuture<ListApisResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APIS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListApisPagedResponse.createAsync((PageContext<ListApisRequest, ListApisResponse, Api>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApiVersionsRequest, ListApiVersionsResponse, RegistryClient.ListApiVersionsPagedResponse> LIST_API_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListApiVersionsRequest, ListApiVersionsResponse, RegistryClient.ListApiVersionsPagedResponse>(){

        public ApiFuture<RegistryClient.ListApiVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApiVersionsRequest, ListApiVersionsResponse> callable, ListApiVersionsRequest request, ApiCallContext context, ApiFuture<ListApiVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_API_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListApiVersionsPagedResponse.createAsync((PageContext<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApiSpecsRequest, ListApiSpecsResponse, RegistryClient.ListApiSpecsPagedResponse> LIST_API_SPECS_PAGE_STR_FACT = new PagedListResponseFactory<ListApiSpecsRequest, ListApiSpecsResponse, RegistryClient.ListApiSpecsPagedResponse>(){

        public ApiFuture<RegistryClient.ListApiSpecsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApiSpecsRequest, ListApiSpecsResponse> callable, ListApiSpecsRequest request, ApiCallContext context, ApiFuture<ListApiSpecsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_API_SPECS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListApiSpecsPagedResponse.createAsync((PageContext<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, RegistryClient.ListApiSpecRevisionsPagedResponse> LIST_API_SPEC_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, RegistryClient.ListApiSpecRevisionsPagedResponse>(){

        public ApiFuture<RegistryClient.ListApiSpecRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse> callable, ListApiSpecRevisionsRequest request, ApiCallContext context, ApiFuture<ListApiSpecRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_API_SPEC_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListApiSpecRevisionsPagedResponse.createAsync((PageContext<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApiDeploymentsRequest, ListApiDeploymentsResponse, RegistryClient.ListApiDeploymentsPagedResponse> LIST_API_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListApiDeploymentsRequest, ListApiDeploymentsResponse, RegistryClient.ListApiDeploymentsPagedResponse>(){

        public ApiFuture<RegistryClient.ListApiDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApiDeploymentsRequest, ListApiDeploymentsResponse> callable, ListApiDeploymentsRequest request, ApiCallContext context, ApiFuture<ListApiDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_API_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListApiDeploymentsPagedResponse.createAsync((PageContext<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, RegistryClient.ListApiDeploymentRevisionsPagedResponse> LIST_API_DEPLOYMENT_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, RegistryClient.ListApiDeploymentRevisionsPagedResponse>(){

        public ApiFuture<RegistryClient.ListApiDeploymentRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse> callable, ListApiDeploymentRevisionsRequest request, ApiCallContext context, ApiFuture<ListApiDeploymentRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_API_DEPLOYMENT_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListApiDeploymentRevisionsPagedResponse.createAsync((PageContext<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListArtifactsRequest, ListArtifactsResponse, RegistryClient.ListArtifactsPagedResponse> LIST_ARTIFACTS_PAGE_STR_FACT = new PagedListResponseFactory<ListArtifactsRequest, ListArtifactsResponse, RegistryClient.ListArtifactsPagedResponse>(){

        public ApiFuture<RegistryClient.ListArtifactsPagedResponse> getFuturePagedResponse(UnaryCallable<ListArtifactsRequest, ListArtifactsResponse> callable, ListArtifactsRequest request, ApiCallContext context, ApiFuture<ListArtifactsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ARTIFACTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListArtifactsPagedResponse.createAsync((PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RegistryClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RegistryClient.ListLocationsPagedResponse>(){

        public ApiFuture<RegistryClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistryClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListApisRequest, ListApisResponse, RegistryClient.ListApisPagedResponse> listApisSettings() {
        return this.listApisSettings;
    }

    public UnaryCallSettings<GetApiRequest, Api> getApiSettings() {
        return this.getApiSettings;
    }

    public UnaryCallSettings<CreateApiRequest, Api> createApiSettings() {
        return this.createApiSettings;
    }

    public UnaryCallSettings<UpdateApiRequest, Api> updateApiSettings() {
        return this.updateApiSettings;
    }

    public UnaryCallSettings<DeleteApiRequest, Empty> deleteApiSettings() {
        return this.deleteApiSettings;
    }

    public PagedCallSettings<ListApiVersionsRequest, ListApiVersionsResponse, RegistryClient.ListApiVersionsPagedResponse> listApiVersionsSettings() {
        return this.listApiVersionsSettings;
    }

    public UnaryCallSettings<GetApiVersionRequest, ApiVersion> getApiVersionSettings() {
        return this.getApiVersionSettings;
    }

    public UnaryCallSettings<CreateApiVersionRequest, ApiVersion> createApiVersionSettings() {
        return this.createApiVersionSettings;
    }

    public UnaryCallSettings<UpdateApiVersionRequest, ApiVersion> updateApiVersionSettings() {
        return this.updateApiVersionSettings;
    }

    public UnaryCallSettings<DeleteApiVersionRequest, Empty> deleteApiVersionSettings() {
        return this.deleteApiVersionSettings;
    }

    public PagedCallSettings<ListApiSpecsRequest, ListApiSpecsResponse, RegistryClient.ListApiSpecsPagedResponse> listApiSpecsSettings() {
        return this.listApiSpecsSettings;
    }

    public UnaryCallSettings<GetApiSpecRequest, ApiSpec> getApiSpecSettings() {
        return this.getApiSpecSettings;
    }

    public UnaryCallSettings<GetApiSpecContentsRequest, HttpBody> getApiSpecContentsSettings() {
        return this.getApiSpecContentsSettings;
    }

    public UnaryCallSettings<CreateApiSpecRequest, ApiSpec> createApiSpecSettings() {
        return this.createApiSpecSettings;
    }

    public UnaryCallSettings<UpdateApiSpecRequest, ApiSpec> updateApiSpecSettings() {
        return this.updateApiSpecSettings;
    }

    public UnaryCallSettings<DeleteApiSpecRequest, Empty> deleteApiSpecSettings() {
        return this.deleteApiSpecSettings;
    }

    public UnaryCallSettings<TagApiSpecRevisionRequest, ApiSpec> tagApiSpecRevisionSettings() {
        return this.tagApiSpecRevisionSettings;
    }

    public PagedCallSettings<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, RegistryClient.ListApiSpecRevisionsPagedResponse> listApiSpecRevisionsSettings() {
        return this.listApiSpecRevisionsSettings;
    }

    public UnaryCallSettings<RollbackApiSpecRequest, ApiSpec> rollbackApiSpecSettings() {
        return this.rollbackApiSpecSettings;
    }

    public UnaryCallSettings<DeleteApiSpecRevisionRequest, ApiSpec> deleteApiSpecRevisionSettings() {
        return this.deleteApiSpecRevisionSettings;
    }

    public PagedCallSettings<ListApiDeploymentsRequest, ListApiDeploymentsResponse, RegistryClient.ListApiDeploymentsPagedResponse> listApiDeploymentsSettings() {
        return this.listApiDeploymentsSettings;
    }

    public UnaryCallSettings<GetApiDeploymentRequest, ApiDeployment> getApiDeploymentSettings() {
        return this.getApiDeploymentSettings;
    }

    public UnaryCallSettings<CreateApiDeploymentRequest, ApiDeployment> createApiDeploymentSettings() {
        return this.createApiDeploymentSettings;
    }

    public UnaryCallSettings<UpdateApiDeploymentRequest, ApiDeployment> updateApiDeploymentSettings() {
        return this.updateApiDeploymentSettings;
    }

    public UnaryCallSettings<DeleteApiDeploymentRequest, Empty> deleteApiDeploymentSettings() {
        return this.deleteApiDeploymentSettings;
    }

    public UnaryCallSettings<TagApiDeploymentRevisionRequest, ApiDeployment> tagApiDeploymentRevisionSettings() {
        return this.tagApiDeploymentRevisionSettings;
    }

    public PagedCallSettings<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, RegistryClient.ListApiDeploymentRevisionsPagedResponse> listApiDeploymentRevisionsSettings() {
        return this.listApiDeploymentRevisionsSettings;
    }

    public UnaryCallSettings<RollbackApiDeploymentRequest, ApiDeployment> rollbackApiDeploymentSettings() {
        return this.rollbackApiDeploymentSettings;
    }

    public UnaryCallSettings<DeleteApiDeploymentRevisionRequest, ApiDeployment> deleteApiDeploymentRevisionSettings() {
        return this.deleteApiDeploymentRevisionSettings;
    }

    public PagedCallSettings<ListArtifactsRequest, ListArtifactsResponse, RegistryClient.ListArtifactsPagedResponse> listArtifactsSettings() {
        return this.listArtifactsSettings;
    }

    public UnaryCallSettings<GetArtifactRequest, Artifact> getArtifactSettings() {
        return this.getArtifactSettings;
    }

    public UnaryCallSettings<GetArtifactContentsRequest, HttpBody> getArtifactContentsSettings() {
        return this.getArtifactContentsSettings;
    }

    public UnaryCallSettings<CreateArtifactRequest, Artifact> createArtifactSettings() {
        return this.createArtifactSettings;
    }

    public UnaryCallSettings<ReplaceArtifactRequest, Artifact> replaceArtifactSettings() {
        return this.replaceArtifactSettings;
    }

    public UnaryCallSettings<DeleteArtifactRequest, Empty> deleteArtifactSettings() {
        return this.deleteArtifactSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RegistryClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public RegistryStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRegistryStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegistryStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RegistryStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "apigeeregistry";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "apigeeregistry.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apigeeregistry.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegistryStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegistryStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegistryStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RegistryStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegistryStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listApisSettings = settingsBuilder.listApisSettings().build();
        this.getApiSettings = settingsBuilder.getApiSettings().build();
        this.createApiSettings = settingsBuilder.createApiSettings().build();
        this.updateApiSettings = settingsBuilder.updateApiSettings().build();
        this.deleteApiSettings = settingsBuilder.deleteApiSettings().build();
        this.listApiVersionsSettings = settingsBuilder.listApiVersionsSettings().build();
        this.getApiVersionSettings = settingsBuilder.getApiVersionSettings().build();
        this.createApiVersionSettings = settingsBuilder.createApiVersionSettings().build();
        this.updateApiVersionSettings = settingsBuilder.updateApiVersionSettings().build();
        this.deleteApiVersionSettings = settingsBuilder.deleteApiVersionSettings().build();
        this.listApiSpecsSettings = settingsBuilder.listApiSpecsSettings().build();
        this.getApiSpecSettings = settingsBuilder.getApiSpecSettings().build();
        this.getApiSpecContentsSettings = settingsBuilder.getApiSpecContentsSettings().build();
        this.createApiSpecSettings = settingsBuilder.createApiSpecSettings().build();
        this.updateApiSpecSettings = settingsBuilder.updateApiSpecSettings().build();
        this.deleteApiSpecSettings = settingsBuilder.deleteApiSpecSettings().build();
        this.tagApiSpecRevisionSettings = settingsBuilder.tagApiSpecRevisionSettings().build();
        this.listApiSpecRevisionsSettings = settingsBuilder.listApiSpecRevisionsSettings().build();
        this.rollbackApiSpecSettings = settingsBuilder.rollbackApiSpecSettings().build();
        this.deleteApiSpecRevisionSettings = settingsBuilder.deleteApiSpecRevisionSettings().build();
        this.listApiDeploymentsSettings = settingsBuilder.listApiDeploymentsSettings().build();
        this.getApiDeploymentSettings = settingsBuilder.getApiDeploymentSettings().build();
        this.createApiDeploymentSettings = settingsBuilder.createApiDeploymentSettings().build();
        this.updateApiDeploymentSettings = settingsBuilder.updateApiDeploymentSettings().build();
        this.deleteApiDeploymentSettings = settingsBuilder.deleteApiDeploymentSettings().build();
        this.tagApiDeploymentRevisionSettings = settingsBuilder.tagApiDeploymentRevisionSettings().build();
        this.listApiDeploymentRevisionsSettings = settingsBuilder.listApiDeploymentRevisionsSettings().build();
        this.rollbackApiDeploymentSettings = settingsBuilder.rollbackApiDeploymentSettings().build();
        this.deleteApiDeploymentRevisionSettings = settingsBuilder.deleteApiDeploymentRevisionSettings().build();
        this.listArtifactsSettings = settingsBuilder.listArtifactsSettings().build();
        this.getArtifactSettings = settingsBuilder.getArtifactSettings().build();
        this.getArtifactContentsSettings = settingsBuilder.getArtifactContentsSettings().build();
        this.createArtifactSettings = settingsBuilder.createArtifactSettings().build();
        this.replaceArtifactSettings = settingsBuilder.replaceArtifactSettings().build();
        this.deleteArtifactSettings = settingsBuilder.deleteArtifactSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegistryStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListApisRequest, ListApisResponse, RegistryClient.ListApisPagedResponse> listApisSettings;
        private final UnaryCallSettings.Builder<GetApiRequest, Api> getApiSettings;
        private final UnaryCallSettings.Builder<CreateApiRequest, Api> createApiSettings;
        private final UnaryCallSettings.Builder<UpdateApiRequest, Api> updateApiSettings;
        private final UnaryCallSettings.Builder<DeleteApiRequest, Empty> deleteApiSettings;
        private final PagedCallSettings.Builder<ListApiVersionsRequest, ListApiVersionsResponse, RegistryClient.ListApiVersionsPagedResponse> listApiVersionsSettings;
        private final UnaryCallSettings.Builder<GetApiVersionRequest, ApiVersion> getApiVersionSettings;
        private final UnaryCallSettings.Builder<CreateApiVersionRequest, ApiVersion> createApiVersionSettings;
        private final UnaryCallSettings.Builder<UpdateApiVersionRequest, ApiVersion> updateApiVersionSettings;
        private final UnaryCallSettings.Builder<DeleteApiVersionRequest, Empty> deleteApiVersionSettings;
        private final PagedCallSettings.Builder<ListApiSpecsRequest, ListApiSpecsResponse, RegistryClient.ListApiSpecsPagedResponse> listApiSpecsSettings;
        private final UnaryCallSettings.Builder<GetApiSpecRequest, ApiSpec> getApiSpecSettings;
        private final UnaryCallSettings.Builder<GetApiSpecContentsRequest, HttpBody> getApiSpecContentsSettings;
        private final UnaryCallSettings.Builder<CreateApiSpecRequest, ApiSpec> createApiSpecSettings;
        private final UnaryCallSettings.Builder<UpdateApiSpecRequest, ApiSpec> updateApiSpecSettings;
        private final UnaryCallSettings.Builder<DeleteApiSpecRequest, Empty> deleteApiSpecSettings;
        private final UnaryCallSettings.Builder<TagApiSpecRevisionRequest, ApiSpec> tagApiSpecRevisionSettings;
        private final PagedCallSettings.Builder<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, RegistryClient.ListApiSpecRevisionsPagedResponse> listApiSpecRevisionsSettings;
        private final UnaryCallSettings.Builder<RollbackApiSpecRequest, ApiSpec> rollbackApiSpecSettings;
        private final UnaryCallSettings.Builder<DeleteApiSpecRevisionRequest, ApiSpec> deleteApiSpecRevisionSettings;
        private final PagedCallSettings.Builder<ListApiDeploymentsRequest, ListApiDeploymentsResponse, RegistryClient.ListApiDeploymentsPagedResponse> listApiDeploymentsSettings;
        private final UnaryCallSettings.Builder<GetApiDeploymentRequest, ApiDeployment> getApiDeploymentSettings;
        private final UnaryCallSettings.Builder<CreateApiDeploymentRequest, ApiDeployment> createApiDeploymentSettings;
        private final UnaryCallSettings.Builder<UpdateApiDeploymentRequest, ApiDeployment> updateApiDeploymentSettings;
        private final UnaryCallSettings.Builder<DeleteApiDeploymentRequest, Empty> deleteApiDeploymentSettings;
        private final UnaryCallSettings.Builder<TagApiDeploymentRevisionRequest, ApiDeployment> tagApiDeploymentRevisionSettings;
        private final PagedCallSettings.Builder<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, RegistryClient.ListApiDeploymentRevisionsPagedResponse> listApiDeploymentRevisionsSettings;
        private final UnaryCallSettings.Builder<RollbackApiDeploymentRequest, ApiDeployment> rollbackApiDeploymentSettings;
        private final UnaryCallSettings.Builder<DeleteApiDeploymentRevisionRequest, ApiDeployment> deleteApiDeploymentRevisionSettings;
        private final PagedCallSettings.Builder<ListArtifactsRequest, ListArtifactsResponse, RegistryClient.ListArtifactsPagedResponse> listArtifactsSettings;
        private final UnaryCallSettings.Builder<GetArtifactRequest, Artifact> getArtifactSettings;
        private final UnaryCallSettings.Builder<GetArtifactContentsRequest, HttpBody> getArtifactContentsSettings;
        private final UnaryCallSettings.Builder<CreateArtifactRequest, Artifact> createArtifactSettings;
        private final UnaryCallSettings.Builder<ReplaceArtifactRequest, Artifact> replaceArtifactSettings;
        private final UnaryCallSettings.Builder<DeleteArtifactRequest, Empty> deleteArtifactSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RegistryClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listApisSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APIS_PAGE_STR_FACT);
            this.getApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApiVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_API_VERSIONS_PAGE_STR_FACT);
            this.getApiVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApiVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApiSpecsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_API_SPECS_PAGE_STR_FACT);
            this.getApiSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getApiSpecContentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApiSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.tagApiSpecRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApiSpecRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_API_SPEC_REVISIONS_PAGE_STR_FACT);
            this.rollbackApiSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiSpecRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApiDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_API_DEPLOYMENTS_PAGE_STR_FACT);
            this.getApiDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApiDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.tagApiDeploymentRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApiDeploymentRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_API_DEPLOYMENT_REVISIONS_PAGE_STR_FACT);
            this.rollbackApiDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiDeploymentRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listArtifactsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ARTIFACTS_PAGE_STR_FACT);
            this.getArtifactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getArtifactContentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createArtifactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.replaceArtifactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteArtifactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listApisSettings, this.getApiSettings, this.createApiSettings, this.updateApiSettings, this.deleteApiSettings, this.listApiVersionsSettings, this.getApiVersionSettings, this.createApiVersionSettings, this.updateApiVersionSettings, this.deleteApiVersionSettings, this.listApiSpecsSettings, this.getApiSpecSettings, (Object[])new UnaryCallSettings.Builder[]{this.getApiSpecContentsSettings, this.createApiSpecSettings, this.updateApiSpecSettings, this.deleteApiSpecSettings, this.tagApiSpecRevisionSettings, this.listApiSpecRevisionsSettings, this.rollbackApiSpecSettings, this.deleteApiSpecRevisionSettings, this.listApiDeploymentsSettings, this.getApiDeploymentSettings, this.createApiDeploymentSettings, this.updateApiDeploymentSettings, this.deleteApiDeploymentSettings, this.tagApiDeploymentRevisionSettings, this.listApiDeploymentRevisionsSettings, this.rollbackApiDeploymentSettings, this.deleteApiDeploymentRevisionSettings, this.listArtifactsSettings, this.getArtifactSettings, this.getArtifactContentsSettings, this.createArtifactSettings, this.replaceArtifactSettings, this.deleteArtifactSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RegistryStubSettings settings) {
            super((StubSettings)settings);
            this.listApisSettings = settings.listApisSettings.toBuilder();
            this.getApiSettings = settings.getApiSettings.toBuilder();
            this.createApiSettings = settings.createApiSettings.toBuilder();
            this.updateApiSettings = settings.updateApiSettings.toBuilder();
            this.deleteApiSettings = settings.deleteApiSettings.toBuilder();
            this.listApiVersionsSettings = settings.listApiVersionsSettings.toBuilder();
            this.getApiVersionSettings = settings.getApiVersionSettings.toBuilder();
            this.createApiVersionSettings = settings.createApiVersionSettings.toBuilder();
            this.updateApiVersionSettings = settings.updateApiVersionSettings.toBuilder();
            this.deleteApiVersionSettings = settings.deleteApiVersionSettings.toBuilder();
            this.listApiSpecsSettings = settings.listApiSpecsSettings.toBuilder();
            this.getApiSpecSettings = settings.getApiSpecSettings.toBuilder();
            this.getApiSpecContentsSettings = settings.getApiSpecContentsSettings.toBuilder();
            this.createApiSpecSettings = settings.createApiSpecSettings.toBuilder();
            this.updateApiSpecSettings = settings.updateApiSpecSettings.toBuilder();
            this.deleteApiSpecSettings = settings.deleteApiSpecSettings.toBuilder();
            this.tagApiSpecRevisionSettings = settings.tagApiSpecRevisionSettings.toBuilder();
            this.listApiSpecRevisionsSettings = settings.listApiSpecRevisionsSettings.toBuilder();
            this.rollbackApiSpecSettings = settings.rollbackApiSpecSettings.toBuilder();
            this.deleteApiSpecRevisionSettings = settings.deleteApiSpecRevisionSettings.toBuilder();
            this.listApiDeploymentsSettings = settings.listApiDeploymentsSettings.toBuilder();
            this.getApiDeploymentSettings = settings.getApiDeploymentSettings.toBuilder();
            this.createApiDeploymentSettings = settings.createApiDeploymentSettings.toBuilder();
            this.updateApiDeploymentSettings = settings.updateApiDeploymentSettings.toBuilder();
            this.deleteApiDeploymentSettings = settings.deleteApiDeploymentSettings.toBuilder();
            this.tagApiDeploymentRevisionSettings = settings.tagApiDeploymentRevisionSettings.toBuilder();
            this.listApiDeploymentRevisionsSettings = settings.listApiDeploymentRevisionsSettings.toBuilder();
            this.rollbackApiDeploymentSettings = settings.rollbackApiDeploymentSettings.toBuilder();
            this.deleteApiDeploymentRevisionSettings = settings.deleteApiDeploymentRevisionSettings.toBuilder();
            this.listArtifactsSettings = settings.listArtifactsSettings.toBuilder();
            this.getArtifactSettings = settings.getArtifactSettings.toBuilder();
            this.getArtifactContentsSettings = settings.getArtifactContentsSettings.toBuilder();
            this.createArtifactSettings = settings.createArtifactSettings.toBuilder();
            this.replaceArtifactSettings = settings.replaceArtifactSettings.toBuilder();
            this.deleteArtifactSettings = settings.deleteArtifactSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listApisSettings, this.getApiSettings, this.createApiSettings, this.updateApiSettings, this.deleteApiSettings, this.listApiVersionsSettings, this.getApiVersionSettings, this.createApiVersionSettings, this.updateApiVersionSettings, this.deleteApiVersionSettings, this.listApiSpecsSettings, this.getApiSpecSettings, (Object[])new UnaryCallSettings.Builder[]{this.getApiSpecContentsSettings, this.createApiSpecSettings, this.updateApiSpecSettings, this.deleteApiSpecSettings, this.tagApiSpecRevisionSettings, this.listApiSpecRevisionsSettings, this.rollbackApiSpecSettings, this.deleteApiSpecRevisionSettings, this.listApiDeploymentsSettings, this.getApiDeploymentSettings, this.createApiDeploymentSettings, this.updateApiDeploymentSettings, this.deleteApiDeploymentSettings, this.tagApiDeploymentRevisionSettings, this.listApiDeploymentRevisionsSettings, this.rollbackApiDeploymentSettings, this.deleteApiDeploymentRevisionSettings, this.listArtifactsSettings, this.getArtifactSettings, this.getArtifactContentsSettings, this.createArtifactSettings, this.replaceArtifactSettings, this.deleteArtifactSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegistryStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegistryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegistryStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegistryStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RegistryStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RegistryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegistryStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegistryStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listApisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApiVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getApiVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createApiVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteApiVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApiSpecsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getApiSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getApiSpecContentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createApiSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteApiSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.tagApiSpecRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApiSpecRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.rollbackApiSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteApiSpecRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApiDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getApiDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createApiDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteApiDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.tagApiDeploymentRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApiDeploymentRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.rollbackApiDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteApiDeploymentRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listArtifactsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getArtifactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getArtifactContentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createArtifactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.replaceArtifactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteArtifactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListApisRequest, ListApisResponse, RegistryClient.ListApisPagedResponse> listApisSettings() {
            return this.listApisSettings;
        }

        public UnaryCallSettings.Builder<GetApiRequest, Api> getApiSettings() {
            return this.getApiSettings;
        }

        public UnaryCallSettings.Builder<CreateApiRequest, Api> createApiSettings() {
            return this.createApiSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiRequest, Api> updateApiSettings() {
            return this.updateApiSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiRequest, Empty> deleteApiSettings() {
            return this.deleteApiSettings;
        }

        public PagedCallSettings.Builder<ListApiVersionsRequest, ListApiVersionsResponse, RegistryClient.ListApiVersionsPagedResponse> listApiVersionsSettings() {
            return this.listApiVersionsSettings;
        }

        public UnaryCallSettings.Builder<GetApiVersionRequest, ApiVersion> getApiVersionSettings() {
            return this.getApiVersionSettings;
        }

        public UnaryCallSettings.Builder<CreateApiVersionRequest, ApiVersion> createApiVersionSettings() {
            return this.createApiVersionSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiVersionRequest, ApiVersion> updateApiVersionSettings() {
            return this.updateApiVersionSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiVersionRequest, Empty> deleteApiVersionSettings() {
            return this.deleteApiVersionSettings;
        }

        public PagedCallSettings.Builder<ListApiSpecsRequest, ListApiSpecsResponse, RegistryClient.ListApiSpecsPagedResponse> listApiSpecsSettings() {
            return this.listApiSpecsSettings;
        }

        public UnaryCallSettings.Builder<GetApiSpecRequest, ApiSpec> getApiSpecSettings() {
            return this.getApiSpecSettings;
        }

        public UnaryCallSettings.Builder<GetApiSpecContentsRequest, HttpBody> getApiSpecContentsSettings() {
            return this.getApiSpecContentsSettings;
        }

        public UnaryCallSettings.Builder<CreateApiSpecRequest, ApiSpec> createApiSpecSettings() {
            return this.createApiSpecSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiSpecRequest, ApiSpec> updateApiSpecSettings() {
            return this.updateApiSpecSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiSpecRequest, Empty> deleteApiSpecSettings() {
            return this.deleteApiSpecSettings;
        }

        public UnaryCallSettings.Builder<TagApiSpecRevisionRequest, ApiSpec> tagApiSpecRevisionSettings() {
            return this.tagApiSpecRevisionSettings;
        }

        public PagedCallSettings.Builder<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, RegistryClient.ListApiSpecRevisionsPagedResponse> listApiSpecRevisionsSettings() {
            return this.listApiSpecRevisionsSettings;
        }

        public UnaryCallSettings.Builder<RollbackApiSpecRequest, ApiSpec> rollbackApiSpecSettings() {
            return this.rollbackApiSpecSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiSpecRevisionRequest, ApiSpec> deleteApiSpecRevisionSettings() {
            return this.deleteApiSpecRevisionSettings;
        }

        public PagedCallSettings.Builder<ListApiDeploymentsRequest, ListApiDeploymentsResponse, RegistryClient.ListApiDeploymentsPagedResponse> listApiDeploymentsSettings() {
            return this.listApiDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<GetApiDeploymentRequest, ApiDeployment> getApiDeploymentSettings() {
            return this.getApiDeploymentSettings;
        }

        public UnaryCallSettings.Builder<CreateApiDeploymentRequest, ApiDeployment> createApiDeploymentSettings() {
            return this.createApiDeploymentSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiDeploymentRequest, ApiDeployment> updateApiDeploymentSettings() {
            return this.updateApiDeploymentSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiDeploymentRequest, Empty> deleteApiDeploymentSettings() {
            return this.deleteApiDeploymentSettings;
        }

        public UnaryCallSettings.Builder<TagApiDeploymentRevisionRequest, ApiDeployment> tagApiDeploymentRevisionSettings() {
            return this.tagApiDeploymentRevisionSettings;
        }

        public PagedCallSettings.Builder<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, RegistryClient.ListApiDeploymentRevisionsPagedResponse> listApiDeploymentRevisionsSettings() {
            return this.listApiDeploymentRevisionsSettings;
        }

        public UnaryCallSettings.Builder<RollbackApiDeploymentRequest, ApiDeployment> rollbackApiDeploymentSettings() {
            return this.rollbackApiDeploymentSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiDeploymentRevisionRequest, ApiDeployment> deleteApiDeploymentRevisionSettings() {
            return this.deleteApiDeploymentRevisionSettings;
        }

        public PagedCallSettings.Builder<ListArtifactsRequest, ListArtifactsResponse, RegistryClient.ListArtifactsPagedResponse> listArtifactsSettings() {
            return this.listArtifactsSettings;
        }

        public UnaryCallSettings.Builder<GetArtifactRequest, Artifact> getArtifactSettings() {
            return this.getArtifactSettings;
        }

        public UnaryCallSettings.Builder<GetArtifactContentsRequest, HttpBody> getArtifactContentsSettings() {
            return this.getArtifactContentsSettings;
        }

        public UnaryCallSettings.Builder<CreateArtifactRequest, Artifact> createArtifactSettings() {
            return this.createArtifactSettings;
        }

        public UnaryCallSettings.Builder<ReplaceArtifactRequest, Artifact> replaceArtifactSettings() {
            return this.replaceArtifactSettings;
        }

        public UnaryCallSettings.Builder<DeleteArtifactRequest, Empty> deleteArtifactSettings() {
            return this.deleteArtifactSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RegistryClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RegistryStubSettings.getDefaultEndpoint();
        }

        public RegistryStubSettings build() throws IOException {
            return new RegistryStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.CANCELLED, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)200L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

