/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeconnect.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigeeconnect.v1.ConnectionServiceClient;
import com.google.cloud.apigeeconnect.v1.ListConnectionsRequest;
import com.google.cloud.apigeeconnect.v1.ListConnectionsResponse;
import com.google.cloud.apigeeconnect.v1.stub.ConnectionServiceStub;
import com.google.cloud.apigeeconnect.v1.stub.ConnectionServiceStubSettings;
import com.google.cloud.apigeeconnect.v1.stub.GrpcConnectionServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcConnectionServiceStub
extends ConnectionServiceStub {
    private static final MethodDescriptor<ListConnectionsRequest, ListConnectionsResponse> listConnectionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigeeconnect.v1.ConnectionService/ListConnections").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConnectionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConnectionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable;
    private final UnaryCallable<ListConnectionsRequest, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConnectionServiceStub create(ConnectionServiceStubSettings settings) throws IOException {
        return new GrpcConnectionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConnectionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcConnectionServiceStub(ConnectionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConnectionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConnectionServiceStub(ConnectionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConnectionServiceStub(ConnectionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConnectionServiceCallableFactory());
    }

    protected GrpcConnectionServiceStub(ConnectionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConnectionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConnectionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListConnectionsRequest>(){

            public Map<String, String> extract(ListConnectionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.listConnectionsCallable = callableFactory.createUnaryCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.listConnectionsPagedCallable = callableFactory.createPagedCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.listConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.listConnectionsPagedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

