/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeconnect.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigeeconnect.v1.Connection;
import com.google.cloud.apigeeconnect.v1.ConnectionServiceSettings;
import com.google.cloud.apigeeconnect.v1.EndpointName;
import com.google.cloud.apigeeconnect.v1.ListConnectionsRequest;
import com.google.cloud.apigeeconnect.v1.ListConnectionsResponse;
import com.google.cloud.apigeeconnect.v1.stub.ConnectionServiceStub;
import com.google.cloud.apigeeconnect.v1.stub.ConnectionServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConnectionServiceClient
implements BackgroundResource {
    private final ConnectionServiceSettings settings;
    private final ConnectionServiceStub stub;

    public static final ConnectionServiceClient create() throws IOException {
        return ConnectionServiceClient.create(ConnectionServiceSettings.newBuilder().build());
    }

    public static final ConnectionServiceClient create(ConnectionServiceSettings settings) throws IOException {
        return new ConnectionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ConnectionServiceClient create(ConnectionServiceStub stub) {
        return new ConnectionServiceClient(stub);
    }

    protected ConnectionServiceClient(ConnectionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConnectionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ConnectionServiceClient(ConnectionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConnectionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConnectionServiceStub getStub() {
        return this.stub;
    }

    public final ListConnectionsPagedResponse listConnections(EndpointName parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(String parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(ListConnectionsRequest request) {
        return (ListConnectionsPagedResponse)((Object)this.listConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.stub.listConnectionsPagedCallable();
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.stub.listConnectionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        private ListConnectionsFixedSizeCollection(List<ListConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListConnectionsFixedSizeCollection(null, 0);
        }

        protected ListConnectionsFixedSizeCollection createCollection(List<ListConnectionsPage> pages, int collectionSize) {
            return new ListConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionsPage
    extends AbstractPage<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage> {
        private ListConnectionsPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionsPage createEmptyPage() {
            return new ListConnectionsPage(null, null);
        }

        protected ListConnectionsPage createPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            return new ListConnectionsPage(context, response);
        }

        public ApiFuture<ListConnectionsPage> createPageAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionsPagedResponse
    extends AbstractPagedListResponse<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        public static ApiFuture<ListConnectionsPagedResponse> createAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            ApiFuture<ListConnectionsPage> futurePage = ListConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListConnectionsPage, ListConnectionsPagedResponse>(){

                public ListConnectionsPagedResponse apply(ListConnectionsPage input) {
                    return new ListConnectionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionsPagedResponse(ListConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

