/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigateway.v1.Api;
import com.google.cloud.apigateway.v1.ApiConfig;
import com.google.cloud.apigateway.v1.ApiGatewayServiceClient;
import com.google.cloud.apigateway.v1.CreateApiConfigRequest;
import com.google.cloud.apigateway.v1.CreateApiRequest;
import com.google.cloud.apigateway.v1.CreateGatewayRequest;
import com.google.cloud.apigateway.v1.DeleteApiConfigRequest;
import com.google.cloud.apigateway.v1.DeleteApiRequest;
import com.google.cloud.apigateway.v1.DeleteGatewayRequest;
import com.google.cloud.apigateway.v1.Gateway;
import com.google.cloud.apigateway.v1.GetApiConfigRequest;
import com.google.cloud.apigateway.v1.GetApiRequest;
import com.google.cloud.apigateway.v1.GetGatewayRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsResponse;
import com.google.cloud.apigateway.v1.ListApisRequest;
import com.google.cloud.apigateway.v1.ListApisResponse;
import com.google.cloud.apigateway.v1.ListGatewaysRequest;
import com.google.cloud.apigateway.v1.ListGatewaysResponse;
import com.google.cloud.apigateway.v1.OperationMetadata;
import com.google.cloud.apigateway.v1.UpdateApiConfigRequest;
import com.google.cloud.apigateway.v1.UpdateApiRequest;
import com.google.cloud.apigateway.v1.UpdateGatewayRequest;
import com.google.cloud.apigateway.v1.stub.ApiGatewayServiceStub;
import com.google.cloud.apigateway.v1.stub.ApiGatewayServiceStubSettings;
import com.google.cloud.apigateway.v1.stub.HttpJsonApiGatewayServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonApiGatewayServiceStub
extends ApiGatewayServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(OperationMetadata.getDescriptor()).add(Empty.getDescriptor()).add(Gateway.getDescriptor()).add(ApiConfig.getDescriptor()).add(Api.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListGatewaysRequest, ListGatewaysResponse> listGatewaysMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/ListGateways").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/gateways", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListGatewaysResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetGatewayRequest, Gateway> getGatewayMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/GetGateway").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/gateways/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Gateway.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateGatewayRequest, Operation> createGatewayMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/CreateGateway").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/gateways", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "gatewayId", (Object)request.getGatewayId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("gateway", (Message)request.getGateway(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateGatewayRequest, Operation> updateGatewayMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/UpdateGateway").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{gateway.name=projects/*/locations/*/gateways/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "gateway.name", (Object)request.getGateway().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("gateway", (Message)request.getGateway(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteGatewayRequest, Operation> deleteGatewayMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/DeleteGateway").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/gateways/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListApisRequest, ListApisResponse> listApisMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/ListApis").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/apis", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListApisResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetApiRequest, Api> getApiMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/GetApi").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/apis/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Api.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateApiRequest, Operation> createApiMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/CreateApi").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/apis", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "apiId", (Object)request.getApiId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("api", (Message)request.getApi(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateApiRequest, Operation> updateApiMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/UpdateApi").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{api.name=projects/*/locations/*/apis/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "api.name", (Object)request.getApi().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("api", (Message)request.getApi(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteApiRequest, Operation> deleteApiMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/DeleteApi").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/apis/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListApiConfigsRequest, ListApiConfigsResponse> listApiConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/ListApiConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/apis/*}/configs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListApiConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetApiConfigRequest, ApiConfig> getApiConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/GetApiConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/apis/*/configs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ApiConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateApiConfigRequest, Operation> createApiConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/CreateApiConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/apis/*}/configs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "apiConfigId", (Object)request.getApiConfigId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("apiConfig", (Message)request.getApiConfig(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateApiConfigRequest, Operation> updateApiConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/UpdateApiConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{apiConfig.name=projects/*/locations/*/apis/*/configs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "apiConfig.name", (Object)request.getApiConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("apiConfig", (Message)request.getApiConfig(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteApiConfigRequest, Operation> deleteApiConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/DeleteApiConfig").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/apis/*/configs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> listGatewaysCallable;
    private final UnaryCallable<ListGatewaysRequest, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysPagedCallable;
    private final UnaryCallable<GetGatewayRequest, Gateway> getGatewayCallable;
    private final UnaryCallable<CreateGatewayRequest, Operation> createGatewayCallable;
    private final OperationCallable<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationCallable;
    private final UnaryCallable<UpdateGatewayRequest, Operation> updateGatewayCallable;
    private final OperationCallable<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationCallable;
    private final UnaryCallable<DeleteGatewayRequest, Operation> deleteGatewayCallable;
    private final OperationCallable<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationCallable;
    private final UnaryCallable<ListApisRequest, ListApisResponse> listApisCallable;
    private final UnaryCallable<ListApisRequest, ApiGatewayServiceClient.ListApisPagedResponse> listApisPagedCallable;
    private final UnaryCallable<GetApiRequest, Api> getApiCallable;
    private final UnaryCallable<CreateApiRequest, Operation> createApiCallable;
    private final OperationCallable<CreateApiRequest, Api, OperationMetadata> createApiOperationCallable;
    private final UnaryCallable<UpdateApiRequest, Operation> updateApiCallable;
    private final OperationCallable<UpdateApiRequest, Api, OperationMetadata> updateApiOperationCallable;
    private final UnaryCallable<DeleteApiRequest, Operation> deleteApiCallable;
    private final OperationCallable<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationCallable;
    private final UnaryCallable<ListApiConfigsRequest, ListApiConfigsResponse> listApiConfigsCallable;
    private final UnaryCallable<ListApiConfigsRequest, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsPagedCallable;
    private final UnaryCallable<GetApiConfigRequest, ApiConfig> getApiConfigCallable;
    private final UnaryCallable<CreateApiConfigRequest, Operation> createApiConfigCallable;
    private final OperationCallable<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationCallable;
    private final UnaryCallable<UpdateApiConfigRequest, Operation> updateApiConfigCallable;
    private final OperationCallable<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationCallable;
    private final UnaryCallable<DeleteApiConfigRequest, Operation> deleteApiConfigCallable;
    private final OperationCallable<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonApiGatewayServiceStub create(ApiGatewayServiceStubSettings settings) throws IOException {
        return new HttpJsonApiGatewayServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonApiGatewayServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonApiGatewayServiceStub(ApiGatewayServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonApiGatewayServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonApiGatewayServiceStub(ApiGatewayServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonApiGatewayServiceStub(ApiGatewayServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonApiGatewayServiceCallableFactory());
    }

    protected HttpJsonApiGatewayServiceStub(ApiGatewayServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listGatewaysTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listGatewaysMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getGatewayTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGatewayMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createGatewayTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createGatewayMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateGatewayTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateGatewayMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteGatewayTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteGatewayMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listApisTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listApisMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getApiTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getApiMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createApiTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createApiMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateApiTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateApiMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteApiTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteApiMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listApiConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listApiConfigsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getApiConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getApiConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createApiConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createApiConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateApiConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateApiConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteApiConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteApiConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listGatewaysCallable = callableFactory.createUnaryCallable(listGatewaysTransportSettings, settings.listGatewaysSettings(), clientContext);
        this.listGatewaysPagedCallable = callableFactory.createPagedCallable(listGatewaysTransportSettings, settings.listGatewaysSettings(), clientContext);
        this.getGatewayCallable = callableFactory.createUnaryCallable(getGatewayTransportSettings, settings.getGatewaySettings(), clientContext);
        this.createGatewayCallable = callableFactory.createUnaryCallable(createGatewayTransportSettings, settings.createGatewaySettings(), clientContext);
        this.createGatewayOperationCallable = callableFactory.createOperationCallable(createGatewayTransportSettings, settings.createGatewayOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateGatewayCallable = callableFactory.createUnaryCallable(updateGatewayTransportSettings, settings.updateGatewaySettings(), clientContext);
        this.updateGatewayOperationCallable = callableFactory.createOperationCallable(updateGatewayTransportSettings, settings.updateGatewayOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteGatewayCallable = callableFactory.createUnaryCallable(deleteGatewayTransportSettings, settings.deleteGatewaySettings(), clientContext);
        this.deleteGatewayOperationCallable = callableFactory.createOperationCallable(deleteGatewayTransportSettings, settings.deleteGatewayOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listApisCallable = callableFactory.createUnaryCallable(listApisTransportSettings, settings.listApisSettings(), clientContext);
        this.listApisPagedCallable = callableFactory.createPagedCallable(listApisTransportSettings, settings.listApisSettings(), clientContext);
        this.getApiCallable = callableFactory.createUnaryCallable(getApiTransportSettings, settings.getApiSettings(), clientContext);
        this.createApiCallable = callableFactory.createUnaryCallable(createApiTransportSettings, settings.createApiSettings(), clientContext);
        this.createApiOperationCallable = callableFactory.createOperationCallable(createApiTransportSettings, settings.createApiOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateApiCallable = callableFactory.createUnaryCallable(updateApiTransportSettings, settings.updateApiSettings(), clientContext);
        this.updateApiOperationCallable = callableFactory.createOperationCallable(updateApiTransportSettings, settings.updateApiOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteApiCallable = callableFactory.createUnaryCallable(deleteApiTransportSettings, settings.deleteApiSettings(), clientContext);
        this.deleteApiOperationCallable = callableFactory.createOperationCallable(deleteApiTransportSettings, settings.deleteApiOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listApiConfigsCallable = callableFactory.createUnaryCallable(listApiConfigsTransportSettings, settings.listApiConfigsSettings(), clientContext);
        this.listApiConfigsPagedCallable = callableFactory.createPagedCallable(listApiConfigsTransportSettings, settings.listApiConfigsSettings(), clientContext);
        this.getApiConfigCallable = callableFactory.createUnaryCallable(getApiConfigTransportSettings, settings.getApiConfigSettings(), clientContext);
        this.createApiConfigCallable = callableFactory.createUnaryCallable(createApiConfigTransportSettings, settings.createApiConfigSettings(), clientContext);
        this.createApiConfigOperationCallable = callableFactory.createOperationCallable(createApiConfigTransportSettings, settings.createApiConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateApiConfigCallable = callableFactory.createUnaryCallable(updateApiConfigTransportSettings, settings.updateApiConfigSettings(), clientContext);
        this.updateApiConfigOperationCallable = callableFactory.createOperationCallable(updateApiConfigTransportSettings, settings.updateApiConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteApiConfigCallable = callableFactory.createUnaryCallable(deleteApiConfigTransportSettings, settings.deleteApiConfigSettings(), clientContext);
        this.deleteApiConfigOperationCallable = callableFactory.createOperationCallable(deleteApiConfigTransportSettings, settings.deleteApiConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listGatewaysMethodDescriptor);
        methodDescriptors.add(getGatewayMethodDescriptor);
        methodDescriptors.add(createGatewayMethodDescriptor);
        methodDescriptors.add(updateGatewayMethodDescriptor);
        methodDescriptors.add(deleteGatewayMethodDescriptor);
        methodDescriptors.add(listApisMethodDescriptor);
        methodDescriptors.add(getApiMethodDescriptor);
        methodDescriptors.add(createApiMethodDescriptor);
        methodDescriptors.add(updateApiMethodDescriptor);
        methodDescriptors.add(deleteApiMethodDescriptor);
        methodDescriptors.add(listApiConfigsMethodDescriptor);
        methodDescriptors.add(getApiConfigMethodDescriptor);
        methodDescriptors.add(createApiConfigMethodDescriptor);
        methodDescriptors.add(updateApiConfigMethodDescriptor);
        methodDescriptors.add(deleteApiConfigMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> listGatewaysCallable() {
        return this.listGatewaysCallable;
    }

    @Override
    public UnaryCallable<ListGatewaysRequest, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysPagedCallable() {
        return this.listGatewaysPagedCallable;
    }

    @Override
    public UnaryCallable<GetGatewayRequest, Gateway> getGatewayCallable() {
        return this.getGatewayCallable;
    }

    @Override
    public UnaryCallable<CreateGatewayRequest, Operation> createGatewayCallable() {
        return this.createGatewayCallable;
    }

    @Override
    public OperationCallable<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationCallable() {
        return this.createGatewayOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateGatewayRequest, Operation> updateGatewayCallable() {
        return this.updateGatewayCallable;
    }

    @Override
    public OperationCallable<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationCallable() {
        return this.updateGatewayOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteGatewayRequest, Operation> deleteGatewayCallable() {
        return this.deleteGatewayCallable;
    }

    @Override
    public OperationCallable<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationCallable() {
        return this.deleteGatewayOperationCallable;
    }

    @Override
    public UnaryCallable<ListApisRequest, ListApisResponse> listApisCallable() {
        return this.listApisCallable;
    }

    @Override
    public UnaryCallable<ListApisRequest, ApiGatewayServiceClient.ListApisPagedResponse> listApisPagedCallable() {
        return this.listApisPagedCallable;
    }

    @Override
    public UnaryCallable<GetApiRequest, Api> getApiCallable() {
        return this.getApiCallable;
    }

    @Override
    public UnaryCallable<CreateApiRequest, Operation> createApiCallable() {
        return this.createApiCallable;
    }

    @Override
    public OperationCallable<CreateApiRequest, Api, OperationMetadata> createApiOperationCallable() {
        return this.createApiOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateApiRequest, Operation> updateApiCallable() {
        return this.updateApiCallable;
    }

    @Override
    public OperationCallable<UpdateApiRequest, Api, OperationMetadata> updateApiOperationCallable() {
        return this.updateApiOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteApiRequest, Operation> deleteApiCallable() {
        return this.deleteApiCallable;
    }

    @Override
    public OperationCallable<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationCallable() {
        return this.deleteApiOperationCallable;
    }

    @Override
    public UnaryCallable<ListApiConfigsRequest, ListApiConfigsResponse> listApiConfigsCallable() {
        return this.listApiConfigsCallable;
    }

    @Override
    public UnaryCallable<ListApiConfigsRequest, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsPagedCallable() {
        return this.listApiConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetApiConfigRequest, ApiConfig> getApiConfigCallable() {
        return this.getApiConfigCallable;
    }

    @Override
    public UnaryCallable<CreateApiConfigRequest, Operation> createApiConfigCallable() {
        return this.createApiConfigCallable;
    }

    @Override
    public OperationCallable<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationCallable() {
        return this.createApiConfigOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateApiConfigRequest, Operation> updateApiConfigCallable() {
        return this.updateApiConfigCallable;
    }

    @Override
    public OperationCallable<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationCallable() {
        return this.updateApiConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteApiConfigRequest, Operation> deleteApiConfigCallable() {
        return this.deleteApiConfigCallable;
    }

    @Override
    public OperationCallable<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationCallable() {
        return this.deleteApiConfigOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

