/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateMemoryOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteMemoryOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.GenerateMemoriesOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest;
import com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse;
import com.google.cloud.aiplatform.v1beta1.GetMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.ListMemoriesRequest;
import com.google.cloud.aiplatform.v1beta1.ListMemoriesResponse;
import com.google.cloud.aiplatform.v1beta1.Memory;
import com.google.cloud.aiplatform.v1beta1.MemoryBankServiceClient;
import com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest;
import com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateMemoryOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateMemoryRequest;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcMemoryBankServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.MemoryBankServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class MemoryBankServiceStubSettings
extends StubSettings<MemoryBankServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateMemoryRequest, Operation> createMemorySettings;
    private final OperationCallSettings<CreateMemoryRequest, Memory, CreateMemoryOperationMetadata> createMemoryOperationSettings;
    private final UnaryCallSettings<GetMemoryRequest, Memory> getMemorySettings;
    private final UnaryCallSettings<UpdateMemoryRequest, Operation> updateMemorySettings;
    private final OperationCallSettings<UpdateMemoryRequest, Memory, UpdateMemoryOperationMetadata> updateMemoryOperationSettings;
    private final PagedCallSettings<ListMemoriesRequest, ListMemoriesResponse, MemoryBankServiceClient.ListMemoriesPagedResponse> listMemoriesSettings;
    private final UnaryCallSettings<DeleteMemoryRequest, Operation> deleteMemorySettings;
    private final OperationCallSettings<DeleteMemoryRequest, Empty, DeleteMemoryOperationMetadata> deleteMemoryOperationSettings;
    private final UnaryCallSettings<GenerateMemoriesRequest, Operation> generateMemoriesSettings;
    private final OperationCallSettings<GenerateMemoriesRequest, GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesOperationSettings;
    private final UnaryCallSettings<RetrieveMemoriesRequest, RetrieveMemoriesResponse> retrieveMemoriesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, MemoryBankServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListMemoriesRequest, ListMemoriesResponse, Memory> LIST_MEMORIES_PAGE_STR_DESC = new PagedListDescriptor<ListMemoriesRequest, ListMemoriesResponse, Memory>(){

        public String emptyToken() {
            return "";
        }

        public ListMemoriesRequest injectToken(ListMemoriesRequest payload, String token) {
            return ListMemoriesRequest.newBuilder((ListMemoriesRequest)payload).setPageToken(token).build();
        }

        public ListMemoriesRequest injectPageSize(ListMemoriesRequest payload, int pageSize) {
            return ListMemoriesRequest.newBuilder((ListMemoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMemoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMemoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Memory> extractResources(ListMemoriesResponse payload) {
            return payload.getMemoriesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListMemoriesRequest, ListMemoriesResponse, MemoryBankServiceClient.ListMemoriesPagedResponse> LIST_MEMORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListMemoriesRequest, ListMemoriesResponse, MemoryBankServiceClient.ListMemoriesPagedResponse>(){

        public ApiFuture<MemoryBankServiceClient.ListMemoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMemoriesRequest, ListMemoriesResponse> callable, ListMemoriesRequest request, ApiCallContext context, ApiFuture<ListMemoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MEMORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MemoryBankServiceClient.ListMemoriesPagedResponse.createAsync((PageContext<ListMemoriesRequest, ListMemoriesResponse, Memory>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, MemoryBankServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, MemoryBankServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<MemoryBankServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MemoryBankServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateMemoryRequest, Operation> createMemorySettings() {
        return this.createMemorySettings;
    }

    public OperationCallSettings<CreateMemoryRequest, Memory, CreateMemoryOperationMetadata> createMemoryOperationSettings() {
        return this.createMemoryOperationSettings;
    }

    public UnaryCallSettings<GetMemoryRequest, Memory> getMemorySettings() {
        return this.getMemorySettings;
    }

    public UnaryCallSettings<UpdateMemoryRequest, Operation> updateMemorySettings() {
        return this.updateMemorySettings;
    }

    public OperationCallSettings<UpdateMemoryRequest, Memory, UpdateMemoryOperationMetadata> updateMemoryOperationSettings() {
        return this.updateMemoryOperationSettings;
    }

    public PagedCallSettings<ListMemoriesRequest, ListMemoriesResponse, MemoryBankServiceClient.ListMemoriesPagedResponse> listMemoriesSettings() {
        return this.listMemoriesSettings;
    }

    public UnaryCallSettings<DeleteMemoryRequest, Operation> deleteMemorySettings() {
        return this.deleteMemorySettings;
    }

    public OperationCallSettings<DeleteMemoryRequest, Empty, DeleteMemoryOperationMetadata> deleteMemoryOperationSettings() {
        return this.deleteMemoryOperationSettings;
    }

    public UnaryCallSettings<GenerateMemoriesRequest, Operation> generateMemoriesSettings() {
        return this.generateMemoriesSettings;
    }

    public OperationCallSettings<GenerateMemoriesRequest, GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesOperationSettings() {
        return this.generateMemoriesOperationSettings;
    }

    public UnaryCallSettings<RetrieveMemoriesRequest, RetrieveMemoriesResponse> retrieveMemoriesSettings() {
        return this.retrieveMemoriesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, MemoryBankServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public MemoryBankServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMemoryBankServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MemoryBankServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MemoryBankServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MemoryBankServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createMemorySettings = settingsBuilder.createMemorySettings().build();
        this.createMemoryOperationSettings = settingsBuilder.createMemoryOperationSettings().build();
        this.getMemorySettings = settingsBuilder.getMemorySettings().build();
        this.updateMemorySettings = settingsBuilder.updateMemorySettings().build();
        this.updateMemoryOperationSettings = settingsBuilder.updateMemoryOperationSettings().build();
        this.listMemoriesSettings = settingsBuilder.listMemoriesSettings().build();
        this.deleteMemorySettings = settingsBuilder.deleteMemorySettings().build();
        this.deleteMemoryOperationSettings = settingsBuilder.deleteMemoryOperationSettings().build();
        this.generateMemoriesSettings = settingsBuilder.generateMemoriesSettings().build();
        this.generateMemoriesOperationSettings = settingsBuilder.generateMemoriesOperationSettings().build();
        this.retrieveMemoriesSettings = settingsBuilder.retrieveMemoriesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MemoryBankServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateMemoryRequest, Operation> createMemorySettings;
        private final OperationCallSettings.Builder<CreateMemoryRequest, Memory, CreateMemoryOperationMetadata> createMemoryOperationSettings;
        private final UnaryCallSettings.Builder<GetMemoryRequest, Memory> getMemorySettings;
        private final UnaryCallSettings.Builder<UpdateMemoryRequest, Operation> updateMemorySettings;
        private final OperationCallSettings.Builder<UpdateMemoryRequest, Memory, UpdateMemoryOperationMetadata> updateMemoryOperationSettings;
        private final PagedCallSettings.Builder<ListMemoriesRequest, ListMemoriesResponse, MemoryBankServiceClient.ListMemoriesPagedResponse> listMemoriesSettings;
        private final UnaryCallSettings.Builder<DeleteMemoryRequest, Operation> deleteMemorySettings;
        private final OperationCallSettings.Builder<DeleteMemoryRequest, Empty, DeleteMemoryOperationMetadata> deleteMemoryOperationSettings;
        private final UnaryCallSettings.Builder<GenerateMemoriesRequest, Operation> generateMemoriesSettings;
        private final OperationCallSettings.Builder<GenerateMemoriesRequest, GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesOperationSettings;
        private final UnaryCallSettings.Builder<RetrieveMemoriesRequest, RetrieveMemoriesResponse> retrieveMemoriesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, MemoryBankServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createMemorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMemoryOperationSettings = OperationCallSettings.newBuilder();
            this.getMemorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMemorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMemoryOperationSettings = OperationCallSettings.newBuilder();
            this.listMemoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MEMORIES_PAGE_STR_FACT);
            this.deleteMemorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMemoryOperationSettings = OperationCallSettings.newBuilder();
            this.generateMemoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateMemoriesOperationSettings = OperationCallSettings.newBuilder();
            this.retrieveMemoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMemorySettings, this.getMemorySettings, this.updateMemorySettings, this.listMemoriesSettings, this.deleteMemorySettings, this.generateMemoriesSettings, this.retrieveMemoriesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(MemoryBankServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createMemorySettings = settings.createMemorySettings.toBuilder();
            this.createMemoryOperationSettings = settings.createMemoryOperationSettings.toBuilder();
            this.getMemorySettings = settings.getMemorySettings.toBuilder();
            this.updateMemorySettings = settings.updateMemorySettings.toBuilder();
            this.updateMemoryOperationSettings = settings.updateMemoryOperationSettings.toBuilder();
            this.listMemoriesSettings = settings.listMemoriesSettings.toBuilder();
            this.deleteMemorySettings = settings.deleteMemorySettings.toBuilder();
            this.deleteMemoryOperationSettings = settings.deleteMemoryOperationSettings.toBuilder();
            this.generateMemoriesSettings = settings.generateMemoriesSettings.toBuilder();
            this.generateMemoriesOperationSettings = settings.generateMemoriesOperationSettings.toBuilder();
            this.retrieveMemoriesSettings = settings.retrieveMemoriesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createMemorySettings, this.getMemorySettings, this.updateMemorySettings, this.listMemoriesSettings, this.deleteMemorySettings, this.generateMemoriesSettings, this.retrieveMemoriesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MemoryBankServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MemoryBankServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MemoryBankServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MemoryBankServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createMemorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getMemorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateMemorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listMemoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteMemorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.generateMemoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.retrieveMemoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createMemoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Memory.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateMemoryOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateMemoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Memory.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateMemoryOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteMemoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteMemoryOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.generateMemoriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GenerateMemoriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(GenerateMemoriesOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateMemoryRequest, Operation> createMemorySettings() {
            return this.createMemorySettings;
        }

        public OperationCallSettings.Builder<CreateMemoryRequest, Memory, CreateMemoryOperationMetadata> createMemoryOperationSettings() {
            return this.createMemoryOperationSettings;
        }

        public UnaryCallSettings.Builder<GetMemoryRequest, Memory> getMemorySettings() {
            return this.getMemorySettings;
        }

        public UnaryCallSettings.Builder<UpdateMemoryRequest, Operation> updateMemorySettings() {
            return this.updateMemorySettings;
        }

        public OperationCallSettings.Builder<UpdateMemoryRequest, Memory, UpdateMemoryOperationMetadata> updateMemoryOperationSettings() {
            return this.updateMemoryOperationSettings;
        }

        public PagedCallSettings.Builder<ListMemoriesRequest, ListMemoriesResponse, MemoryBankServiceClient.ListMemoriesPagedResponse> listMemoriesSettings() {
            return this.listMemoriesSettings;
        }

        public UnaryCallSettings.Builder<DeleteMemoryRequest, Operation> deleteMemorySettings() {
            return this.deleteMemorySettings;
        }

        public OperationCallSettings.Builder<DeleteMemoryRequest, Empty, DeleteMemoryOperationMetadata> deleteMemoryOperationSettings() {
            return this.deleteMemoryOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateMemoriesRequest, Operation> generateMemoriesSettings() {
            return this.generateMemoriesSettings;
        }

        public OperationCallSettings.Builder<GenerateMemoriesRequest, GenerateMemoriesResponse, GenerateMemoriesOperationMetadata> generateMemoriesOperationSettings() {
            return this.generateMemoriesOperationSettings;
        }

        public UnaryCallSettings.Builder<RetrieveMemoriesRequest, RetrieveMemoriesResponse> retrieveMemoriesSettings() {
            return this.retrieveMemoriesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, MemoryBankServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public MemoryBankServiceStubSettings build() throws IOException {
            return new MemoryBankServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

