/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.aiplatform.v1beta1.stub;

import static com.google.cloud.aiplatform.v1beta1.ModelGardenServiceClient.ListLocationsPagedResponse;
import static com.google.cloud.aiplatform.v1beta1.ModelGardenServiceClient.ListPublisherModelsPagedResponse;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.AcceptPublisherModelEulaRequest;
import com.google.cloud.aiplatform.v1beta1.CheckPublisherModelEulaAcceptanceRequest;
import com.google.cloud.aiplatform.v1beta1.DeployOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployPublisherModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest;
import com.google.cloud.aiplatform.v1beta1.DeployPublisherModelResponse;
import com.google.cloud.aiplatform.v1beta1.DeployRequest;
import com.google.cloud.aiplatform.v1beta1.DeployResponse;
import com.google.cloud.aiplatform.v1beta1.ExportPublisherModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportPublisherModelRequest;
import com.google.cloud.aiplatform.v1beta1.ExportPublisherModelResponse;
import com.google.cloud.aiplatform.v1beta1.GetPublisherModelRequest;
import com.google.cloud.aiplatform.v1beta1.ListPublisherModelsRequest;
import com.google.cloud.aiplatform.v1beta1.ListPublisherModelsResponse;
import com.google.cloud.aiplatform.v1beta1.PublisherModel;
import com.google.cloud.aiplatform.v1beta1.PublisherModelEulaAcceptance;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * gRPC stub implementation for the ModelGardenService service API.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@BetaApi
@Generated("by gapic-generator-java")
public class GrpcModelGardenServiceStub extends ModelGardenServiceStub {
  private static final MethodDescriptor<GetPublisherModelRequest, PublisherModel>
      getPublisherModelMethodDescriptor =
          MethodDescriptor.<GetPublisherModelRequest, PublisherModel>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(
                  "google.cloud.aiplatform.v1beta1.ModelGardenService/GetPublisherModel")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(GetPublisherModelRequest.getDefaultInstance()))
              .setResponseMarshaller(ProtoUtils.marshaller(PublisherModel.getDefaultInstance()))
              .build();

  private static final MethodDescriptor<ListPublisherModelsRequest, ListPublisherModelsResponse>
      listPublisherModelsMethodDescriptor =
          MethodDescriptor.<ListPublisherModelsRequest, ListPublisherModelsResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(
                  "google.cloud.aiplatform.v1beta1.ModelGardenService/ListPublisherModels")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(ListPublisherModelsRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(ListPublisherModelsResponse.getDefaultInstance()))
              .build();

  private static final MethodDescriptor<DeployRequest, Operation> deployMethodDescriptor =
      MethodDescriptor.<DeployRequest, Operation>newBuilder()
          .setType(MethodDescriptor.MethodType.UNARY)
          .setFullMethodName("google.cloud.aiplatform.v1beta1.ModelGardenService/Deploy")
          .setRequestMarshaller(ProtoUtils.marshaller(DeployRequest.getDefaultInstance()))
          .setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance()))
          .build();

  private static final MethodDescriptor<DeployPublisherModelRequest, Operation>
      deployPublisherModelMethodDescriptor =
          MethodDescriptor.<DeployPublisherModelRequest, Operation>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(
                  "google.cloud.aiplatform.v1beta1.ModelGardenService/DeployPublisherModel")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(DeployPublisherModelRequest.getDefaultInstance()))
              .setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance()))
              .build();

  private static final MethodDescriptor<ExportPublisherModelRequest, Operation>
      exportPublisherModelMethodDescriptor =
          MethodDescriptor.<ExportPublisherModelRequest, Operation>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(
                  "google.cloud.aiplatform.v1beta1.ModelGardenService/ExportPublisherModel")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(ExportPublisherModelRequest.getDefaultInstance()))
              .setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance()))
              .build();

  private static final MethodDescriptor<
          CheckPublisherModelEulaAcceptanceRequest, PublisherModelEulaAcceptance>
      checkPublisherModelEulaAcceptanceMethodDescriptor =
          MethodDescriptor
              .<CheckPublisherModelEulaAcceptanceRequest, PublisherModelEulaAcceptance>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(
                  "google.cloud.aiplatform.v1beta1.ModelGardenService/CheckPublisherModelEulaAcceptance")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(
                      CheckPublisherModelEulaAcceptanceRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(PublisherModelEulaAcceptance.getDefaultInstance()))
              .build();

  private static final MethodDescriptor<
          AcceptPublisherModelEulaRequest, PublisherModelEulaAcceptance>
      acceptPublisherModelEulaMethodDescriptor =
          MethodDescriptor
              .<AcceptPublisherModelEulaRequest, PublisherModelEulaAcceptance>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(
                  "google.cloud.aiplatform.v1beta1.ModelGardenService/AcceptPublisherModelEula")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(AcceptPublisherModelEulaRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(PublisherModelEulaAcceptance.getDefaultInstance()))
              .build();

  private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse>
      listLocationsMethodDescriptor =
          MethodDescriptor.<ListLocationsRequest, ListLocationsResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName("google.cloud.location.Locations/ListLocations")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(ListLocationsRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(ListLocationsResponse.getDefaultInstance()))
              .build();

  private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor =
      MethodDescriptor.<GetLocationRequest, Location>newBuilder()
          .setType(MethodDescriptor.MethodType.UNARY)
          .setFullMethodName("google.cloud.location.Locations/GetLocation")
          .setRequestMarshaller(ProtoUtils.marshaller(GetLocationRequest.getDefaultInstance()))
          .setResponseMarshaller(ProtoUtils.marshaller(Location.getDefaultInstance()))
          .build();

  private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor =
      MethodDescriptor.<SetIamPolicyRequest, Policy>newBuilder()
          .setType(MethodDescriptor.MethodType.UNARY)
          .setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy")
          .setRequestMarshaller(ProtoUtils.marshaller(SetIamPolicyRequest.getDefaultInstance()))
          .setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance()))
          .build();

  private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor =
      MethodDescriptor.<GetIamPolicyRequest, Policy>newBuilder()
          .setType(MethodDescriptor.MethodType.UNARY)
          .setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy")
          .setRequestMarshaller(ProtoUtils.marshaller(GetIamPolicyRequest.getDefaultInstance()))
          .setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance()))
          .build();

  private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse>
      testIamPermissionsMethodDescriptor =
          MethodDescriptor.<TestIamPermissionsRequest, TestIamPermissionsResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(TestIamPermissionsRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(TestIamPermissionsResponse.getDefaultInstance()))
              .build();

  private final UnaryCallable<GetPublisherModelRequest, PublisherModel> getPublisherModelCallable;
  private final UnaryCallable<ListPublisherModelsRequest, ListPublisherModelsResponse>
      listPublisherModelsCallable;
  private final UnaryCallable<ListPublisherModelsRequest, ListPublisherModelsPagedResponse>
      listPublisherModelsPagedCallable;
  private final UnaryCallable<DeployRequest, Operation> deployCallable;
  private final OperationCallable<DeployRequest, DeployResponse, DeployOperationMetadata>
      deployOperationCallable;
  private final UnaryCallable<DeployPublisherModelRequest, Operation> deployPublisherModelCallable;
  private final OperationCallable<
          DeployPublisherModelRequest,
          DeployPublisherModelResponse,
          DeployPublisherModelOperationMetadata>
      deployPublisherModelOperationCallable;
  private final UnaryCallable<ExportPublisherModelRequest, Operation> exportPublisherModelCallable;
  private final OperationCallable<
          ExportPublisherModelRequest,
          ExportPublisherModelResponse,
          ExportPublisherModelOperationMetadata>
      exportPublisherModelOperationCallable;
  private final UnaryCallable<
          CheckPublisherModelEulaAcceptanceRequest, PublisherModelEulaAcceptance>
      checkPublisherModelEulaAcceptanceCallable;
  private final UnaryCallable<AcceptPublisherModelEulaRequest, PublisherModelEulaAcceptance>
      acceptPublisherModelEulaCallable;
  private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
  private final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse>
      listLocationsPagedCallable;
  private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
  private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
  private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
  private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse>
      testIamPermissionsCallable;

  private final BackgroundResource backgroundResources;
  private final GrpcOperationsStub operationsStub;
  private final GrpcStubCallableFactory callableFactory;

  public static final GrpcModelGardenServiceStub create(ModelGardenServiceStubSettings settings)
      throws IOException {
    return new GrpcModelGardenServiceStub(settings, ClientContext.create(settings));
  }

  public static final GrpcModelGardenServiceStub create(ClientContext clientContext)
      throws IOException {
    return new GrpcModelGardenServiceStub(
        ModelGardenServiceStubSettings.newBuilder().build(), clientContext);
  }

  public static final GrpcModelGardenServiceStub create(
      ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
    return new GrpcModelGardenServiceStub(
        ModelGardenServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
  }

  /**
   * Constructs an instance of GrpcModelGardenServiceStub, using the given settings. This is
   * protected so that it is easy to make a subclass, but otherwise, the static factory methods
   * should be preferred.
   */
  protected GrpcModelGardenServiceStub(
      ModelGardenServiceStubSettings settings, ClientContext clientContext) throws IOException {
    this(settings, clientContext, new GrpcModelGardenServiceCallableFactory());
  }

  /**
   * Constructs an instance of GrpcModelGardenServiceStub, using the given settings. This is
   * protected so that it is easy to make a subclass, but otherwise, the static factory methods
   * should be preferred.
   */
  protected GrpcModelGardenServiceStub(
      ModelGardenServiceStubSettings settings,
      ClientContext clientContext,
      GrpcStubCallableFactory callableFactory)
      throws IOException {
    this.callableFactory = callableFactory;
    this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);

    GrpcCallSettings<GetPublisherModelRequest, PublisherModel> getPublisherModelTransportSettings =
        GrpcCallSettings.<GetPublisherModelRequest, PublisherModel>newBuilder()
            .setMethodDescriptor(getPublisherModelMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("name", String.valueOf(request.getName()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<ListPublisherModelsRequest, ListPublisherModelsResponse>
        listPublisherModelsTransportSettings =
            GrpcCallSettings.<ListPublisherModelsRequest, ListPublisherModelsResponse>newBuilder()
                .setMethodDescriptor(listPublisherModelsMethodDescriptor)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("parent", String.valueOf(request.getParent()));
                      return builder.build();
                    })
                .build();
    GrpcCallSettings<DeployRequest, Operation> deployTransportSettings =
        GrpcCallSettings.<DeployRequest, Operation>newBuilder()
            .setMethodDescriptor(deployMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("destination", String.valueOf(request.getDestination()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<DeployPublisherModelRequest, Operation> deployPublisherModelTransportSettings =
        GrpcCallSettings.<DeployPublisherModelRequest, Operation>newBuilder()
            .setMethodDescriptor(deployPublisherModelMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("destination", String.valueOf(request.getDestination()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<ExportPublisherModelRequest, Operation> exportPublisherModelTransportSettings =
        GrpcCallSettings.<ExportPublisherModelRequest, Operation>newBuilder()
            .setMethodDescriptor(exportPublisherModelMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("name", String.valueOf(request.getName()));
                  builder.add("parent", String.valueOf(request.getParent()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<CheckPublisherModelEulaAcceptanceRequest, PublisherModelEulaAcceptance>
        checkPublisherModelEulaAcceptanceTransportSettings =
            GrpcCallSettings
                .<CheckPublisherModelEulaAcceptanceRequest, PublisherModelEulaAcceptance>
                    newBuilder()
                .setMethodDescriptor(checkPublisherModelEulaAcceptanceMethodDescriptor)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("parent", String.valueOf(request.getParent()));
                      return builder.build();
                    })
                .build();
    GrpcCallSettings<AcceptPublisherModelEulaRequest, PublisherModelEulaAcceptance>
        acceptPublisherModelEulaTransportSettings =
            GrpcCallSettings
                .<AcceptPublisherModelEulaRequest, PublisherModelEulaAcceptance>newBuilder()
                .setMethodDescriptor(acceptPublisherModelEulaMethodDescriptor)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("parent", String.valueOf(request.getParent()));
                      return builder.build();
                    })
                .build();
    GrpcCallSettings<ListLocationsRequest, ListLocationsResponse> listLocationsTransportSettings =
        GrpcCallSettings.<ListLocationsRequest, ListLocationsResponse>newBuilder()
            .setMethodDescriptor(listLocationsMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("name", String.valueOf(request.getName()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<GetLocationRequest, Location> getLocationTransportSettings =
        GrpcCallSettings.<GetLocationRequest, Location>newBuilder()
            .setMethodDescriptor(getLocationMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("name", String.valueOf(request.getName()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<SetIamPolicyRequest, Policy> setIamPolicyTransportSettings =
        GrpcCallSettings.<SetIamPolicyRequest, Policy>newBuilder()
            .setMethodDescriptor(setIamPolicyMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("resource", String.valueOf(request.getResource()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<GetIamPolicyRequest, Policy> getIamPolicyTransportSettings =
        GrpcCallSettings.<GetIamPolicyRequest, Policy>newBuilder()
            .setMethodDescriptor(getIamPolicyMethodDescriptor)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("resource", String.valueOf(request.getResource()));
                  return builder.build();
                })
            .build();
    GrpcCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse>
        testIamPermissionsTransportSettings =
            GrpcCallSettings.<TestIamPermissionsRequest, TestIamPermissionsResponse>newBuilder()
                .setMethodDescriptor(testIamPermissionsMethodDescriptor)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("resource", String.valueOf(request.getResource()));
                      return builder.build();
                    })
                .build();

    this.getPublisherModelCallable =
        callableFactory.createUnaryCallable(
            getPublisherModelTransportSettings,
            settings.getPublisherModelSettings(),
            clientContext);
    this.listPublisherModelsCallable =
        callableFactory.createUnaryCallable(
            listPublisherModelsTransportSettings,
            settings.listPublisherModelsSettings(),
            clientContext);
    this.listPublisherModelsPagedCallable =
        callableFactory.createPagedCallable(
            listPublisherModelsTransportSettings,
            settings.listPublisherModelsSettings(),
            clientContext);
    this.deployCallable =
        callableFactory.createUnaryCallable(
            deployTransportSettings, settings.deploySettings(), clientContext);
    this.deployOperationCallable =
        callableFactory.createOperationCallable(
            deployTransportSettings,
            settings.deployOperationSettings(),
            clientContext,
            operationsStub);
    this.deployPublisherModelCallable =
        callableFactory.createUnaryCallable(
            deployPublisherModelTransportSettings,
            settings.deployPublisherModelSettings(),
            clientContext);
    this.deployPublisherModelOperationCallable =
        callableFactory.createOperationCallable(
            deployPublisherModelTransportSettings,
            settings.deployPublisherModelOperationSettings(),
            clientContext,
            operationsStub);
    this.exportPublisherModelCallable =
        callableFactory.createUnaryCallable(
            exportPublisherModelTransportSettings,
            settings.exportPublisherModelSettings(),
            clientContext);
    this.exportPublisherModelOperationCallable =
        callableFactory.createOperationCallable(
            exportPublisherModelTransportSettings,
            settings.exportPublisherModelOperationSettings(),
            clientContext,
            operationsStub);
    this.checkPublisherModelEulaAcceptanceCallable =
        callableFactory.createUnaryCallable(
            checkPublisherModelEulaAcceptanceTransportSettings,
            settings.checkPublisherModelEulaAcceptanceSettings(),
            clientContext);
    this.acceptPublisherModelEulaCallable =
        callableFactory.createUnaryCallable(
            acceptPublisherModelEulaTransportSettings,
            settings.acceptPublisherModelEulaSettings(),
            clientContext);
    this.listLocationsCallable =
        callableFactory.createUnaryCallable(
            listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
    this.listLocationsPagedCallable =
        callableFactory.createPagedCallable(
            listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
    this.getLocationCallable =
        callableFactory.createUnaryCallable(
            getLocationTransportSettings, settings.getLocationSettings(), clientContext);
    this.setIamPolicyCallable =
        callableFactory.createUnaryCallable(
            setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
    this.getIamPolicyCallable =
        callableFactory.createUnaryCallable(
            getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
    this.testIamPermissionsCallable =
        callableFactory.createUnaryCallable(
            testIamPermissionsTransportSettings,
            settings.testIamPermissionsSettings(),
            clientContext);

    this.backgroundResources =
        new BackgroundResourceAggregation(clientContext.getBackgroundResources());
  }

  public GrpcOperationsStub getOperationsStub() {
    return operationsStub;
  }

  @Override
  public UnaryCallable<GetPublisherModelRequest, PublisherModel> getPublisherModelCallable() {
    return getPublisherModelCallable;
  }

  @Override
  public UnaryCallable<ListPublisherModelsRequest, ListPublisherModelsResponse>
      listPublisherModelsCallable() {
    return listPublisherModelsCallable;
  }

  @Override
  public UnaryCallable<ListPublisherModelsRequest, ListPublisherModelsPagedResponse>
      listPublisherModelsPagedCallable() {
    return listPublisherModelsPagedCallable;
  }

  @Override
  public UnaryCallable<DeployRequest, Operation> deployCallable() {
    return deployCallable;
  }

  @Override
  public OperationCallable<DeployRequest, DeployResponse, DeployOperationMetadata>
      deployOperationCallable() {
    return deployOperationCallable;
  }

  @Override
  public UnaryCallable<DeployPublisherModelRequest, Operation> deployPublisherModelCallable() {
    return deployPublisherModelCallable;
  }

  @Override
  public OperationCallable<
          DeployPublisherModelRequest,
          DeployPublisherModelResponse,
          DeployPublisherModelOperationMetadata>
      deployPublisherModelOperationCallable() {
    return deployPublisherModelOperationCallable;
  }

  @Override
  public UnaryCallable<ExportPublisherModelRequest, Operation> exportPublisherModelCallable() {
    return exportPublisherModelCallable;
  }

  @Override
  public OperationCallable<
          ExportPublisherModelRequest,
          ExportPublisherModelResponse,
          ExportPublisherModelOperationMetadata>
      exportPublisherModelOperationCallable() {
    return exportPublisherModelOperationCallable;
  }

  @Override
  public UnaryCallable<CheckPublisherModelEulaAcceptanceRequest, PublisherModelEulaAcceptance>
      checkPublisherModelEulaAcceptanceCallable() {
    return checkPublisherModelEulaAcceptanceCallable;
  }

  @Override
  public UnaryCallable<AcceptPublisherModelEulaRequest, PublisherModelEulaAcceptance>
      acceptPublisherModelEulaCallable() {
    return acceptPublisherModelEulaCallable;
  }

  @Override
  public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
    return listLocationsCallable;
  }

  @Override
  public UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse>
      listLocationsPagedCallable() {
    return listLocationsPagedCallable;
  }

  @Override
  public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
    return getLocationCallable;
  }

  @Override
  public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
    return setIamPolicyCallable;
  }

  @Override
  public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
    return getIamPolicyCallable;
  }

  @Override
  public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse>
      testIamPermissionsCallable() {
    return testIamPermissionsCallable;
  }

  @Override
  public final void close() {
    try {
      backgroundResources.close();
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw new IllegalStateException("Failed to close resource", e);
    }
  }

  @Override
  public void shutdown() {
    backgroundResources.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return backgroundResources.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return backgroundResources.isTerminated();
  }

  @Override
  public void shutdownNow() {
    backgroundResources.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return backgroundResources.awaitTermination(duration, unit);
  }
}
