/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateScheduleRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeleteScheduleRequest;
import com.google.cloud.aiplatform.v1.GetScheduleRequest;
import com.google.cloud.aiplatform.v1.ListSchedulesRequest;
import com.google.cloud.aiplatform.v1.ListSchedulesResponse;
import com.google.cloud.aiplatform.v1.PauseScheduleRequest;
import com.google.cloud.aiplatform.v1.ResumeScheduleRequest;
import com.google.cloud.aiplatform.v1.Schedule;
import com.google.cloud.aiplatform.v1.ScheduleServiceClient;
import com.google.cloud.aiplatform.v1.UpdateScheduleRequest;
import com.google.cloud.aiplatform.v1.stub.GrpcScheduleServiceStub;
import com.google.cloud.aiplatform.v1.stub.ScheduleServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ScheduleServiceStubSettings
extends StubSettings<ScheduleServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateScheduleRequest, Schedule> createScheduleSettings;
    private final UnaryCallSettings<DeleteScheduleRequest, Operation> deleteScheduleSettings;
    private final OperationCallSettings<DeleteScheduleRequest, Empty, DeleteOperationMetadata> deleteScheduleOperationSettings;
    private final UnaryCallSettings<GetScheduleRequest, Schedule> getScheduleSettings;
    private final PagedCallSettings<ListSchedulesRequest, ListSchedulesResponse, ScheduleServiceClient.ListSchedulesPagedResponse> listSchedulesSettings;
    private final UnaryCallSettings<PauseScheduleRequest, Empty> pauseScheduleSettings;
    private final UnaryCallSettings<ResumeScheduleRequest, Empty> resumeScheduleSettings;
    private final UnaryCallSettings<UpdateScheduleRequest, Schedule> updateScheduleSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ScheduleServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSchedulesRequest, ListSchedulesResponse, Schedule> LIST_SCHEDULES_PAGE_STR_DESC = new PagedListDescriptor<ListSchedulesRequest, ListSchedulesResponse, Schedule>(){

        public String emptyToken() {
            return "";
        }

        public ListSchedulesRequest injectToken(ListSchedulesRequest payload, String token) {
            return ListSchedulesRequest.newBuilder((ListSchedulesRequest)payload).setPageToken(token).build();
        }

        public ListSchedulesRequest injectPageSize(ListSchedulesRequest payload, int pageSize) {
            return ListSchedulesRequest.newBuilder((ListSchedulesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSchedulesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSchedulesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Schedule> extractResources(ListSchedulesResponse payload) {
            return payload.getSchedulesList() == null ? ImmutableList.of() : payload.getSchedulesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListSchedulesRequest, ListSchedulesResponse, ScheduleServiceClient.ListSchedulesPagedResponse> LIST_SCHEDULES_PAGE_STR_FACT = new PagedListResponseFactory<ListSchedulesRequest, ListSchedulesResponse, ScheduleServiceClient.ListSchedulesPagedResponse>(){

        public ApiFuture<ScheduleServiceClient.ListSchedulesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSchedulesRequest, ListSchedulesResponse> callable, ListSchedulesRequest request, ApiCallContext context, ApiFuture<ListSchedulesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SCHEDULES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ScheduleServiceClient.ListSchedulesPagedResponse.createAsync((PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ScheduleServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ScheduleServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<ScheduleServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ScheduleServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateScheduleRequest, Schedule> createScheduleSettings() {
        return this.createScheduleSettings;
    }

    public UnaryCallSettings<DeleteScheduleRequest, Operation> deleteScheduleSettings() {
        return this.deleteScheduleSettings;
    }

    public OperationCallSettings<DeleteScheduleRequest, Empty, DeleteOperationMetadata> deleteScheduleOperationSettings() {
        return this.deleteScheduleOperationSettings;
    }

    public UnaryCallSettings<GetScheduleRequest, Schedule> getScheduleSettings() {
        return this.getScheduleSettings;
    }

    public PagedCallSettings<ListSchedulesRequest, ListSchedulesResponse, ScheduleServiceClient.ListSchedulesPagedResponse> listSchedulesSettings() {
        return this.listSchedulesSettings;
    }

    public UnaryCallSettings<PauseScheduleRequest, Empty> pauseScheduleSettings() {
        return this.pauseScheduleSettings;
    }

    public UnaryCallSettings<ResumeScheduleRequest, Empty> resumeScheduleSettings() {
        return this.resumeScheduleSettings;
    }

    public UnaryCallSettings<UpdateScheduleRequest, Schedule> updateScheduleSettings() {
        return this.updateScheduleSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ScheduleServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ScheduleServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcScheduleServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ScheduleServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ScheduleServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ScheduleServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ScheduleServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createScheduleSettings = settingsBuilder.createScheduleSettings().build();
        this.deleteScheduleSettings = settingsBuilder.deleteScheduleSettings().build();
        this.deleteScheduleOperationSettings = settingsBuilder.deleteScheduleOperationSettings().build();
        this.getScheduleSettings = settingsBuilder.getScheduleSettings().build();
        this.listSchedulesSettings = settingsBuilder.listSchedulesSettings().build();
        this.pauseScheduleSettings = settingsBuilder.pauseScheduleSettings().build();
        this.resumeScheduleSettings = settingsBuilder.resumeScheduleSettings().build();
        this.updateScheduleSettings = settingsBuilder.updateScheduleSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ScheduleServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateScheduleRequest, Schedule> createScheduleSettings;
        private final UnaryCallSettings.Builder<DeleteScheduleRequest, Operation> deleteScheduleSettings;
        private final OperationCallSettings.Builder<DeleteScheduleRequest, Empty, DeleteOperationMetadata> deleteScheduleOperationSettings;
        private final UnaryCallSettings.Builder<GetScheduleRequest, Schedule> getScheduleSettings;
        private final PagedCallSettings.Builder<ListSchedulesRequest, ListSchedulesResponse, ScheduleServiceClient.ListSchedulesPagedResponse> listSchedulesSettings;
        private final UnaryCallSettings.Builder<PauseScheduleRequest, Empty> pauseScheduleSettings;
        private final UnaryCallSettings.Builder<ResumeScheduleRequest, Empty> resumeScheduleSettings;
        private final UnaryCallSettings.Builder<UpdateScheduleRequest, Schedule> updateScheduleSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ScheduleServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createScheduleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteScheduleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteScheduleOperationSettings = OperationCallSettings.newBuilder();
            this.getScheduleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSchedulesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SCHEDULES_PAGE_STR_FACT);
            this.pauseScheduleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeScheduleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateScheduleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createScheduleSettings, this.deleteScheduleSettings, this.getScheduleSettings, this.listSchedulesSettings, this.pauseScheduleSettings, this.resumeScheduleSettings, this.updateScheduleSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(ScheduleServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createScheduleSettings = settings.createScheduleSettings.toBuilder();
            this.deleteScheduleSettings = settings.deleteScheduleSettings.toBuilder();
            this.deleteScheduleOperationSettings = settings.deleteScheduleOperationSettings.toBuilder();
            this.getScheduleSettings = settings.getScheduleSettings.toBuilder();
            this.listSchedulesSettings = settings.listSchedulesSettings.toBuilder();
            this.pauseScheduleSettings = settings.pauseScheduleSettings.toBuilder();
            this.resumeScheduleSettings = settings.resumeScheduleSettings.toBuilder();
            this.updateScheduleSettings = settings.updateScheduleSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createScheduleSettings, this.deleteScheduleSettings, this.getScheduleSettings, this.listSchedulesSettings, this.pauseScheduleSettings, this.resumeScheduleSettings, this.updateScheduleSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ScheduleServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ScheduleServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ScheduleServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ScheduleServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createScheduleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteScheduleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getScheduleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSchedulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.pauseScheduleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.resumeScheduleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateScheduleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteScheduleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateScheduleRequest, Schedule> createScheduleSettings() {
            return this.createScheduleSettings;
        }

        public UnaryCallSettings.Builder<DeleteScheduleRequest, Operation> deleteScheduleSettings() {
            return this.deleteScheduleSettings;
        }

        public OperationCallSettings.Builder<DeleteScheduleRequest, Empty, DeleteOperationMetadata> deleteScheduleOperationSettings() {
            return this.deleteScheduleOperationSettings;
        }

        public UnaryCallSettings.Builder<GetScheduleRequest, Schedule> getScheduleSettings() {
            return this.getScheduleSettings;
        }

        public PagedCallSettings.Builder<ListSchedulesRequest, ListSchedulesResponse, ScheduleServiceClient.ListSchedulesPagedResponse> listSchedulesSettings() {
            return this.listSchedulesSettings;
        }

        public UnaryCallSettings.Builder<PauseScheduleRequest, Empty> pauseScheduleSettings() {
            return this.pauseScheduleSettings;
        }

        public UnaryCallSettings.Builder<ResumeScheduleRequest, Empty> resumeScheduleSettings() {
            return this.resumeScheduleSettings;
        }

        public UnaryCallSettings.Builder<UpdateScheduleRequest, Schedule> updateScheduleSettings() {
            return this.updateScheduleSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ScheduleServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ScheduleServiceStubSettings.getDefaultEndpoint();
        }

        public ScheduleServiceStubSettings build() throws IOException {
            return new ScheduleServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

