/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.AddTrialMeasurementRequest;
import com.google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateMetatdata;
import com.google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateRequest;
import com.google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateResponse;
import com.google.cloud.aiplatform.v1.CompleteTrialRequest;
import com.google.cloud.aiplatform.v1.CreateStudyRequest;
import com.google.cloud.aiplatform.v1.CreateTrialRequest;
import com.google.cloud.aiplatform.v1.DeleteStudyRequest;
import com.google.cloud.aiplatform.v1.DeleteTrialRequest;
import com.google.cloud.aiplatform.v1.GetStudyRequest;
import com.google.cloud.aiplatform.v1.GetTrialRequest;
import com.google.cloud.aiplatform.v1.ListOptimalTrialsRequest;
import com.google.cloud.aiplatform.v1.ListOptimalTrialsResponse;
import com.google.cloud.aiplatform.v1.ListStudiesRequest;
import com.google.cloud.aiplatform.v1.ListStudiesResponse;
import com.google.cloud.aiplatform.v1.ListTrialsRequest;
import com.google.cloud.aiplatform.v1.ListTrialsResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.LookupStudyRequest;
import com.google.cloud.aiplatform.v1.StopTrialRequest;
import com.google.cloud.aiplatform.v1.Study;
import com.google.cloud.aiplatform.v1.StudyName;
import com.google.cloud.aiplatform.v1.SuggestTrialsMetadata;
import com.google.cloud.aiplatform.v1.SuggestTrialsRequest;
import com.google.cloud.aiplatform.v1.SuggestTrialsResponse;
import com.google.cloud.aiplatform.v1.Trial;
import com.google.cloud.aiplatform.v1.TrialName;
import com.google.cloud.aiplatform.v1.VizierServiceSettings;
import com.google.cloud.aiplatform.v1.stub.VizierServiceStub;
import com.google.cloud.aiplatform.v1.stub.VizierServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VizierServiceClient
implements BackgroundResource {
    private final VizierServiceSettings settings;
    private final VizierServiceStub stub;
    private final OperationsClient operationsClient;

    public static final VizierServiceClient create() throws IOException {
        return VizierServiceClient.create(VizierServiceSettings.newBuilder().build());
    }

    public static final VizierServiceClient create(VizierServiceSettings settings) throws IOException {
        return new VizierServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VizierServiceClient create(VizierServiceStub stub) {
        return new VizierServiceClient(stub);
    }

    protected VizierServiceClient(VizierServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VizierServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VizierServiceClient(VizierServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final VizierServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VizierServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Study createStudy(LocationName parent, Study study) {
        CreateStudyRequest request = CreateStudyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setStudy(study).build();
        return this.createStudy(request);
    }

    public final Study createStudy(String parent, Study study) {
        CreateStudyRequest request = CreateStudyRequest.newBuilder().setParent(parent).setStudy(study).build();
        return this.createStudy(request);
    }

    public final Study createStudy(CreateStudyRequest request) {
        return (Study)this.createStudyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateStudyRequest, Study> createStudyCallable() {
        return this.stub.createStudyCallable();
    }

    public final Study getStudy(StudyName name) {
        GetStudyRequest request = GetStudyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStudy(request);
    }

    public final Study getStudy(String name) {
        GetStudyRequest request = GetStudyRequest.newBuilder().setName(name).build();
        return this.getStudy(request);
    }

    public final Study getStudy(GetStudyRequest request) {
        return (Study)this.getStudyCallable().call((Object)request);
    }

    public final UnaryCallable<GetStudyRequest, Study> getStudyCallable() {
        return this.stub.getStudyCallable();
    }

    public final ListStudiesPagedResponse listStudies(LocationName parent) {
        ListStudiesRequest request = ListStudiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStudies(request);
    }

    public final ListStudiesPagedResponse listStudies(String parent) {
        ListStudiesRequest request = ListStudiesRequest.newBuilder().setParent(parent).build();
        return this.listStudies(request);
    }

    public final ListStudiesPagedResponse listStudies(ListStudiesRequest request) {
        return (ListStudiesPagedResponse)((Object)this.listStudiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListStudiesRequest, ListStudiesPagedResponse> listStudiesPagedCallable() {
        return this.stub.listStudiesPagedCallable();
    }

    public final UnaryCallable<ListStudiesRequest, ListStudiesResponse> listStudiesCallable() {
        return this.stub.listStudiesCallable();
    }

    public final void deleteStudy(StudyName name) {
        DeleteStudyRequest request = DeleteStudyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteStudy(request);
    }

    public final void deleteStudy(String name) {
        DeleteStudyRequest request = DeleteStudyRequest.newBuilder().setName(name).build();
        this.deleteStudy(request);
    }

    public final void deleteStudy(DeleteStudyRequest request) {
        this.deleteStudyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteStudyRequest, Empty> deleteStudyCallable() {
        return this.stub.deleteStudyCallable();
    }

    public final Study lookupStudy(LocationName parent) {
        LookupStudyRequest request = LookupStudyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.lookupStudy(request);
    }

    public final Study lookupStudy(String parent) {
        LookupStudyRequest request = LookupStudyRequest.newBuilder().setParent(parent).build();
        return this.lookupStudy(request);
    }

    public final Study lookupStudy(LookupStudyRequest request) {
        return (Study)this.lookupStudyCallable().call((Object)request);
    }

    public final UnaryCallable<LookupStudyRequest, Study> lookupStudyCallable() {
        return this.stub.lookupStudyCallable();
    }

    public final OperationFuture<SuggestTrialsResponse, SuggestTrialsMetadata> suggestTrialsAsync(SuggestTrialsRequest request) {
        return this.suggestTrialsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SuggestTrialsRequest, SuggestTrialsResponse, SuggestTrialsMetadata> suggestTrialsOperationCallable() {
        return this.stub.suggestTrialsOperationCallable();
    }

    public final UnaryCallable<SuggestTrialsRequest, Operation> suggestTrialsCallable() {
        return this.stub.suggestTrialsCallable();
    }

    public final Trial createTrial(StudyName parent, Trial trial) {
        CreateTrialRequest request = CreateTrialRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTrial(trial).build();
        return this.createTrial(request);
    }

    public final Trial createTrial(String parent, Trial trial) {
        CreateTrialRequest request = CreateTrialRequest.newBuilder().setParent(parent).setTrial(trial).build();
        return this.createTrial(request);
    }

    public final Trial createTrial(CreateTrialRequest request) {
        return (Trial)this.createTrialCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTrialRequest, Trial> createTrialCallable() {
        return this.stub.createTrialCallable();
    }

    public final Trial getTrial(TrialName name) {
        GetTrialRequest request = GetTrialRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTrial(request);
    }

    public final Trial getTrial(String name) {
        GetTrialRequest request = GetTrialRequest.newBuilder().setName(name).build();
        return this.getTrial(request);
    }

    public final Trial getTrial(GetTrialRequest request) {
        return (Trial)this.getTrialCallable().call((Object)request);
    }

    public final UnaryCallable<GetTrialRequest, Trial> getTrialCallable() {
        return this.stub.getTrialCallable();
    }

    public final ListTrialsPagedResponse listTrials(StudyName parent) {
        ListTrialsRequest request = ListTrialsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTrials(request);
    }

    public final ListTrialsPagedResponse listTrials(String parent) {
        ListTrialsRequest request = ListTrialsRequest.newBuilder().setParent(parent).build();
        return this.listTrials(request);
    }

    public final ListTrialsPagedResponse listTrials(ListTrialsRequest request) {
        return (ListTrialsPagedResponse)((Object)this.listTrialsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTrialsRequest, ListTrialsPagedResponse> listTrialsPagedCallable() {
        return this.stub.listTrialsPagedCallable();
    }

    public final UnaryCallable<ListTrialsRequest, ListTrialsResponse> listTrialsCallable() {
        return this.stub.listTrialsCallable();
    }

    public final Trial addTrialMeasurement(AddTrialMeasurementRequest request) {
        return (Trial)this.addTrialMeasurementCallable().call((Object)request);
    }

    public final UnaryCallable<AddTrialMeasurementRequest, Trial> addTrialMeasurementCallable() {
        return this.stub.addTrialMeasurementCallable();
    }

    public final Trial completeTrial(CompleteTrialRequest request) {
        return (Trial)this.completeTrialCallable().call((Object)request);
    }

    public final UnaryCallable<CompleteTrialRequest, Trial> completeTrialCallable() {
        return this.stub.completeTrialCallable();
    }

    public final void deleteTrial(TrialName name) {
        DeleteTrialRequest request = DeleteTrialRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTrial(request);
    }

    public final void deleteTrial(String name) {
        DeleteTrialRequest request = DeleteTrialRequest.newBuilder().setName(name).build();
        this.deleteTrial(request);
    }

    public final void deleteTrial(DeleteTrialRequest request) {
        this.deleteTrialCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTrialRequest, Empty> deleteTrialCallable() {
        return this.stub.deleteTrialCallable();
    }

    public final OperationFuture<CheckTrialEarlyStoppingStateResponse, CheckTrialEarlyStoppingStateMetatdata> checkTrialEarlyStoppingStateAsync(CheckTrialEarlyStoppingStateRequest request) {
        return this.checkTrialEarlyStoppingStateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CheckTrialEarlyStoppingStateRequest, CheckTrialEarlyStoppingStateResponse, CheckTrialEarlyStoppingStateMetatdata> checkTrialEarlyStoppingStateOperationCallable() {
        return this.stub.checkTrialEarlyStoppingStateOperationCallable();
    }

    public final UnaryCallable<CheckTrialEarlyStoppingStateRequest, Operation> checkTrialEarlyStoppingStateCallable() {
        return this.stub.checkTrialEarlyStoppingStateCallable();
    }

    public final Trial stopTrial(StopTrialRequest request) {
        return (Trial)this.stopTrialCallable().call((Object)request);
    }

    public final UnaryCallable<StopTrialRequest, Trial> stopTrialCallable() {
        return this.stub.stopTrialCallable();
    }

    public final ListOptimalTrialsResponse listOptimalTrials(StudyName parent) {
        ListOptimalTrialsRequest request = ListOptimalTrialsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOptimalTrials(request);
    }

    public final ListOptimalTrialsResponse listOptimalTrials(String parent) {
        ListOptimalTrialsRequest request = ListOptimalTrialsRequest.newBuilder().setParent(parent).build();
        return this.listOptimalTrials(request);
    }

    public final ListOptimalTrialsResponse listOptimalTrials(ListOptimalTrialsRequest request) {
        return (ListOptimalTrialsResponse)this.listOptimalTrialsCallable().call((Object)request);
    }

    public final UnaryCallable<ListOptimalTrialsRequest, ListOptimalTrialsResponse> listOptimalTrialsCallable() {
        return this.stub.listOptimalTrialsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTrialsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTrialsRequest, ListTrialsResponse, Trial, ListTrialsPage, ListTrialsFixedSizeCollection> {
        private ListTrialsFixedSizeCollection(List<ListTrialsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTrialsFixedSizeCollection createEmptyCollection() {
            return new ListTrialsFixedSizeCollection(null, 0);
        }

        protected ListTrialsFixedSizeCollection createCollection(List<ListTrialsPage> pages, int collectionSize) {
            return new ListTrialsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTrialsPage
    extends AbstractPage<ListTrialsRequest, ListTrialsResponse, Trial, ListTrialsPage> {
        private ListTrialsPage(PageContext<ListTrialsRequest, ListTrialsResponse, Trial> context, ListTrialsResponse response) {
            super(context, (Object)response);
        }

        private static ListTrialsPage createEmptyPage() {
            return new ListTrialsPage(null, null);
        }

        protected ListTrialsPage createPage(PageContext<ListTrialsRequest, ListTrialsResponse, Trial> context, ListTrialsResponse response) {
            return new ListTrialsPage(context, response);
        }

        public ApiFuture<ListTrialsPage> createPageAsync(PageContext<ListTrialsRequest, ListTrialsResponse, Trial> context, ApiFuture<ListTrialsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTrialsPagedResponse
    extends AbstractPagedListResponse<ListTrialsRequest, ListTrialsResponse, Trial, ListTrialsPage, ListTrialsFixedSizeCollection> {
        public static ApiFuture<ListTrialsPagedResponse> createAsync(PageContext<ListTrialsRequest, ListTrialsResponse, Trial> context, ApiFuture<ListTrialsResponse> futureResponse) {
            ApiFuture<ListTrialsPage> futurePage = ListTrialsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTrialsPagedResponse((ListTrialsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTrialsPagedResponse(ListTrialsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTrialsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListStudiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListStudiesRequest, ListStudiesResponse, Study, ListStudiesPage, ListStudiesFixedSizeCollection> {
        private ListStudiesFixedSizeCollection(List<ListStudiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListStudiesFixedSizeCollection createEmptyCollection() {
            return new ListStudiesFixedSizeCollection(null, 0);
        }

        protected ListStudiesFixedSizeCollection createCollection(List<ListStudiesPage> pages, int collectionSize) {
            return new ListStudiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListStudiesPage
    extends AbstractPage<ListStudiesRequest, ListStudiesResponse, Study, ListStudiesPage> {
        private ListStudiesPage(PageContext<ListStudiesRequest, ListStudiesResponse, Study> context, ListStudiesResponse response) {
            super(context, (Object)response);
        }

        private static ListStudiesPage createEmptyPage() {
            return new ListStudiesPage(null, null);
        }

        protected ListStudiesPage createPage(PageContext<ListStudiesRequest, ListStudiesResponse, Study> context, ListStudiesResponse response) {
            return new ListStudiesPage(context, response);
        }

        public ApiFuture<ListStudiesPage> createPageAsync(PageContext<ListStudiesRequest, ListStudiesResponse, Study> context, ApiFuture<ListStudiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListStudiesPagedResponse
    extends AbstractPagedListResponse<ListStudiesRequest, ListStudiesResponse, Study, ListStudiesPage, ListStudiesFixedSizeCollection> {
        public static ApiFuture<ListStudiesPagedResponse> createAsync(PageContext<ListStudiesRequest, ListStudiesResponse, Study> context, ApiFuture<ListStudiesResponse> futureResponse) {
            ApiFuture<ListStudiesPage> futurePage = ListStudiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListStudiesPagedResponse((ListStudiesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListStudiesPagedResponse(ListStudiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListStudiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

