/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateSpecialistPoolOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.GetSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.ListSpecialistPoolsRequest;
import com.google.cloud.aiplatform.v1beta1.ListSpecialistPoolsResponse;
import com.google.cloud.aiplatform.v1beta1.SpecialistPool;
import com.google.cloud.aiplatform.v1beta1.SpecialistPoolServiceClient;
import com.google.cloud.aiplatform.v1beta1.UpdateSpecialistPoolOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateSpecialistPoolRequest;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcSpecialistPoolServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.SpecialistPoolServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SpecialistPoolServiceStubSettings
extends StubSettings<SpecialistPoolServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateSpecialistPoolRequest, Operation> createSpecialistPoolSettings;
    private final OperationCallSettings<CreateSpecialistPoolRequest, SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolOperationSettings;
    private final UnaryCallSettings<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolSettings;
    private final PagedCallSettings<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> listSpecialistPoolsSettings;
    private final UnaryCallSettings<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolSettings;
    private final OperationCallSettings<DeleteSpecialistPoolRequest, Empty, DeleteOperationMetadata> deleteSpecialistPoolOperationSettings;
    private final UnaryCallSettings<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolSettings;
    private final OperationCallSettings<UpdateSpecialistPoolRequest, SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolOperationSettings;
    private static final PagedListDescriptor<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool> LIST_SPECIALIST_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool>(){

        public String emptyToken() {
            return "";
        }

        public ListSpecialistPoolsRequest injectToken(ListSpecialistPoolsRequest payload, String token) {
            return ListSpecialistPoolsRequest.newBuilder((ListSpecialistPoolsRequest)payload).setPageToken(token).build();
        }

        public ListSpecialistPoolsRequest injectPageSize(ListSpecialistPoolsRequest payload, int pageSize) {
            return ListSpecialistPoolsRequest.newBuilder((ListSpecialistPoolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSpecialistPoolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSpecialistPoolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SpecialistPool> extractResources(ListSpecialistPoolsResponse payload) {
            return payload.getSpecialistPoolsList() == null ? ImmutableList.of() : payload.getSpecialistPoolsList();
        }
    };
    private static final PagedListResponseFactory<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> LIST_SPECIALIST_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse>(){

        public ApiFuture<SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse> callable, ListSpecialistPoolsRequest request, ApiCallContext context, ApiFuture<ListSpecialistPoolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SPECIALIST_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse.createAsync((PageContext<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPool>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSpecialistPoolRequest, Operation> createSpecialistPoolSettings() {
        return this.createSpecialistPoolSettings;
    }

    public OperationCallSettings<CreateSpecialistPoolRequest, SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolOperationSettings() {
        return this.createSpecialistPoolOperationSettings;
    }

    public UnaryCallSettings<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolSettings() {
        return this.getSpecialistPoolSettings;
    }

    public PagedCallSettings<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> listSpecialistPoolsSettings() {
        return this.listSpecialistPoolsSettings;
    }

    public UnaryCallSettings<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolSettings() {
        return this.deleteSpecialistPoolSettings;
    }

    public OperationCallSettings<DeleteSpecialistPoolRequest, Empty, DeleteOperationMetadata> deleteSpecialistPoolOperationSettings() {
        return this.deleteSpecialistPoolOperationSettings;
    }

    public UnaryCallSettings<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolSettings() {
        return this.updateSpecialistPoolSettings;
    }

    public OperationCallSettings<UpdateSpecialistPoolRequest, SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolOperationSettings() {
        return this.updateSpecialistPoolOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SpecialistPoolServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSpecialistPoolServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SpecialistPoolServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SpecialistPoolServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SpecialistPoolServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSpecialistPoolSettings = settingsBuilder.createSpecialistPoolSettings().build();
        this.createSpecialistPoolOperationSettings = settingsBuilder.createSpecialistPoolOperationSettings().build();
        this.getSpecialistPoolSettings = settingsBuilder.getSpecialistPoolSettings().build();
        this.listSpecialistPoolsSettings = settingsBuilder.listSpecialistPoolsSettings().build();
        this.deleteSpecialistPoolSettings = settingsBuilder.deleteSpecialistPoolSettings().build();
        this.deleteSpecialistPoolOperationSettings = settingsBuilder.deleteSpecialistPoolOperationSettings().build();
        this.updateSpecialistPoolSettings = settingsBuilder.updateSpecialistPoolSettings().build();
        this.updateSpecialistPoolOperationSettings = settingsBuilder.updateSpecialistPoolOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SpecialistPoolServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSpecialistPoolRequest, Operation> createSpecialistPoolSettings;
        private final OperationCallSettings.Builder<CreateSpecialistPoolRequest, SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolOperationSettings;
        private final UnaryCallSettings.Builder<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolSettings;
        private final PagedCallSettings.Builder<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> listSpecialistPoolsSettings;
        private final UnaryCallSettings.Builder<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolSettings;
        private final OperationCallSettings.Builder<DeleteSpecialistPoolRequest, Empty, DeleteOperationMetadata> deleteSpecialistPoolOperationSettings;
        private final UnaryCallSettings.Builder<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolSettings;
        private final OperationCallSettings.Builder<UpdateSpecialistPoolRequest, SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSpecialistPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpecialistPoolOperationSettings = OperationCallSettings.newBuilder();
            this.getSpecialistPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSpecialistPoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SPECIALIST_POOLS_PAGE_STR_FACT);
            this.deleteSpecialistPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSpecialistPoolOperationSettings = OperationCallSettings.newBuilder();
            this.updateSpecialistPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSpecialistPoolOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSpecialistPoolSettings, this.getSpecialistPoolSettings, this.listSpecialistPoolsSettings, this.deleteSpecialistPoolSettings, this.updateSpecialistPoolSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SpecialistPoolServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSpecialistPoolSettings = settings.createSpecialistPoolSettings.toBuilder();
            this.createSpecialistPoolOperationSettings = settings.createSpecialistPoolOperationSettings.toBuilder();
            this.getSpecialistPoolSettings = settings.getSpecialistPoolSettings.toBuilder();
            this.listSpecialistPoolsSettings = settings.listSpecialistPoolsSettings.toBuilder();
            this.deleteSpecialistPoolSettings = settings.deleteSpecialistPoolSettings.toBuilder();
            this.deleteSpecialistPoolOperationSettings = settings.deleteSpecialistPoolOperationSettings.toBuilder();
            this.updateSpecialistPoolSettings = settings.updateSpecialistPoolSettings.toBuilder();
            this.updateSpecialistPoolOperationSettings = settings.updateSpecialistPoolOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSpecialistPoolSettings, this.getSpecialistPoolSettings, this.listSpecialistPoolsSettings, this.deleteSpecialistPoolSettings, this.updateSpecialistPoolSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SpecialistPoolServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SpecialistPoolServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SpecialistPoolServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SpecialistPoolServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SpecialistPoolServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSpecialistPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params"));
            builder.getSpecialistPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params"));
            builder.listSpecialistPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params"));
            builder.deleteSpecialistPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params"));
            builder.updateSpecialistPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params"));
            builder.createSpecialistPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SpecialistPool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateSpecialistPoolOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSpecialistPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSpecialistPoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_10_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SpecialistPool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateSpecialistPoolOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSpecialistPoolRequest, Operation> createSpecialistPoolSettings() {
            return this.createSpecialistPoolSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSpecialistPoolRequest, SpecialistPool, CreateSpecialistPoolOperationMetadata> createSpecialistPoolOperationSettings() {
            return this.createSpecialistPoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSpecialistPoolRequest, SpecialistPool> getSpecialistPoolSettings() {
            return this.getSpecialistPoolSettings;
        }

        public PagedCallSettings.Builder<ListSpecialistPoolsRequest, ListSpecialistPoolsResponse, SpecialistPoolServiceClient.ListSpecialistPoolsPagedResponse> listSpecialistPoolsSettings() {
            return this.listSpecialistPoolsSettings;
        }

        public UnaryCallSettings.Builder<DeleteSpecialistPoolRequest, Operation> deleteSpecialistPoolSettings() {
            return this.deleteSpecialistPoolSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSpecialistPoolRequest, Empty, DeleteOperationMetadata> deleteSpecialistPoolOperationSettings() {
            return this.deleteSpecialistPoolOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpecialistPoolRequest, Operation> updateSpecialistPoolSettings() {
            return this.updateSpecialistPoolSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateSpecialistPoolRequest, SpecialistPool, UpdateSpecialistPoolOperationMetadata> updateSpecialistPoolOperationSettings() {
            return this.updateSpecialistPoolOperationSettings;
        }

        public SpecialistPoolServiceStubSettings build() throws IOException {
            return new SpecialistPoolServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_10_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_10_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

