/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.BatchMigrateResourcesOperationMetadata;
import com.google.cloud.aiplatform.v1.BatchMigrateResourcesRequest;
import com.google.cloud.aiplatform.v1.BatchMigrateResourcesResponse;
import com.google.cloud.aiplatform.v1.MigratableResource;
import com.google.cloud.aiplatform.v1.MigrationServiceClient;
import com.google.cloud.aiplatform.v1.SearchMigratableResourcesRequest;
import com.google.cloud.aiplatform.v1.SearchMigratableResourcesResponse;
import com.google.cloud.aiplatform.v1.stub.GrpcMigrationServiceStub;
import com.google.cloud.aiplatform.v1.stub.MigrationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class MigrationServiceStubSettings
extends StubSettings<MigrationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigrationServiceClient.SearchMigratableResourcesPagedResponse> searchMigratableResourcesSettings;
    private final UnaryCallSettings<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesSettings;
    private final OperationCallSettings<BatchMigrateResourcesRequest, BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesOperationSettings;
    private static final PagedListDescriptor<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource> SEARCH_MIGRATABLE_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource>(){

        public String emptyToken() {
            return "";
        }

        public SearchMigratableResourcesRequest injectToken(SearchMigratableResourcesRequest payload, String token) {
            return SearchMigratableResourcesRequest.newBuilder((SearchMigratableResourcesRequest)payload).setPageToken(token).build();
        }

        public SearchMigratableResourcesRequest injectPageSize(SearchMigratableResourcesRequest payload, int pageSize) {
            return SearchMigratableResourcesRequest.newBuilder((SearchMigratableResourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchMigratableResourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchMigratableResourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MigratableResource> extractResources(SearchMigratableResourcesResponse payload) {
            return payload.getMigratableResourcesList() == null ? ImmutableList.of() : payload.getMigratableResourcesList();
        }
    };
    private static final PagedListResponseFactory<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigrationServiceClient.SearchMigratableResourcesPagedResponse> SEARCH_MIGRATABLE_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigrationServiceClient.SearchMigratableResourcesPagedResponse>(){

        public ApiFuture<MigrationServiceClient.SearchMigratableResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse> callable, SearchMigratableResourcesRequest request, ApiCallContext context, ApiFuture<SearchMigratableResourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_MIGRATABLE_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MigrationServiceClient.SearchMigratableResourcesPagedResponse.createAsync((PageContext<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigratableResource>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigrationServiceClient.SearchMigratableResourcesPagedResponse> searchMigratableResourcesSettings() {
        return this.searchMigratableResourcesSettings;
    }

    public UnaryCallSettings<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesSettings() {
        return this.batchMigrateResourcesSettings;
    }

    public OperationCallSettings<BatchMigrateResourcesRequest, BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesOperationSettings() {
        return this.batchMigrateResourcesOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MigrationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMigrationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MigrationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MigrationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MigrationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchMigratableResourcesSettings = settingsBuilder.searchMigratableResourcesSettings().build();
        this.batchMigrateResourcesSettings = settingsBuilder.batchMigrateResourcesSettings().build();
        this.batchMigrateResourcesOperationSettings = settingsBuilder.batchMigrateResourcesOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MigrationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigrationServiceClient.SearchMigratableResourcesPagedResponse> searchMigratableResourcesSettings;
        private final UnaryCallSettings.Builder<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesSettings;
        private final OperationCallSettings.Builder<BatchMigrateResourcesRequest, BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchMigratableResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_MIGRATABLE_RESOURCES_PAGE_STR_FACT);
            this.batchMigrateResourcesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchMigrateResourcesOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchMigratableResourcesSettings, this.batchMigrateResourcesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MigrationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.searchMigratableResourcesSettings = settings.searchMigratableResourcesSettings.toBuilder();
            this.batchMigrateResourcesSettings = settings.batchMigrateResourcesSettings.toBuilder();
            this.batchMigrateResourcesOperationSettings = settings.batchMigrateResourcesOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchMigratableResourcesSettings, this.batchMigrateResourcesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MigrationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MigrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MigrationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MigrationServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(MigrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchMigratableResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchMigrateResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchMigrateResourcesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchMigrateResourcesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchMigrateResourcesOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<SearchMigratableResourcesRequest, SearchMigratableResourcesResponse, MigrationServiceClient.SearchMigratableResourcesPagedResponse> searchMigratableResourcesSettings() {
            return this.searchMigratableResourcesSettings;
        }

        public UnaryCallSettings.Builder<BatchMigrateResourcesRequest, Operation> batchMigrateResourcesSettings() {
            return this.batchMigrateResourcesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchMigrateResourcesRequest, BatchMigrateResourcesResponse, BatchMigrateResourcesOperationMetadata> batchMigrateResourcesOperationSettings() {
            return this.batchMigrateResourcesOperationSettings;
        }

        public MigrationServiceStubSettings build() throws IOException {
            return new MigrationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

