/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.ReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.ReadFeatureValuesResponse;
import com.google.cloud.aiplatform.v1beta1.StreamingReadFeatureValuesRequest;
import com.google.cloud.aiplatform.v1beta1.stub.FeaturestoreOnlineServingServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.FeaturestoreOnlineServingServiceStubSettings;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcFeaturestoreOnlineServingServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcFeaturestoreOnlineServingServiceStub
extends FeaturestoreOnlineServingServiceStub {
    private static final MethodDescriptor<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.FeaturestoreOnlineServingService/ReadFeatureValues").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadFeatureValuesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadFeatureValuesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.aiplatform.v1beta1.FeaturestoreOnlineServingService/StreamingReadFeatureValues").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingReadFeatureValuesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadFeatureValuesResponse.getDefaultInstance())).build();
    private final UnaryCallable<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesCallable;
    private final ServerStreamingCallable<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFeaturestoreOnlineServingServiceStub create(FeaturestoreOnlineServingServiceStubSettings settings) throws IOException {
        return new GrpcFeaturestoreOnlineServingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFeaturestoreOnlineServingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFeaturestoreOnlineServingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFeaturestoreOnlineServingServiceCallableFactory());
    }

    protected GrpcFeaturestoreOnlineServingServiceStub(FeaturestoreOnlineServingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings readFeatureValuesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readFeatureValuesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadFeatureValuesRequest>(){

            public Map<String, String> extract(ReadFeatureValuesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"entity_type", (Object)String.valueOf(request.getEntityType()));
                return params.build();
            }
        }).build();
        GrpcCallSettings streamingReadFeatureValuesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingReadFeatureValuesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<StreamingReadFeatureValuesRequest>(){

            public Map<String, String> extract(StreamingReadFeatureValuesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"entity_type", (Object)String.valueOf(request.getEntityType()));
                return params.build();
            }
        }).build();
        this.readFeatureValuesCallable = callableFactory.createUnaryCallable(readFeatureValuesTransportSettings, settings.readFeatureValuesSettings(), clientContext);
        this.streamingReadFeatureValuesCallable = callableFactory.createServerStreamingCallable(streamingReadFeatureValuesTransportSettings, settings.streamingReadFeatureValuesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ReadFeatureValuesRequest, ReadFeatureValuesResponse> readFeatureValuesCallable() {
        return this.readFeatureValuesCallable;
    }

    @Override
    public ServerStreamingCallable<StreamingReadFeatureValuesRequest, ReadFeatureValuesResponse> streamingReadFeatureValuesCallable() {
        return this.streamingReadFeatureValuesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

