/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.advisorynotifications.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.advisorynotifications.v1.AdvisoryNotificationsServiceClient;
import com.google.cloud.advisorynotifications.v1.GetNotificationRequest;
import com.google.cloud.advisorynotifications.v1.GetSettingsRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsResponse;
import com.google.cloud.advisorynotifications.v1.Notification;
import com.google.cloud.advisorynotifications.v1.Settings;
import com.google.cloud.advisorynotifications.v1.UpdateSettingsRequest;
import com.google.cloud.advisorynotifications.v1.stub.AdvisoryNotificationsServiceStub;
import com.google.cloud.advisorynotifications.v1.stub.GrpcAdvisoryNotificationsServiceStub;
import com.google.cloud.advisorynotifications.v1.stub.HttpJsonAdvisoryNotificationsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AdvisoryNotificationsServiceStubSettings
extends StubSettings<AdvisoryNotificationsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListNotificationsRequest, ListNotificationsResponse, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsSettings;
    private final UnaryCallSettings<GetNotificationRequest, Notification> getNotificationSettings;
    private final UnaryCallSettings<GetSettingsRequest, Settings> getSettingsSettings;
    private final UnaryCallSettings<UpdateSettingsRequest, Settings> updateSettingsSettings;
    private static final PagedListDescriptor<ListNotificationsRequest, ListNotificationsResponse, Notification> LIST_NOTIFICATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListNotificationsRequest, ListNotificationsResponse, Notification>(){

        public String emptyToken() {
            return "";
        }

        public ListNotificationsRequest injectToken(ListNotificationsRequest payload, String token) {
            return ListNotificationsRequest.newBuilder((ListNotificationsRequest)payload).setPageToken(token).build();
        }

        public ListNotificationsRequest injectPageSize(ListNotificationsRequest payload, int pageSize) {
            return ListNotificationsRequest.newBuilder((ListNotificationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNotificationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNotificationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Notification> extractResources(ListNotificationsResponse payload) {
            return payload.getNotificationsList() == null ? ImmutableList.of() : payload.getNotificationsList();
        }
    };
    private static final PagedListResponseFactory<ListNotificationsRequest, ListNotificationsResponse, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> LIST_NOTIFICATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListNotificationsRequest, ListNotificationsResponse, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse>(){

        public ApiFuture<AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> callable, ListNotificationsRequest request, ApiCallContext context, ApiFuture<ListNotificationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NOTIFICATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse.createAsync((PageContext<ListNotificationsRequest, ListNotificationsResponse, Notification>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListNotificationsRequest, ListNotificationsResponse, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsSettings() {
        return this.listNotificationsSettings;
    }

    public UnaryCallSettings<GetNotificationRequest, Notification> getNotificationSettings() {
        return this.getNotificationSettings;
    }

    public UnaryCallSettings<GetSettingsRequest, Settings> getSettingsSettings() {
        return this.getSettingsSettings;
    }

    public UnaryCallSettings<UpdateSettingsRequest, Settings> updateSettingsSettings() {
        return this.updateSettingsSettings;
    }

    public AdvisoryNotificationsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAdvisoryNotificationsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAdvisoryNotificationsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "advisorynotifications.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "advisorynotifications.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdvisoryNotificationsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdvisoryNotificationsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdvisoryNotificationsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AdvisoryNotificationsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdvisoryNotificationsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listNotificationsSettings = settingsBuilder.listNotificationsSettings().build();
        this.getNotificationSettings = settingsBuilder.getNotificationSettings().build();
        this.getSettingsSettings = settingsBuilder.getSettingsSettings().build();
        this.updateSettingsSettings = settingsBuilder.updateSettingsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdvisoryNotificationsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListNotificationsRequest, ListNotificationsResponse, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsSettings;
        private final UnaryCallSettings.Builder<GetNotificationRequest, Notification> getNotificationSettings;
        private final UnaryCallSettings.Builder<GetSettingsRequest, Settings> getSettingsSettings;
        private final UnaryCallSettings.Builder<UpdateSettingsRequest, Settings> updateSettingsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listNotificationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NOTIFICATIONS_PAGE_STR_FACT);
            this.getNotificationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listNotificationsSettings, this.getNotificationSettings, this.getSettingsSettings, this.updateSettingsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AdvisoryNotificationsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listNotificationsSettings = settings.listNotificationsSettings.toBuilder();
            this.getNotificationSettings = settings.getNotificationSettings.toBuilder();
            this.getSettingsSettings = settings.getSettingsSettings.toBuilder();
            this.updateSettingsSettings = settings.updateSettingsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listNotificationsSettings, this.getNotificationSettings, this.getSettingsSettings, this.updateSettingsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdvisoryNotificationsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdvisoryNotificationsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdvisoryNotificationsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AdvisoryNotificationsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AdvisoryNotificationsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AdvisoryNotificationsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AdvisoryNotificationsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdvisoryNotificationsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AdvisoryNotificationsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AdvisoryNotificationsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listNotificationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNotificationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListNotificationsRequest, ListNotificationsResponse, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsSettings() {
            return this.listNotificationsSettings;
        }

        public UnaryCallSettings.Builder<GetNotificationRequest, Notification> getNotificationSettings() {
            return this.getNotificationSettings;
        }

        public UnaryCallSettings.Builder<GetSettingsRequest, Settings> getSettingsSettings() {
            return this.getSettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSettingsRequest, Settings> updateSettingsSettings() {
            return this.updateSettingsSettings;
        }

        public AdvisoryNotificationsServiceStubSettings build() throws IOException {
            return new AdvisoryNotificationsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

