/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.advisorynotifications.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.advisorynotifications.v1.AdvisoryNotificationsServiceClient;
import com.google.cloud.advisorynotifications.v1.GetNotificationRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsRequest;
import com.google.cloud.advisorynotifications.v1.ListNotificationsResponse;
import com.google.cloud.advisorynotifications.v1.Notification;
import com.google.cloud.advisorynotifications.v1.stub.AdvisoryNotificationsServiceStub;
import com.google.cloud.advisorynotifications.v1.stub.AdvisoryNotificationsServiceStubSettings;
import com.google.cloud.advisorynotifications.v1.stub.GrpcAdvisoryNotificationsServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAdvisoryNotificationsServiceStub
extends AdvisoryNotificationsServiceStub {
    private static final MethodDescriptor<ListNotificationsRequest, ListNotificationsResponse> listNotificationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.advisorynotifications.v1.AdvisoryNotificationsService/ListNotifications").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNotificationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNotificationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNotificationRequest, Notification> getNotificationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.advisorynotifications.v1.AdvisoryNotificationsService/GetNotification").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNotificationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Notification.getDefaultInstance())).build();
    private final UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> listNotificationsCallable;
    private final UnaryCallable<ListNotificationsRequest, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsPagedCallable;
    private final UnaryCallable<GetNotificationRequest, Notification> getNotificationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdvisoryNotificationsServiceStub create(AdvisoryNotificationsServiceStubSettings settings) throws IOException {
        return new GrpcAdvisoryNotificationsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdvisoryNotificationsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdvisoryNotificationsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdvisoryNotificationsServiceCallableFactory());
    }

    protected GrpcAdvisoryNotificationsServiceStub(AdvisoryNotificationsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listNotificationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNotificationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getNotificationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNotificationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listNotificationsCallable = callableFactory.createUnaryCallable(listNotificationsTransportSettings, settings.listNotificationsSettings(), clientContext);
        this.listNotificationsPagedCallable = callableFactory.createPagedCallable(listNotificationsTransportSettings, settings.listNotificationsSettings(), clientContext);
        this.getNotificationCallable = callableFactory.createUnaryCallable(getNotificationTransportSettings, settings.getNotificationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> listNotificationsCallable() {
        return this.listNotificationsCallable;
    }

    @Override
    public UnaryCallable<ListNotificationsRequest, AdvisoryNotificationsServiceClient.ListNotificationsPagedResponse> listNotificationsPagedCallable() {
        return this.listNotificationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetNotificationRequest, Notification> getNotificationCallable() {
        return this.getNotificationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

