/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker.http;

import com.google.cloud.functions.HttpResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

public class HttpResponseImpl
implements HttpResponse {
    private final HttpServletResponse response;
    private BufferedWriter writer;

    public HttpResponseImpl(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public void setStatusCode(int code) {
        this.response.setStatus(code);
    }

    @Override
    public void setStatusCode(int code, String message) {
        this.response.setStatus(code, message);
    }

    @Override
    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    @Override
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.response.getContentType());
    }

    @Override
    public void appendHeader(String key, String value) {
        this.response.addHeader(key, value);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.response.getHeaderNames().stream().map(header -> new AbstractMap.SimpleEntry<String, List<String>>((String)header, HttpResponseImpl.list(this.response.getHeaders((String)header)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <T> List<T> list(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public synchronized BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(this.response.getWriter());
        }
        return this.writer;
    }
}

