/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.plugin;

import com.google.cloud.tools.appengine.operations.CloudSdk;
import com.google.cloud.tools.appengine.operations.Gcloud;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkNotFoundException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkOutOfDateException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkVersionFileException;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.ProcessHandlerException;
import com.google.cloud.tools.managedcloudsdk.BadCloudSdkVersionException;
import com.google.cloud.tools.managedcloudsdk.ManagedCloudSdk;
import com.google.cloud.tools.managedcloudsdk.UnsupportedOsException;
import com.google.cloud.tools.managedcloudsdk.Version;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkChecker;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkDownloader;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkMojo;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.NONE)
@Execute(phase=LifecyclePhase.NONE)
public class DeployFunction
extends CloudSdkMojo {
    @Parameter(alias="deploy.projectId", property="function.deploy.projectId")
    protected String projectId;
    @Parameter(alias="deploy.name", property="function.deploy.name", required=true)
    String name;
    @Parameter(alias="deploy.region", property="function.deploy.region")
    String region;
    @Parameter(alias="deploy.allowunauthenticated", property="function.deploy.allowunauthenticated", defaultValue="false")
    boolean allowUnauthenticated;
    @Parameter(alias="deploy.functiontarget", property="function.deploy.functiontarget")
    String functionTarget;
    @Parameter(alias="deploy.ignorefile", property="function.deploy.ignorefile")
    String ignoreFile;
    @Parameter(alias="deploy.memory", property="function.deploy.memory")
    String memory;
    @Parameter(alias="deploy.retry", property="function.deploy.retry")
    String retry;
    @Parameter(alias="deploy.runtime", defaultValue="java11", property="function.deploy.runtime")
    String runtime = "java11";
    @Parameter(alias="deploy.serviceaccount", property="function.deploy.serviceaccount")
    String serviceAccount;
    @Parameter(alias="deploy.source", property="function.deploy.source")
    String source;
    @Parameter(alias="deploy.stagebucket", property="function.deploy.stagebucket")
    String stageBucket;
    @Parameter(alias="deploy.timeout", property="function.deploy.timeout")
    String timeout;
    @Parameter(alias="deploy.updatelabels", property="function.deploy.updatelabels")
    List<String> updateLabels;
    @Parameter(alias="deploy.triggerhttp", property="function.deploy.triggerhttp")
    Boolean triggerHttp;
    @Parameter(alias="deploy.triggertopic", property="function.deploy.triggertopic")
    String triggerTopic;
    @Parameter(alias="deploy.triggerevent", property="function.deploy.triggerevent")
    String triggerEvent;
    @Parameter(alias="deploy.triggerresource", property="function.deploy.triggerresource")
    String triggerResource;
    @Parameter(alias="deploy.vpcconnector", property="function.deploy.vpcconnector")
    String vpcConnector;
    @Parameter(alias="deploy.maxinstances", property="function.deploy.maxinstances")
    Integer maxInstances;
    @Parameter(alias="deploy.setenvvars", property="function.deploy.setenvvars")
    Map<String, String> environmentVariables;
    @Parameter(alias="deploy.envvarsfile", property="function.deploy.envvarsfile")
    String envVarsFile;

    boolean hasEnvVariables() {
        return this.environmentVariables != null && !this.environmentVariables.isEmpty();
    }

    static Function<String, ManagedCloudSdk> newManagedSdkFactory() {
        return version -> {
            try {
                if (Strings.isNullOrEmpty((String)version)) {
                    return ManagedCloudSdk.newManagedSdk();
                }
                return ManagedCloudSdk.newManagedSdk((Version)new Version(version));
            }
            catch (BadCloudSdkVersionException | UnsupportedOsException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    CloudSdk buildCloudSdkMinimal() {
        return DeployFunction.buildCloudSdk(this, new CloudSdkChecker(), new CloudSdkDownloader(DeployFunction.newManagedSdkFactory()));
    }

    static CloudSdk buildCloudSdk(CloudSdkMojo mojo, CloudSdkChecker cloudSdkChecker, CloudSdkDownloader cloudSdkDownloader) {
        try {
            if (mojo.getCloudSdkHome() != null) {
                CloudSdk cloudSdk = new CloudSdk.Builder().sdkPath(mojo.getCloudSdkHome()).build();
                if (mojo.getCloudSdkVersion() != null) {
                    cloudSdkChecker.checkCloudSdk(cloudSdk, mojo.getCloudSdkVersion());
                }
                return cloudSdk;
            }
            return new CloudSdk.Builder().sdkPath(cloudSdkDownloader.downloadIfNecessary(mojo.getCloudSdkVersion(), mojo.getLog(), Collections.emptyList(), mojo.getMavenSession().isOffline())).build();
        }
        catch (CloudSdkNotFoundException | CloudSdkOutOfDateException | CloudSdkVersionFileException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Gcloud getGcloud() {
        return Gcloud.builder((CloudSdk)this.buildCloudSdkMinimal()).setMetricsEnvironment(this.getArtifactId(), this.getArtifactVersion()).setCredentialFile(this.getServiceAccountKeyFile()).build();
    }

    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("functions");
        commands.add("deploy");
        commands.add(this.name);
        if (this.region != null) {
            String string = String.valueOf(this.region);
            commands.add(string.length() != 0 ? "--region=".concat(string) : new String("--region="));
        }
        if (this.triggerResource == null && this.triggerTopic == null && this.triggerEvent == null) {
            commands.add("--trigger-http");
        }
        if (this.triggerResource != null) {
            String string = String.valueOf(this.triggerResource);
            commands.add(string.length() != 0 ? "--trigger-resource=".concat(string) : new String("--trigger-resource="));
        }
        if (this.triggerTopic != null) {
            String string = String.valueOf(this.triggerTopic);
            commands.add(string.length() != 0 ? "--trigger-topic=".concat(string) : new String("--trigger-topic="));
        }
        if (this.triggerEvent != null) {
            String string = String.valueOf(this.triggerEvent);
            commands.add(string.length() != 0 ? "--trigger-event=".concat(string) : new String("--trigger-event="));
        }
        if (this.allowUnauthenticated) {
            commands.add("--allow-unauthenticated");
        }
        if (this.functionTarget != null) {
            String string = String.valueOf(this.functionTarget);
            commands.add(string.length() != 0 ? "--entry-point=".concat(string) : new String("--entry-point="));
        }
        if (this.ignoreFile != null) {
            String string = String.valueOf(this.ignoreFile);
            commands.add(string.length() != 0 ? "--ignore-file=".concat(string) : new String("--ignore-file="));
        }
        if (this.memory != null) {
            String string = String.valueOf(this.memory);
            commands.add(string.length() != 0 ? "--memory=".concat(string) : new String("--memory="));
        }
        if (this.retry != null) {
            String string = String.valueOf(this.retry);
            commands.add(string.length() != 0 ? "--retry=".concat(string) : new String("--retry="));
        }
        if (this.serviceAccount != null) {
            String string = String.valueOf(this.serviceAccount);
            commands.add(string.length() != 0 ? "--service-account=".concat(string) : new String("--service-account="));
        }
        if (this.source != null) {
            String string = String.valueOf(this.source);
            commands.add(string.length() != 0 ? "--source=".concat(string) : new String("--source="));
        }
        if (this.stageBucket != null) {
            String string = String.valueOf(this.stageBucket);
            commands.add(string.length() != 0 ? "--stage-bucket=".concat(string) : new String("--stage-bucket="));
        }
        if (this.timeout != null) {
            String string = String.valueOf(this.timeout);
            commands.add(string.length() != 0 ? "--timeout=".concat(string) : new String("--timeout="));
        }
        if (this.updateLabels != null && !this.updateLabels.isEmpty()) {
            String string = String.valueOf(String.join((CharSequence)",", this.updateLabels));
            commands.add(string.length() != 0 ? "--update-labels=".concat(string) : new String("--update-labels="));
        }
        if (this.vpcConnector != null) {
            String string = String.valueOf(this.vpcConnector);
            commands.add(string.length() != 0 ? "--vpc-connector=".concat(string) : new String("--vpc-connector="));
        }
        if (this.maxInstances != null) {
            String string = String.valueOf(this.maxInstances);
            commands.add(new StringBuilder(16 + String.valueOf(string).length()).append("--max-instances=").append(string).toString());
        }
        if (this.hasEnvVariables()) {
            Joiner.MapJoiner mapJoiner = Joiner.on((String)",").withKeyValueSeparator("=");
            String string = String.valueOf(mapJoiner.join(this.environmentVariables));
            commands.add(string.length() != 0 ? "--set-env-vars=".concat(string) : new String("--set-env-vars="));
        }
        if (this.envVarsFile != null) {
            String string = String.valueOf(this.envVarsFile);
            commands.add(string.length() != 0 ? "--env-var-file=".concat(string) : new String("--env-var-file="));
        }
        String string = String.valueOf(this.runtime);
        commands.add(string.length() != 0 ? "--runtime=".concat(string) : new String("--runtime="));
        if (this.projectId != null) {
            String string2 = String.valueOf(this.projectId);
            commands.add(string2.length() != 0 ? "--project=".concat(string2) : new String("--project="));
        }
        return Collections.unmodifiableList(commands);
    }

    public void execute() throws MojoExecutionException {
        try {
            Gcloud gcloud = this.getGcloud();
            List<String> params = this.getCommands();
            String string = String.valueOf(String.join((CharSequence)" ", params));
            System.out.println(string.length() != 0 ? "Executing Cloud SDK command: gcloud ".concat(string) : new String("Executing Cloud SDK command: gcloud "));
            gcloud.runCommand(params);
        }
        catch (CloudSdkNotFoundException | ProcessHandlerException | IOException ex) {
            Logger.getLogger(DeployFunction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

