/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util.interceptors;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggingInterceptor
extends Handler {
    private final Logging cloudLogging;
    private final String logNameSuffix;
    private static final String LOG_NAME_PREFIX = "gcs-connector";

    public LoggingInterceptor(GoogleCredentials credentials, String logNameSuffix) {
        this.cloudLogging = this.createLoggingService(credentials);
        this.logNameSuffix = logNameSuffix;
    }

    protected Logging createLoggingService(GoogleCredentials credentials) {
        return (Logging)((LoggingOptions.Builder)LoggingOptions.newBuilder().setCredentials((Credentials)credentials)).build().getService();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String logName = String.join((CharSequence)"-", LOG_NAME_PREFIX, this.logNameSuffix).replaceAll("-$", "");
        LogEntry entry = LogEntry.newBuilder((Payload)Payload.StringPayload.of((String)record.getMessage())).setSeverity(this.mapToCloudSeverity(record.getLevel())).setLogName(logName).addLabel("class", record.getSourceClassName()).addLabel("method", record.getSourceMethodName()).build();
        this.cloudLogging.write(Collections.singleton(entry), new Logging.WriteOption[0]);
    }

    @Override
    public void flush() {
        this.cloudLogging.flush();
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.cloudLogging.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close the Google Cloud Logging service", e);
        }
    }

    private Severity mapToCloudSeverity(Level level) {
        switch (level.getName()) {
            case "SEVERE": {
                return Severity.ERROR;
            }
            case "WARNING": {
                return Severity.WARNING;
            }
            case "INFO": {
                return Severity.INFO;
            }
            case "FINE": 
            case "FINER": 
            case "FINEST": {
                return Severity.DEBUG;
            }
        }
        return Severity.DEFAULT;
    }
}

