package com.google.cloud.hadoop.util;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CredentialOptions extends CredentialOptions {

  private final boolean serviceAccountEnabled;

  private final RedactedString serviceAccountPrivateKeyId;

  private final RedactedString serviceAccountPrivateKey;

  private final String serviceAccountEmail;

  private final String serviceAccountKeyFile;

  private final String serviceAccountJsonKeyFile;

  private final boolean nullCredentialEnabled;

  private final HttpTransportFactory.HttpTransportType transportType;

  private final String tokenServerUrl;

  private final String proxyAddress;

  private final RedactedString proxyUsername;

  private final RedactedString proxyPassword;

  private AutoValue_CredentialOptions(
      boolean serviceAccountEnabled,
      @Nullable RedactedString serviceAccountPrivateKeyId,
      @Nullable RedactedString serviceAccountPrivateKey,
      @Nullable String serviceAccountEmail,
      @Nullable String serviceAccountKeyFile,
      @Nullable String serviceAccountJsonKeyFile,
      boolean nullCredentialEnabled,
      HttpTransportFactory.HttpTransportType transportType,
      String tokenServerUrl,
      @Nullable String proxyAddress,
      @Nullable RedactedString proxyUsername,
      @Nullable RedactedString proxyPassword) {
    this.serviceAccountEnabled = serviceAccountEnabled;
    this.serviceAccountPrivateKeyId = serviceAccountPrivateKeyId;
    this.serviceAccountPrivateKey = serviceAccountPrivateKey;
    this.serviceAccountEmail = serviceAccountEmail;
    this.serviceAccountKeyFile = serviceAccountKeyFile;
    this.serviceAccountJsonKeyFile = serviceAccountJsonKeyFile;
    this.nullCredentialEnabled = nullCredentialEnabled;
    this.transportType = transportType;
    this.tokenServerUrl = tokenServerUrl;
    this.proxyAddress = proxyAddress;
    this.proxyUsername = proxyUsername;
    this.proxyPassword = proxyPassword;
  }

  @Override
  public boolean isServiceAccountEnabled() {
    return serviceAccountEnabled;
  }

  @Nullable
  @Override
  public RedactedString getServiceAccountPrivateKeyId() {
    return serviceAccountPrivateKeyId;
  }

  @Nullable
  @Override
  public RedactedString getServiceAccountPrivateKey() {
    return serviceAccountPrivateKey;
  }

  @Nullable
  @Override
  public String getServiceAccountEmail() {
    return serviceAccountEmail;
  }

  @Nullable
  @Override
  public String getServiceAccountKeyFile() {
    return serviceAccountKeyFile;
  }

  @Nullable
  @Override
  public String getServiceAccountJsonKeyFile() {
    return serviceAccountJsonKeyFile;
  }

  @Override
  public boolean isNullCredentialEnabled() {
    return nullCredentialEnabled;
  }

  @Override
  public HttpTransportFactory.HttpTransportType getTransportType() {
    return transportType;
  }

  @Override
  public String getTokenServerUrl() {
    return tokenServerUrl;
  }

  @Nullable
  @Override
  public String getProxyAddress() {
    return proxyAddress;
  }

  @Nullable
  @Override
  public RedactedString getProxyUsername() {
    return proxyUsername;
  }

  @Nullable
  @Override
  public RedactedString getProxyPassword() {
    return proxyPassword;
  }

  @Override
  public String toString() {
    return "CredentialOptions{"
        + "serviceAccountEnabled=" + serviceAccountEnabled + ", "
        + "serviceAccountPrivateKeyId=" + serviceAccountPrivateKeyId + ", "
        + "serviceAccountPrivateKey=" + serviceAccountPrivateKey + ", "
        + "serviceAccountEmail=" + serviceAccountEmail + ", "
        + "serviceAccountKeyFile=" + serviceAccountKeyFile + ", "
        + "serviceAccountJsonKeyFile=" + serviceAccountJsonKeyFile + ", "
        + "nullCredentialEnabled=" + nullCredentialEnabled + ", "
        + "transportType=" + transportType + ", "
        + "tokenServerUrl=" + tokenServerUrl + ", "
        + "proxyAddress=" + proxyAddress + ", "
        + "proxyUsername=" + proxyUsername + ", "
        + "proxyPassword=" + proxyPassword
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CredentialOptions) {
      CredentialOptions that = (CredentialOptions) o;
      return this.serviceAccountEnabled == that.isServiceAccountEnabled()
          && (this.serviceAccountPrivateKeyId == null ? that.getServiceAccountPrivateKeyId() == null : this.serviceAccountPrivateKeyId.equals(that.getServiceAccountPrivateKeyId()))
          && (this.serviceAccountPrivateKey == null ? that.getServiceAccountPrivateKey() == null : this.serviceAccountPrivateKey.equals(that.getServiceAccountPrivateKey()))
          && (this.serviceAccountEmail == null ? that.getServiceAccountEmail() == null : this.serviceAccountEmail.equals(that.getServiceAccountEmail()))
          && (this.serviceAccountKeyFile == null ? that.getServiceAccountKeyFile() == null : this.serviceAccountKeyFile.equals(that.getServiceAccountKeyFile()))
          && (this.serviceAccountJsonKeyFile == null ? that.getServiceAccountJsonKeyFile() == null : this.serviceAccountJsonKeyFile.equals(that.getServiceAccountJsonKeyFile()))
          && this.nullCredentialEnabled == that.isNullCredentialEnabled()
          && this.transportType.equals(that.getTransportType())
          && this.tokenServerUrl.equals(that.getTokenServerUrl())
          && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress()))
          && (this.proxyUsername == null ? that.getProxyUsername() == null : this.proxyUsername.equals(that.getProxyUsername()))
          && (this.proxyPassword == null ? that.getProxyPassword() == null : this.proxyPassword.equals(that.getProxyPassword()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= serviceAccountEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (serviceAccountPrivateKeyId == null) ? 0 : serviceAccountPrivateKeyId.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountPrivateKey == null) ? 0 : serviceAccountPrivateKey.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountEmail == null) ? 0 : serviceAccountEmail.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountKeyFile == null) ? 0 : serviceAccountKeyFile.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccountJsonKeyFile == null) ? 0 : serviceAccountJsonKeyFile.hashCode();
    h$ *= 1000003;
    h$ ^= nullCredentialEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= transportType.hashCode();
    h$ *= 1000003;
    h$ ^= tokenServerUrl.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyAddress == null) ? 0 : proxyAddress.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyUsername == null) ? 0 : proxyUsername.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyPassword == null) ? 0 : proxyPassword.hashCode();
    return h$;
  }

  @Override
  public CredentialOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CredentialOptions.Builder {
    private Boolean serviceAccountEnabled;
    private RedactedString serviceAccountPrivateKeyId;
    private RedactedString serviceAccountPrivateKey;
    private String serviceAccountEmail;
    private String serviceAccountKeyFile;
    private String serviceAccountJsonKeyFile;
    private Boolean nullCredentialEnabled;
    private HttpTransportFactory.HttpTransportType transportType;
    private String tokenServerUrl;
    private String proxyAddress;
    private RedactedString proxyUsername;
    private RedactedString proxyPassword;
    Builder() {
    }
    private Builder(CredentialOptions source) {
      this.serviceAccountEnabled = source.isServiceAccountEnabled();
      this.serviceAccountPrivateKeyId = source.getServiceAccountPrivateKeyId();
      this.serviceAccountPrivateKey = source.getServiceAccountPrivateKey();
      this.serviceAccountEmail = source.getServiceAccountEmail();
      this.serviceAccountKeyFile = source.getServiceAccountKeyFile();
      this.serviceAccountJsonKeyFile = source.getServiceAccountJsonKeyFile();
      this.nullCredentialEnabled = source.isNullCredentialEnabled();
      this.transportType = source.getTransportType();
      this.tokenServerUrl = source.getTokenServerUrl();
      this.proxyAddress = source.getProxyAddress();
      this.proxyUsername = source.getProxyUsername();
      this.proxyPassword = source.getProxyPassword();
    }
    @Override
    public CredentialOptions.Builder setServiceAccountEnabled(boolean serviceAccountEnabled) {
      this.serviceAccountEnabled = serviceAccountEnabled;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountPrivateKeyId(RedactedString serviceAccountPrivateKeyId) {
      this.serviceAccountPrivateKeyId = serviceAccountPrivateKeyId;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountPrivateKey(RedactedString serviceAccountPrivateKey) {
      this.serviceAccountPrivateKey = serviceAccountPrivateKey;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountEmail(String serviceAccountEmail) {
      this.serviceAccountEmail = serviceAccountEmail;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountKeyFile(String serviceAccountKeyFile) {
      this.serviceAccountKeyFile = serviceAccountKeyFile;
      return this;
    }
    @Override
    public CredentialOptions.Builder setServiceAccountJsonKeyFile(String serviceAccountJsonKeyFile) {
      this.serviceAccountJsonKeyFile = serviceAccountJsonKeyFile;
      return this;
    }
    @Override
    public CredentialOptions.Builder setNullCredentialEnabled(boolean nullCredentialEnabled) {
      this.nullCredentialEnabled = nullCredentialEnabled;
      return this;
    }
    @Override
    public CredentialOptions.Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
      if (transportType == null) {
        throw new NullPointerException("Null transportType");
      }
      this.transportType = transportType;
      return this;
    }
    @Override
    public CredentialOptions.Builder setTokenServerUrl(String tokenServerUrl) {
      if (tokenServerUrl == null) {
        throw new NullPointerException("Null tokenServerUrl");
      }
      this.tokenServerUrl = tokenServerUrl;
      return this;
    }
    @Override
    public CredentialOptions.Builder setProxyAddress(String proxyAddress) {
      this.proxyAddress = proxyAddress;
      return this;
    }
    @Override
    public CredentialOptions.Builder setProxyUsername(RedactedString proxyUsername) {
      this.proxyUsername = proxyUsername;
      return this;
    }
    @Override
    public CredentialOptions.Builder setProxyPassword(RedactedString proxyPassword) {
      this.proxyPassword = proxyPassword;
      return this;
    }
    @Override
    CredentialOptions autoBuild() {
      if (this.serviceAccountEnabled == null
          || this.nullCredentialEnabled == null
          || this.transportType == null
          || this.tokenServerUrl == null) {
        StringBuilder missing = new StringBuilder();
        if (this.serviceAccountEnabled == null) {
          missing.append(" serviceAccountEnabled");
        }
        if (this.nullCredentialEnabled == null) {
          missing.append(" nullCredentialEnabled");
        }
        if (this.transportType == null) {
          missing.append(" transportType");
        }
        if (this.tokenServerUrl == null) {
          missing.append(" tokenServerUrl");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CredentialOptions(
          this.serviceAccountEnabled,
          this.serviceAccountPrivateKeyId,
          this.serviceAccountPrivateKey,
          this.serviceAccountEmail,
          this.serviceAccountKeyFile,
          this.serviceAccountJsonKeyFile,
          this.nullCredentialEnabled,
          this.transportType,
          this.tokenServerUrl,
          this.proxyAddress,
          this.proxyUsername,
          this.proxyPassword);
    }
  }

}
