/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.cloud.hadoop.util.CredentialOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;

public class CredentialFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    public static final ImmutableList<String> DEFAULT_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static HttpTransport staticHttpTransport = null;
    private final CredentialOptions options;
    private HttpTransport transport;

    private static synchronized HttpTransport getStaticHttpTransport() throws IOException, GeneralSecurityException {
        if (staticHttpTransport == null) {
            staticHttpTransport = HttpTransportFactory.createHttpTransport(HttpTransportFactory.HttpTransportType.JAVA_NET);
        }
        return staticHttpTransport;
    }

    @VisibleForTesting
    static synchronized void setStaticHttpTransport(HttpTransport transport) {
        staticHttpTransport = transport;
    }

    public CredentialFactory(CredentialOptions options) {
        this.options = options;
    }

    public static Credential getCredentialFromMetadataServiceAccount() throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("Getting service account credentials from metadata service.");
        ComputeCredentialWithRetry cred = new ComputeCredentialWithRetry(new ComputeCredential.Builder(CredentialFactory.getStaticHttpTransport(), JSON_FACTORY).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()));
        try {
            cred.refreshToken();
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting access token from metadata server at: '%s'. cause='%s'", cred.getTokenServerEncodedUrl(), e.getMessage()), e);
        }
        return cred;
    }

    public Credential getCredentialFromPrivateKeyServiceAccount(List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromPrivateKeyServiceAccount(%s, %s) for '%s' from '%s'", scopes, (Object)transport, (Object)this.options.getServiceAccountEmail(), (Object)this.options.getServiceAccountKeyFile());
        return new GoogleCredentialWithRetry(new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(this.options.getServiceAccountEmail()).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(this.options.getServiceAccountKeyFile())).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()), this.options.getTokenServerUrl());
    }

    private Credential getCredentialFromJsonKeyFile(List<String> scopes, HttpTransport transport) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromJsonKeyFile(%s, %s) from '%s'", scopes, (Object)transport, (Object)this.options.getServiceAccountJsonKeyFile());
        try (FileInputStream fis = new FileInputStream(this.options.getServiceAccountJsonKeyFile());){
            GoogleCredentialWithRetry googleCredentialWithRetry = GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.fromStream((InputStream)fis, (HttpTransport)transport, (JsonFactory)JSON_FACTORY).createScoped(scopes), this.options.getTokenServerUrl());
            return googleCredentialWithRetry;
        }
    }

    private Credential getCredentialsFromSAParameters(List<String> scopes, HttpTransport transport) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialsFromSAParameters(%s, %s)", scopes, (Object)transport);
        GoogleCredential.Builder builder = new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(this.options.getServiceAccountEmail()).setServiceAccountScopes(scopes).setServiceAccountPrivateKey(CredentialFactory.privateKeyFromPkcs8(this.options.getServiceAccountPrivateKey().value())).setServiceAccountPrivateKeyId(this.options.getServiceAccountPrivateKeyId().value());
        return new GoogleCredentialWithRetry(builder, this.options.getTokenServerUrl());
    }

    private Credential getOAuthCredential(HttpTransport transport, List<String> scopes) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getOAuthCredential(%s)", (Object)transport);
        GoogleCredential.Builder builder = new GoogleCredential.Builder().setClientSecrets(this.options.getAuthClientId(), this.options.getAuthClientSecret().value()).setTransport(this.getTransport()).setJsonFactory(JSON_FACTORY);
        return new GoogleCredentialWithRetry(builder, this.options.getTokenServerUrl()).setRefreshToken(this.options.getAuthRefreshToken().value()).createScoped(scopes);
    }

    private static boolean isApplicationDefaultCredentialsConfigured() {
        return System.getenv(CREDENTIAL_ENV_VAR) != null;
    }

    private Credential getApplicationDefaultCredentials(List<String> scopes, HttpTransport transport) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getApplicationDefaultCredential(%s, %s)", scopes, (Object)transport);
        return GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.getApplicationDefault((HttpTransport)transport, (JsonFactory)JSON_FACTORY).createScoped(scopes), this.options.getTokenServerUrl());
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem.replace("\\n", System.lineSeparator()));
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new IOException(String.format("Unexpected exception reading PKCS data. cause=%s", exception.getMessage()), exception);
        }
    }

    public Credential getCredential(List<String> scopes) throws IOException, GeneralSecurityException {
        Preconditions.checkNotNull(scopes, (Object)"scopes must not be null");
        if (this.options.isServiceAccountEnabled()) {
            ((GoogleLogger.Api)logger.atFine()).log("Using service account credentials");
            if (this.useMetadataService()) {
                return CredentialFactory.getCredentialFromMetadataServiceAccount();
            }
            if (this.options.getServiceAccountPrivateKeyId() != null) {
                return this.getCredentialsFromSAParameters(scopes, this.getTransport());
            }
            if (!Strings.isNullOrEmpty((String)this.options.getServiceAccountJsonKeyFile())) {
                return this.getCredentialFromJsonKeyFile(scopes, this.getTransport());
            }
            if (!Strings.isNullOrEmpty((String)this.options.getServiceAccountKeyFile())) {
                return this.getCredentialFromPrivateKeyServiceAccount(scopes, this.getTransport());
            }
            if (CredentialFactory.isApplicationDefaultCredentialsConfigured()) {
                return this.getApplicationDefaultCredentials(scopes, this.getTransport());
            }
            if (CredentialFactory.isOAuthCredentialsConfigured(this.options)) {
                return this.getOAuthCredential(this.getTransport(), scopes);
            }
        } else if (this.options.isNullCredentialEnabled()) {
            ((GoogleLogger.Api)logger.atWarning()).log("Allowing null credentials for unit testing. This should not be used in production");
            return null;
        }
        throw new IllegalStateException("No valid credential configuration discovered: " + this);
    }

    private boolean useMetadataService() {
        return Strings.isNullOrEmpty((String)this.options.getServiceAccountKeyFile()) && Strings.isNullOrEmpty((String)this.options.getServiceAccountJsonKeyFile()) && this.options.getServiceAccountPrivateKey() == null && !CredentialFactory.isApplicationDefaultCredentialsConfigured() && !CredentialFactory.isOAuthCredentialsConfigured(this.options);
    }

    private HttpTransport getTransport() throws IOException {
        if (this.transport == null) {
            this.transport = HttpTransportFactory.createHttpTransport(this.options.getTransportType(), this.options.getProxyAddress(), this.options.getProxyUsername(), this.options.getProxyPassword());
        }
        return this.transport;
    }

    @VisibleForTesting
    void setTransport(HttpTransport transport) {
        this.transport = transport;
    }

    private static boolean isOAuthCredentialsConfigured(CredentialOptions options) {
        return !Strings.isNullOrEmpty((String)options.getAuthClientId()) && options.getAuthRefreshToken() != null && options.getAuthRefreshToken().value() != null && options.getAuthClientSecret() != null && options.getAuthClientSecret().value() != null;
    }

    public static class ComputeCredentialWithRetry
    extends ComputeCredential {
        public ComputeCredentialWithRetry(ComputeCredential.Builder builder) {
            super(builder);
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            HttpRequest request = this.getTransport().createRequestFactory(this.getRequestInitializer()).buildGetRequest(new GenericUrl(this.getTokenServerEncodedUrl())).setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
            request.getHeaders().set("Metadata-Flavor", (Object)"Google");
            return (TokenResponse)request.execute().parseAs(TokenResponse.class);
        }
    }

    public static class GoogleCredentialWithRetry
    extends GoogleCredential {
        private static final int DEFAULT_TOKEN_EXPIRATION_SECONDS = 3600;
        private static final String GOOGLE_OAUTH2_TOKEN_AUDIENCE = "https://oauth2.googleapis.com/token";
        private static final Joiner WHITESPACE_JOINER = Joiner.on((char)' ');

        static GoogleCredentialWithRetry fromGoogleCredential(GoogleCredential credential, String tokenServerUrl) {
            GoogleCredential.Builder builder = new GoogleCredential.Builder().setServiceAccountPrivateKey(credential.getServiceAccountPrivateKey()).setServiceAccountPrivateKeyId(credential.getServiceAccountPrivateKeyId()).setServiceAccountId(credential.getServiceAccountId()).setServiceAccountUser(credential.getServiceAccountUser()).setServiceAccountScopes(credential.getServiceAccountScopes()).setTokenServerEncodedUrl(credential.getTokenServerEncodedUrl()).setTransport(credential.getTransport()).setClientAuthentication(credential.getClientAuthentication()).setJsonFactory(credential.getJsonFactory()).setClock(credential.getClock()).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer());
            GoogleCredentialWithRetry withRetry = new GoogleCredentialWithRetry(builder, tokenServerUrl);
            if (credential.getRefreshToken() != null) {
                withRetry.setRefreshToken(credential.getRefreshToken());
            }
            return withRetry;
        }

        GoogleCredentialWithRetry(GoogleCredential.Builder builder, String tokenServerUrl) {
            super(builder.setTokenServerEncodedUrl(tokenServerUrl));
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            if (this.getServiceAccountPrivateKey() == null) {
                return super.executeRefreshToken();
            }
            JsonWebSignature.Header header = new JsonWebSignature.Header().setAlgorithm("RS256").setType("JWT").setKeyId(this.getServiceAccountPrivateKeyId());
            long currentTime = this.getClock().currentTimeMillis();
            JsonWebToken.Payload payload = new JsonWebToken.Payload().setIssuer(this.getServiceAccountId()).setAudience((Object)GOOGLE_OAUTH2_TOKEN_AUDIENCE).setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L)).setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L)).setSubject(this.getServiceAccountUser());
            payload.put("scope", (Object)WHITESPACE_JOINER.join((Iterable)this.getServiceAccountScopes()));
            try {
                String assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.getServiceAccountPrivateKey(), (JsonFactory)this.getJsonFactory(), (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
                TokenRequest request = new TokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), "urn:ietf:params:oauth:grant-type:jwt-bearer").setRequestInitializer(this.getRequestInitializer());
                request.put("assertion", (Object)assertion);
                return request.execute();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(String.format("Failed to refresh token. cause=%s", e.getMessage()), e);
            }
        }
    }

    public static class CredentialHttpRetryInitializer
    implements HttpRequestInitializer {
        private final Credential credential;

        public CredentialHttpRetryInitializer() {
            this(null);
        }

        public CredentialHttpRetryInitializer(Credential credential) {
            this.credential = credential;
        }

        public void initialize(HttpRequest httpRequest) throws IOException {
            if (this.credential != null) {
                httpRequest.setInterceptor((HttpExecuteInterceptor)this.credential);
            }
            httpRequest.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
            httpRequest.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()));
        }
    }
}

