/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util.interceptors;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.UUID;

@VisibleForTesting
public final class InvocationIdInterceptor
implements HttpExecuteInterceptor {
    public static final String GCCL_INVOCATION_ID_PREFIX = "gccl-invocation-id/";
    public static final String GOOG_API_CLIENT = "x-goog-api-client";
    private final HttpExecuteInterceptor interceptor;

    public InvocationIdInterceptor(HttpExecuteInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void intercept(HttpRequest request) throws IOException {
        HttpHeaders headers;
        String existing;
        if (this.interceptor != null) {
            this.interceptor.intercept(request);
        }
        if (InvocationIdInterceptor.isInvocationIdPresent(existing = (String)(headers = request.getHeaders()).get((Object)GOOG_API_CLIENT))) {
            return;
        }
        String signatureKey = "Signature=";
        String builtURL = request.getUrl().build();
        if (!builtURL.contains("Signature=")) {
            UUID invocationId = UUID.randomUUID();
            String invocationEntry = GCCL_INVOCATION_ID_PREFIX + invocationId;
            String newValue = existing != null && !existing.isEmpty() ? existing + " " + invocationEntry : invocationEntry;
            headers.set(GOOG_API_CLIENT, (Object)newValue);
        }
    }

    private static boolean isInvocationIdPresent(String apiClientHeader) {
        return apiClientHeader != null && apiClientHeader.contains(GCCL_INVOCATION_ID_PREFIX);
    }
}

