/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialConfiguration {
    protected static final Logger LOG = LoggerFactory.getLogger(CredentialConfiguration.class);
    private Optional<Boolean> isServiceAccountEnabled = Optional.absent();
    private String serviceAccountEmail = null;
    private String serviceAccountKeyFile = null;
    private String serviceAccountJsonKeyFile = null;
    private String clientId = null;
    private String clientSecret = null;
    private String oAuthCredentialFile = null;
    private boolean nullCredentialEnabled = false;
    private CredentialFactory credentialFactory = new CredentialFactory();

    public Credential getCredential(List<String> scopes) throws IOException, GeneralSecurityException {
        if (this.isServiceAccountEnabled()) {
            LOG.debug("Using service account credentials");
            if (this.shouldUseMetadataService()) {
                LOG.debug("Getting service account credentials from meta data service.");
                return this.credentialFactory.getCredentialFromMetadataServiceAccount();
            }
            if (!Strings.isNullOrEmpty((String)this.serviceAccountJsonKeyFile)) {
                LOG.debug("Using JSON keyfile {}", (Object)this.serviceAccountJsonKeyFile);
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.serviceAccountKeyFile), (Object)"A P12 key file may not be specified at the same time as a JSON key file.");
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.serviceAccountEmail), (Object)"Service account email may not be specified at the same time as a JSON key file.");
                return this.credentialFactory.getCredentialFromJsonKeyFile(this.serviceAccountJsonKeyFile, scopes);
            }
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.serviceAccountEmail) ? 1 : 0) != 0, (Object)"Email must be set if using service account auth and a key file is specified.");
            LOG.debug("Using service account email {} and private key file {}", (Object)this.serviceAccountEmail, (Object)this.serviceAccountKeyFile);
            return this.credentialFactory.getCredentialFromPrivateKeyServiceAccount(this.serviceAccountEmail, this.serviceAccountKeyFile, scopes);
        }
        if (this.oAuthCredentialFile != null && this.clientId != null && this.clientSecret != null) {
            LOG.debug("Using installed app credentials in file {}", (Object)this.oAuthCredentialFile);
            return this.credentialFactory.getCredentialFromFileCredentialStoreForInstalledApp(this.clientId, this.clientSecret, this.oAuthCredentialFile, scopes);
        }
        if (this.nullCredentialEnabled) {
            LOG.warn("Allowing null credentials for unit testing. This should not be used in production");
            return null;
        }
        LOG.error("Credential configuration is not valid. Configuration: {}", (Object)this);
        throw new IllegalStateException("No valid credential configuration discovered.");
    }

    public boolean shouldUseMetadataService() {
        return this.serviceAccountKeyFile == null && this.serviceAccountJsonKeyFile == null;
    }

    public String getOAuthCredentialFile() {
        return this.oAuthCredentialFile;
    }

    public void setOAuthCredentialFile(String oAuthCredentialFile) {
        this.oAuthCredentialFile = oAuthCredentialFile;
    }

    public boolean isNullCredentialEnabled() {
        return this.nullCredentialEnabled;
    }

    public void setNullCredentialEnabled(boolean nullCredentialEnabled) {
        this.nullCredentialEnabled = nullCredentialEnabled;
    }

    public boolean isServiceAccountEnabled() {
        return !this.isServiceAccountEnabled.isPresent() || (Boolean)this.isServiceAccountEnabled.get() != false;
    }

    public void setEnableServiceAccounts(boolean enableServiceAccounts) {
        this.isServiceAccountEnabled = Optional.of((Object)enableServiceAccounts);
    }

    public String getServiceAccountEmail() {
        return this.serviceAccountEmail;
    }

    public void setServiceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
    }

    public String getServiceAccountKeyFile() {
        return this.serviceAccountKeyFile;
    }

    public void setServiceAccountKeyFile(String serviceAccountKeyFile) {
        this.serviceAccountKeyFile = serviceAccountKeyFile;
    }

    public String getServiceAccountJsonKeyFile() {
        return this.serviceAccountJsonKeyFile;
    }

    public void setServiceAccountJsonKeyFile(String serviceAccountJsonKeyFile) {
        this.serviceAccountJsonKeyFile = serviceAccountJsonKeyFile;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @VisibleForTesting
    void setCredentialFactory(CredentialFactory factory) {
        this.credentialFactory = factory;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("isServiceAccountEnabled: ").append(this.isServiceAccountEnabled()).append('\n');
        builder.append("serviceAccountEmail: ").append(this.getServiceAccountEmail()).append('\n');
        builder.append("serviceAccountKeyfile: ").append(this.getServiceAccountKeyFile()).append('\n');
        builder.append("clientId: ").append(this.getClientId()).append('\n');
        if (!Strings.isNullOrEmpty((String)this.getClientSecret())) {
            builder.append("clientSecret: Provided, but not displayed");
        } else {
            builder.append("clientSecret: Not provided");
        }
        builder.append('\n');
        builder.append("oAuthCredentialFile: ").append(this.getOAuthCredentialFile()).append('\n');
        builder.append("isNullCredentialEnabled: ").append(this.isNullCredentialEnabled());
        return builder.toString();
    }
}

