package com.google.cloud.hadoop.gcsio;

import com.google.auth.Credentials;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StorageClientProviderCacheKey extends StorageClientProviderCacheKey {

  private final boolean isTracingEnabled;

  @Nullable
  private final Credentials credentials;

  private final boolean isDownScopingEnabled;

  @Nullable
  private final ImmutableMap<String, String> httpHeaders;

  @Nullable
  private final AsyncWriteChannelOptions writeChannelOptions;

  @Nullable
  private final String projectId;

  private final boolean isDirectPathPreferred;

  private AutoValue_StorageClientProviderCacheKey(
      boolean isTracingEnabled,
      @Nullable Credentials credentials,
      boolean isDownScopingEnabled,
      @Nullable ImmutableMap<String, String> httpHeaders,
      @Nullable AsyncWriteChannelOptions writeChannelOptions,
      @Nullable String projectId,
      boolean isDirectPathPreferred) {
    this.isTracingEnabled = isTracingEnabled;
    this.credentials = credentials;
    this.isDownScopingEnabled = isDownScopingEnabled;
    this.httpHeaders = httpHeaders;
    this.writeChannelOptions = writeChannelOptions;
    this.projectId = projectId;
    this.isDirectPathPreferred = isDirectPathPreferred;
  }

  @Override
  public boolean getIsTracingEnabled() {
    return isTracingEnabled;
  }

  @Nullable
  @Override
  public Credentials getCredentials() {
    return credentials;
  }

  @Override
  public boolean getIsDownScopingEnabled() {
    return isDownScopingEnabled;
  }

  @Nullable
  @Override
  public ImmutableMap<String, String> getHttpHeaders() {
    return httpHeaders;
  }

  @Nullable
  @Override
  public AsyncWriteChannelOptions getWriteChannelOptions() {
    return writeChannelOptions;
  }

  @Nullable
  @Override
  public String getProjectId() {
    return projectId;
  }

  @Override
  public boolean getIsDirectPathPreferred() {
    return isDirectPathPreferred;
  }

  @Override
  public String toString() {
    return "StorageClientProviderCacheKey{"
        + "isTracingEnabled=" + isTracingEnabled + ", "
        + "credentials=" + credentials + ", "
        + "isDownScopingEnabled=" + isDownScopingEnabled + ", "
        + "httpHeaders=" + httpHeaders + ", "
        + "writeChannelOptions=" + writeChannelOptions + ", "
        + "projectId=" + projectId + ", "
        + "isDirectPathPreferred=" + isDirectPathPreferred
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StorageClientProviderCacheKey) {
      StorageClientProviderCacheKey that = (StorageClientProviderCacheKey) o;
      return this.isTracingEnabled == that.getIsTracingEnabled()
          && (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials()))
          && this.isDownScopingEnabled == that.getIsDownScopingEnabled()
          && (this.httpHeaders == null ? that.getHttpHeaders() == null : this.httpHeaders.equals(that.getHttpHeaders()))
          && (this.writeChannelOptions == null ? that.getWriteChannelOptions() == null : this.writeChannelOptions.equals(that.getWriteChannelOptions()))
          && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId()))
          && this.isDirectPathPreferred == that.getIsDirectPathPreferred();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= isTracingEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (credentials == null) ? 0 : credentials.hashCode();
    h$ *= 1000003;
    h$ ^= isDownScopingEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (httpHeaders == null) ? 0 : httpHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= (writeChannelOptions == null) ? 0 : writeChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= (projectId == null) ? 0 : projectId.hashCode();
    h$ *= 1000003;
    h$ ^= isDirectPathPreferred ? 1231 : 1237;
    return h$;
  }

  @Override
  public StorageClientProviderCacheKey.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends StorageClientProviderCacheKey.Builder {
    private boolean isTracingEnabled;
    private Credentials credentials;
    private boolean isDownScopingEnabled;
    private ImmutableMap<String, String> httpHeaders;
    private AsyncWriteChannelOptions writeChannelOptions;
    private String projectId;
    private boolean isDirectPathPreferred;
    private byte set$0;
    Builder() {
    }
    private Builder(StorageClientProviderCacheKey source) {
      this.isTracingEnabled = source.getIsTracingEnabled();
      this.credentials = source.getCredentials();
      this.isDownScopingEnabled = source.getIsDownScopingEnabled();
      this.httpHeaders = source.getHttpHeaders();
      this.writeChannelOptions = source.getWriteChannelOptions();
      this.projectId = source.getProjectId();
      this.isDirectPathPreferred = source.getIsDirectPathPreferred();
      set$0 = (byte) 7;
    }
    @Override
    public StorageClientProviderCacheKey.Builder setIsTracingEnabled(boolean isTracingEnabled) {
      this.isTracingEnabled = isTracingEnabled;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public StorageClientProviderCacheKey.Builder setCredentials(Credentials credentials) {
      this.credentials = credentials;
      return this;
    }
    @Override
    public StorageClientProviderCacheKey.Builder setIsDownScopingEnabled(boolean isDownScopingEnabled) {
      this.isDownScopingEnabled = isDownScopingEnabled;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public StorageClientProviderCacheKey.Builder setHttpHeaders(ImmutableMap<String, String> httpHeaders) {
      this.httpHeaders = httpHeaders;
      return this;
    }
    @Override
    public StorageClientProviderCacheKey.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
      this.writeChannelOptions = writeChannelOptions;
      return this;
    }
    @Override
    public StorageClientProviderCacheKey.Builder setProjectId(String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    public StorageClientProviderCacheKey.Builder setIsDirectPathPreferred(boolean isDirectPathPreferred) {
      this.isDirectPathPreferred = isDirectPathPreferred;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public StorageClientProviderCacheKey build() {
      if (set$0 != 7) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" isTracingEnabled");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" isDownScopingEnabled");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" isDirectPathPreferred");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_StorageClientProviderCacheKey(
          this.isTracingEnabled,
          this.credentials,
          this.isDownScopingEnabled,
          this.httpHeaders,
          this.writeChannelOptions,
          this.projectId,
          this.isDirectPathPreferred);
    }
  }

}
