/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.CustomFileRange;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FsBenchmark
extends Configured
implements Tool {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new FsBenchmark(), (String[])args);
        System.exit(result);
    }

    private FsBenchmark() {
        super(new Configuration());
    }

    public int run(String[] args) throws IOException {
        String cmd = args[0];
        Map cmdArgs = ImmutableList.copyOf((Object[])args).subList(1, args.length).stream().collect(Collectors.toMap(arg -> arg.split("=")[0], arg -> arg.contains("=") ? arg.split("=")[1] : "", (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, HashMap::new));
        URI testUri = new Path(cmdArgs.getOrDefault("--file", (String)cmdArgs.get("--bucket"))).toUri();
        FileSystem fs = FileSystem.get((URI)testUri, (Configuration)this.getConf());
        int res = 0;
        try {
            res = this.runWithInstrumentation(fs, cmd, cmdArgs);
        }
        catch (Throwable e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Failed to execute '%s' command with arguments: %s", (Object)cmd, (Object)cmdArgs);
        }
        System.out.println(res == 0 ? "Success!" : "Failure!");
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runWithInstrumentation(FileSystem fs, String cmd, Map<String, String> cmdArgs) {
        int n;
        FileSystem.Statistics statistics = (FileSystem.Statistics)FileSystem.getStatistics().get(fs.getScheme());
        Optional<Object> progressReporter = Optional.empty();
        Object statsFuture = Futures.immediateVoidFuture();
        if (cmdArgs.containsKey("--verbose")) {
            progressReporter = Optional.of(Executors.newSingleThreadScheduledExecutor());
            statsFuture = ((ScheduledExecutorService)progressReporter.get()).scheduleWithFixedDelay(() -> System.out.printf("Progress stats: %s%n", statistics), Long.parseLong(cmdArgs.getOrDefault("--verbose-delay-seconds", "5")), Long.parseLong(cmdArgs.getOrDefault("--verbose-interval-seconds", "15")), TimeUnit.SECONDS);
        }
        try {
            n = this.runInternal(fs, cmd, cmdArgs);
            statsFuture.cancel(true);
        }
        catch (Throwable throwable) {
            statsFuture.cancel(true);
            progressReporter.ifPresent(ExecutorService::shutdownNow);
            System.out.printf("Final stats: %s%n", statistics);
            throw throwable;
        }
        progressReporter.ifPresent(ExecutorService::shutdownNow);
        System.out.printf("Final stats: %s%n", statistics);
        return n;
    }

    private int runInternal(FileSystem fs, String cmd, Map<String, String> cmdArgs) {
        switch (cmd) {
            case "write": {
                return this.benchmarkWrite(fs, cmdArgs);
            }
            case "read": {
                return this.benchmarkRead(fs, cmdArgs);
            }
            case "random-read": {
                return this.benchmarkRandomRead(fs, cmdArgs);
            }
            case "vectored-read": {
                return this.benchmarkVectoredRead(fs, cmdArgs);
            }
        }
        throw new IllegalArgumentException("Unknown command: " + cmd);
    }

    private int benchmarkWrite(FileSystem fs, Map<String, String> args) {
        if (args.size() < 1) {
            System.err.println("Usage: write --file=gs://${BUCKET}/path/to/test/dir/ [--total-size=<file size to write in bytes>] [--write-size=<write buffer size in bytes>] [--num-writes=<number of times to fully write test file>] [--num-threads=<number of threads to run test>]");
            return 1;
        }
        Path testFile = new Path(args.get("--file"));
        this.benchmarkWrite(fs, testFile, Integer.parseInt(args.getOrDefault("--write-size", String.valueOf(1024))), Integer.parseInt(args.getOrDefault("--num-writes", String.valueOf(1))), Integer.parseInt(args.getOrDefault("--num-threads", String.valueOf(1))), Long.parseLong(args.getOrDefault("--total-size", String.valueOf(10240))));
        return 0;
    }

    private void benchmarkWrite(FileSystem fs, Path testFile, int writeSize, int numWrites, int numThreads, long totalSize) {
        System.out.printf("Running write test using %d bytes writes to fully write '%s' file %d times in %d threads%n", writeSize, testFile, numWrites, numThreads);
        Set<LongSummaryStatistics> writeFileBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> writeFileTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> writeCallBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> writeCallTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        String tempFilenameKey = UUID.randomUUID().toString().substring(0, 6);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch initLatch = new CountDownLatch(numThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(numThreads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(numThreads);
        int i = 0;
        while (i < numThreads) {
            int fileCounter = i++;
            futures.add(executor.submit(() -> {
                LongSummaryStatistics writeFileBytes = FsBenchmark.newLongSummaryStatistics(writeFileBytesList);
                LongSummaryStatistics writeFileTimeNs = FsBenchmark.newLongSummaryStatistics(writeFileTimeNsList);
                LongSummaryStatistics writeCallBytes = FsBenchmark.newLongSummaryStatistics(writeCallBytesList);
                LongSummaryStatistics writeCallTimeNs = FsBenchmark.newLongSummaryStatistics(writeCallTimeNsList);
                byte[] writeBuffer = new byte[writeSize];
                Random r = new Random();
                r.nextBytes(writeBuffer);
                String random_file = String.format("/test-%s-%03d.bin", tempFilenameKey, fileCounter);
                Path testFileToIO = new Path(testFile.toString() + random_file);
                initLatch.countDown();
                startLatch.await();
                try {
                    for (int j = 0; j < numWrites; ++j) {
                        try (FSDataOutputStream output = fs.create(testFileToIO);){
                            long writeStart = System.nanoTime();
                            long fileBytesWrite = 0L;
                            do {
                                long writeCallStart = System.nanoTime();
                                output.write(writeBuffer);
                                writeCallBytes.accept(writeSize);
                                writeCallTimeNs.accept(System.nanoTime() - writeCallStart);
                            } while ((fileBytesWrite += (long)writeSize) < totalSize);
                            writeFileBytes.accept(fileBytesWrite);
                            writeFileTimeNs.accept(System.nanoTime() - writeStart);
                            continue;
                        }
                    }
                }
                finally {
                    stopLatch.countDown();
                }
                return null;
            }));
        }
        executor.shutdown();
        FsBenchmark.awaitUnchecked(initLatch);
        long startTimeNs = System.nanoTime();
        startLatch.countDown();
        FsBenchmark.awaitUnchecked(stopLatch);
        long runtimeNs = System.nanoTime() - startTimeNs;
        futures.forEach(Futures::getUnchecked);
        FsBenchmark.printTimeStats("Write call time", writeCallTimeNsList);
        FsBenchmark.printSizeStats("Write call data", writeCallBytesList);
        FsBenchmark.printThroughputStats("Write call throughput", writeCallTimeNsList, writeCallBytesList);
        FsBenchmark.printTimeStats("Write file time", writeFileTimeNsList);
        FsBenchmark.printSizeStats("Write file data", writeFileBytesList);
        FsBenchmark.printThroughputStats("Write file throughput", writeFileTimeNsList, writeFileBytesList);
        System.out.printf("Write average throughput (MiB/s): %.3f%n", FsBenchmark.bytesToMebibytes(FsBenchmark.combineStats(writeFileBytesList).getSum()) / FsBenchmark.nanosToSeconds(runtimeNs));
    }

    private int benchmarkRead(FileSystem fs, Map<String, String> args) {
        if (args.size() < 1) {
            System.err.println("Usage: read --file=gs://${BUCKET}/path/to/test/object [--read-size=<read buffer size in bytes>] [--num-reads=<number of times to fully read test file>] [--num-threads=<number of threads to run test>]");
            return 1;
        }
        Path testFile = new Path(args.get("--file"));
        FsBenchmark.warmup(args, () -> this.benchmarkRead(fs, testFile, 1024, 1, 2));
        this.benchmarkRead(fs, testFile, Integer.parseInt(args.getOrDefault("--read-size", String.valueOf(1024))), Integer.parseInt(args.getOrDefault("--num-reads", String.valueOf(1))), Integer.parseInt(args.getOrDefault("--num-threads", String.valueOf(1))));
        return 0;
    }

    private void benchmarkRead(FileSystem fs, Path testFile, int readSize, int numReads, int numThreads) {
        System.out.printf("Running read test using %d bytes reads to fully read '%s' file %d times in %d threads%n", readSize, testFile, numReads, numThreads);
        Set<LongSummaryStatistics> readFileBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readFileTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readCallBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readCallTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch initLatch = new CountDownLatch(numThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(numThreads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            futures.add(executor.submit(() -> {
                LongSummaryStatistics readFileBytes = FsBenchmark.newLongSummaryStatistics(readFileBytesList);
                LongSummaryStatistics readFileTimeNs = FsBenchmark.newLongSummaryStatistics(readFileTimeNsList);
                LongSummaryStatistics readCallBytes = FsBenchmark.newLongSummaryStatistics(readCallBytesList);
                LongSummaryStatistics readCallTimeNs = FsBenchmark.newLongSummaryStatistics(readCallTimeNsList);
                byte[] readBuffer = new byte[readSize];
                initLatch.countDown();
                startLatch.await();
                try {
                    for (int j = 0; j < numReads; ++j) {
                        try (FSDataInputStream input = fs.open(testFile);){
                            int bytesRead;
                            long readStart = System.nanoTime();
                            long fileBytesRead = 0L;
                            do {
                                long readCallStart = System.nanoTime();
                                bytesRead = input.read(readBuffer);
                                if (bytesRead > 0) {
                                    fileBytesRead += (long)bytesRead;
                                    readCallBytes.accept(bytesRead);
                                }
                                readCallTimeNs.accept(System.nanoTime() - readCallStart);
                            } while (bytesRead >= 0);
                            readFileBytes.accept(fileBytesRead);
                            readFileTimeNs.accept(System.nanoTime() - readStart);
                            continue;
                        }
                    }
                }
                finally {
                    stopLatch.countDown();
                }
                return null;
            }));
        }
        executor.shutdown();
        FsBenchmark.awaitUnchecked(initLatch);
        long startTimeNs = System.nanoTime();
        startLatch.countDown();
        FsBenchmark.awaitUnchecked(stopLatch);
        long runtimeNs = System.nanoTime() - startTimeNs;
        futures.forEach(Futures::getUnchecked);
        FsBenchmark.printTimeStats("Read call time", readCallTimeNsList);
        FsBenchmark.printSizeStats("Read call data", readCallBytesList);
        FsBenchmark.printThroughputStats("Read call throughput", readCallTimeNsList, readCallBytesList);
        FsBenchmark.printTimeStats("Read file time", readFileTimeNsList);
        FsBenchmark.printSizeStats("Read file data", readFileBytesList);
        FsBenchmark.printThroughputStats("Read file throughput", readFileTimeNsList, readFileBytesList);
        System.out.printf("Read average throughput (MiB/s): %.3f%n", FsBenchmark.bytesToMebibytes(FsBenchmark.combineStats(readFileBytesList).getSum()) / FsBenchmark.nanosToSeconds(runtimeNs));
    }

    private int benchmarkRandomRead(FileSystem fs, Map<String, String> args) {
        if (args.size() < 1) {
            System.err.println("Usage: random-read --file=gs://${BUCKET}/path/to/test/object [--num-open=<number of file open>] [--read-size=<read buffer size in bytes>] [--num-reads=<number of random reads per file open>] [--num-threads=<number of threads to run test>]");
            return 1;
        }
        Path testFile = new Path(args.get("--file"));
        FsBenchmark.warmup(args, () -> this.benchmarkRandomRead(fs, testFile, 5, 1024, 20, 5));
        this.benchmarkRandomRead(fs, testFile, Integer.parseInt(args.getOrDefault("--num-open", String.valueOf(1))), Integer.parseInt(args.getOrDefault("--read-size", String.valueOf(1024))), Integer.parseInt(args.getOrDefault("--num-reads", String.valueOf(100))), Integer.parseInt(args.getOrDefault("--num-threads", String.valueOf(1))));
        return 0;
    }

    private void benchmarkRandomRead(FileSystem fs, Path testFile, int numOpen, int readSize, int numReads, int numThreads) {
        System.out.printf("Running random read test that reads %d bytes from '%s' file %d times per %d open operations in %d threads%n", readSize, testFile, numReads, numOpen, numThreads);
        Set<LongSummaryStatistics> openLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> seekLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> closeLatencyNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readFileBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readFileTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch initLatch = new CountDownLatch(numThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(numThreads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            futures.add(executor.submit(() -> {
                FileStatus fileStatus = fs.getFileStatus(testFile);
                long fileSize = fileStatus.getLen();
                long maxReadPositionExclusive = fileSize - (long)readSize + 1L;
                LongSummaryStatistics openLatencyNs = FsBenchmark.newLongSummaryStatistics(openLatencyNsList);
                LongSummaryStatistics seekLatencyNs = FsBenchmark.newLongSummaryStatistics(seekLatencyNsList);
                LongSummaryStatistics readLatencyNs = FsBenchmark.newLongSummaryStatistics(readLatencyNsList);
                LongSummaryStatistics closeLatencyNs = FsBenchmark.newLongSummaryStatistics(closeLatencyNsList);
                LongSummaryStatistics readFileBytes = FsBenchmark.newLongSummaryStatistics(readFileBytesList);
                LongSummaryStatistics readFileTimeNs = FsBenchmark.newLongSummaryStatistics(readFileTimeNsList);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                byte[] readBuffer = new byte[readSize];
                initLatch.countDown();
                startLatch.await();
                try {
                    for (int j = 0; j < numOpen; ++j) {
                        try {
                            long seekPos = random.nextLong(maxReadPositionExclusive);
                            long openStart = System.nanoTime();
                            long fileBytesRead = 0L;
                            FSDataInputStream input = fs.open(testFile);
                            openLatencyNs.accept(System.nanoTime() - openStart);
                            long readFsStart = System.nanoTime();
                            try {
                                for (int k = 0; k < numReads; ++k) {
                                    long seekStart = System.nanoTime();
                                    input.seek(seekPos);
                                    seekLatencyNs.accept(System.nanoTime() - seekStart);
                                    long readStart = System.nanoTime();
                                    int numRead = input.read(readBuffer);
                                    readLatencyNs.accept(System.nanoTime() - readStart);
                                    if (numRead != readSize) {
                                        System.err.printf("Read %d bytes from %d bytes at offset %d!%n", numRead, readSize, seekPos);
                                    }
                                    fileBytesRead += (long)numRead;
                                }
                                continue;
                            }
                            finally {
                                readFileTimeNs.accept(System.nanoTime() - readFsStart);
                                readFileBytes.accept(fileBytesRead);
                                long closeStart = System.nanoTime();
                                input.close();
                                closeLatencyNs.accept(System.nanoTime() - closeStart);
                            }
                        }
                        catch (Throwable e) {
                            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Failed random read from '%s'", (Object)testFile);
                        }
                    }
                }
                finally {
                    stopLatch.countDown();
                }
                return null;
            }));
        }
        executor.shutdown();
        FsBenchmark.awaitUnchecked(initLatch);
        long startTime = System.nanoTime();
        startLatch.countDown();
        FsBenchmark.awaitUnchecked(stopLatch);
        double runtimeSeconds = FsBenchmark.nanosToSeconds(System.nanoTime() - startTime);
        long operations = FsBenchmark.combineStats(readLatencyNsList).getCount();
        futures.forEach(Futures::getUnchecked);
        FsBenchmark.printTimeStats("Open latency ", FsBenchmark.combineStats(openLatencyNsList));
        FsBenchmark.printTimeStats("Seek latency ", FsBenchmark.combineStats(seekLatencyNsList));
        FsBenchmark.printTimeStats("Read latency ", FsBenchmark.combineStats(readLatencyNsList));
        FsBenchmark.printTimeStats("Close latency", FsBenchmark.combineStats(closeLatencyNsList));
        FsBenchmark.printThroughputStats("Read file throughput", readFileTimeNsList, readFileBytesList);
        System.out.printf("Average QPS: %.3f (%d in total %.3fs)%n", (double)operations / runtimeSeconds, operations, runtimeSeconds);
        System.out.printf("Read average throughput (MiB/s): %.3f%n", FsBenchmark.bytesToMebibytes(FsBenchmark.combineStats(readFileBytesList).getSum()) / runtimeSeconds);
    }

    private int benchmarkVectoredRead(FileSystem fs, Map<String, String> args) {
        if (args.size() < 1) {
            System.err.println("Usage: vectored-read --file=gs://${BUCKET}/path/to/test/dir/ [--num-reads=<number of ranges read from the file>] [--num-threads=<number of threads to run test>]");
            return 1;
        }
        Path testFile = new Path(args.get("--file"));
        FsBenchmark.warmup(args, () -> this.benchmarkVectoredRead(fs, testFile, 100, 3));
        this.benchmarkVectoredRead(fs, testFile, Integer.parseInt(args.getOrDefault("--num-reads", String.valueOf(100))), Integer.parseInt(args.getOrDefault("--num-threads", String.valueOf(3))));
        return 0;
    }

    private void benchmarkVectoredRead(FileSystem fs, Path testFile, int numOfReads, int numOfThreads) {
        System.out.printf("Running vectored read test using file %s which will be read %d times in %d threads.\n", testFile, numOfReads, numOfThreads);
        Set<LongSummaryStatistics> readFileBytesList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> readFileTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> openTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<LongSummaryStatistics> closeTimeNsList = Collections.newSetFromMap(new ConcurrentHashMap());
        ExecutorService executor = Executors.newFixedThreadPool(numOfThreads);
        CountDownLatch initLatch = new CountDownLatch(numOfThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(numOfThreads);
        ArrayList futures = new ArrayList(numOfThreads);
        long fileSize = this.printAndReturnFileSize(fs, testFile, numOfReads);
        for (int i = 0; i < numOfThreads; ++i) {
            futures.add(executor.submit(() -> {
                LongSummaryStatistics readFileBytes = FsBenchmark.newLongSummaryStatistics(readFileBytesList);
                LongSummaryStatistics readFileTimeNs = FsBenchmark.newLongSummaryStatistics(readFileTimeNsList);
                LongSummaryStatistics openTimeNs = FsBenchmark.newLongSummaryStatistics(openTimeNsList);
                LongSummaryStatistics closeTimeNs = FsBenchmark.newLongSummaryStatistics(closeTimeNsList);
                initLatch.countDown();
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                try {
                    try {
                        long openStart = System.nanoTime();
                        FSDataInputStream input = fs.open(testFile);
                        openTimeNs.accept(System.nanoTime() - openStart);
                        long readFsStart = System.nanoTime();
                        IntFunction<ByteBuffer> allocator = length -> ByteBuffer.allocateDirect(length);
                        List<? extends FileRange> ranges = this.getRanges(fileSize, numOfReads);
                        input.readVectored(ranges, allocator);
                        ranges.forEach(range -> {
                            try {
                                ByteBuffer data = (ByteBuffer)range.getData().get(30L, TimeUnit.SECONDS);
                                readFileTimeNs.accept(System.nanoTime() - readFsStart);
                                readFileBytes.accept(range.getLength());
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException e) {
                                throw new RuntimeException(e);
                            }
                        });
                        long closeStart = System.nanoTime();
                        input.close();
                        closeTimeNs.accept(System.nanoTime() - closeStart);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    stopLatch.countDown();
                }
            }));
        }
        executor.shutdown();
        FsBenchmark.awaitUnchecked(initLatch);
        long startTime = System.nanoTime();
        startLatch.countDown();
        FsBenchmark.awaitUnchecked(stopLatch);
        double runtimeSeconds = FsBenchmark.nanosToSeconds(System.nanoTime() - startTime);
        long operations = FsBenchmark.combineStats(readFileTimeNsList).getCount();
        futures.forEach(Futures::getUnchecked);
        this.printReadVectoredStats(readFileBytesList, readFileTimeNsList, openTimeNsList, closeTimeNsList, runtimeSeconds, operations);
    }

    private void printReadVectoredStats(Set<LongSummaryStatistics> readFileBytesList, Set<LongSummaryStatistics> readFileTimeNsList, Set<LongSummaryStatistics> openTimeNsList, Set<LongSummaryStatistics> closeTimeNsList, double runtimeSeconds, long operations) {
        FsBenchmark.printSizeStats("Read Bytes ", FsBenchmark.combineStats(readFileBytesList));
        FsBenchmark.printTimeStats("Read latency ", FsBenchmark.combineStats(readFileTimeNsList));
        FsBenchmark.printTimeStats("Open latency ", FsBenchmark.combineStats(openTimeNsList));
        FsBenchmark.printTimeStats("Close latency ", FsBenchmark.combineStats(closeTimeNsList));
        FsBenchmark.printThroughputStats("Read file throughput", readFileTimeNsList, readFileBytesList);
        System.out.printf("Average QPS: %.3f (%d in total %.3fs)%n", (double)operations / runtimeSeconds, operations, runtimeSeconds);
        System.out.printf("Read average throughput (MiB/s): %.3f%n", FsBenchmark.bytesToMebibytes(FsBenchmark.combineStats(readFileBytesList).getSum()) / runtimeSeconds);
    }

    private long printAndReturnFileSize(FileSystem fs, Path testFile, int numOfReads) {
        FileStatus fileStatus = null;
        try {
            fileStatus = fs.getFileStatus(testFile);
            System.out.printf("File Size is %d and Chunk Size is %d\n", fileStatus.getLen(), fileStatus.getLen() / (long)numOfReads);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return fileStatus.getLen();
    }

    private List<? extends FileRange> getRanges(long fileSize, int numberOfTimesFileRead) {
        long chunkSize = fileSize / (long)numberOfTimesFileRead;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<CustomFileRange> ranges = new ArrayList<CustomFileRange>();
        for (int i = 0; i < numberOfTimesFileRead; ++i) {
            long index1 = random.nextLong(chunkSize);
            long index2 = random.nextLong(chunkSize);
            int difference = Math.toIntExact(Math.abs(index2 - index1));
            long offset = chunkSize * (long)i + Long.min(index1, index2);
            ranges.add(new CustomFileRange(offset, difference));
        }
        return ranges;
    }

    private String getDecodedString(ByteBuffer data) {
        Charset charset = StandardCharsets.UTF_8;
        return charset.decode(data).toString();
    }

    private static void warmup(Map<String, String> args, Runnable warmupFn) {
        if (args.containsKey("--no-warmup")) {
            System.out.println("=== Skipping warmup ===");
            return;
        }
        System.out.println("=== Running warmup ===");
        ExecutorService warmupExecutor = Executors.newSingleThreadExecutor();
        try {
            warmupExecutor.submit(warmupFn).get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Benchmark warmup failed", e);
        }
        finally {
            warmupExecutor.shutdownNow();
        }
        System.out.println("=== Finished warmup ===\n");
    }

    private static LongSummaryStatistics newLongSummaryStatistics(Collection<LongSummaryStatistics> openLatencyNsList) {
        LongSummaryStatistics openLatencyNs = new LongSummaryStatistics();
        openLatencyNsList.add(openLatencyNs);
        return openLatencyNs;
    }

    private static void awaitUnchecked(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("CountDownLatch.await interrupted", e);
        }
    }

    private static void printTimeStats(String name, Collection<LongSummaryStatistics> timeStats) {
        FsBenchmark.printTimeStats(name, FsBenchmark.combineStats(timeStats));
    }

    private static void printTimeStats(String name, LongSummaryStatistics timeStats) {
        System.out.printf("%s (ms): min=%.5f, average=%.5f, max=%.5f (count=%d)%n", name, FsBenchmark.nanosToMillis(timeStats.getMin()), FsBenchmark.nanosToMillis(timeStats.getAverage()), FsBenchmark.nanosToMillis(timeStats.getMax()), timeStats.getCount());
    }

    private static void printSizeStats(String name, Collection<LongSummaryStatistics> sizeStats) {
        FsBenchmark.printSizeStats(name, FsBenchmark.combineStats(sizeStats));
    }

    private static void printSizeStats(String name, LongSummaryStatistics sizeStats) {
        System.out.printf("%s (MiB): min=%.5f, average=%.5f, max=%.5f (count=%d)%n", name, FsBenchmark.bytesToMebibytes(sizeStats.getMin()), FsBenchmark.bytesToMebibytes(sizeStats.getAverage()), FsBenchmark.bytesToMebibytes(sizeStats.getMax()), sizeStats.getCount());
    }

    private static void printThroughputStats(String name, Collection<LongSummaryStatistics> timeStats, Collection<LongSummaryStatistics> sizeStats) {
        FsBenchmark.printThroughputStats(name, FsBenchmark.combineStats(timeStats), FsBenchmark.combineStats(sizeStats).getAverage());
    }

    private static void printThroughputStats(String name, LongSummaryStatistics timeStats, double bytesProcessed) {
        System.out.printf("%s (MiB/s): min=%.3f, average=%.3f, max=%.3f (count=%d)%n", name, FsBenchmark.bytesToMebibytes(bytesProcessed) / FsBenchmark.nanosToSeconds(timeStats.getMax()), FsBenchmark.bytesToMebibytes(bytesProcessed) / FsBenchmark.nanosToSeconds(timeStats.getAverage()), FsBenchmark.bytesToMebibytes(bytesProcessed) / FsBenchmark.nanosToSeconds(timeStats.getMin()), timeStats.getCount());
    }

    private static LongSummaryStatistics combineStats(Collection<LongSummaryStatistics> stats) {
        return stats.stream().collect(LongSummaryStatistics::new, LongSummaryStatistics::combine, LongSummaryStatistics::combine);
    }

    private static double nanosToMillis(double nanos) {
        return nanos / 1000000.0;
    }

    private static double nanosToSeconds(double nanos) {
        return nanos / 1.0E9;
    }

    private static double bytesToMebibytes(double bytes) {
        return bytes / 1024.0 / 1024.0;
    }
}

