/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.common.base.MoreObjects;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;

abstract class AbstractGhfsStatisticsSource
implements IOStatisticsSource,
DurationTrackerFactory {
    private IOStatisticsStore ioStatistics;

    protected AbstractGhfsStatisticsSource() {
    }

    protected void setIOStatistics(IOStatisticsStore ioStatistics) {
        this.ioStatistics = ioStatistics;
    }

    public long incrementCounter(String name) {
        return this.incrementCounter(name, 1L);
    }

    public long incrementCounter(String name, long value) {
        return this.ioStatistics.incrementCounter(name, value);
    }

    public Long lookupCounterValue(String name) {
        return (Long)this.ioStatistics.counters().get(name);
    }

    public Long lookupGaugeValue(String name) {
        return (Long)this.ioStatistics.gauges().get(name);
    }

    public long incrementGauge(String name, long v) {
        return this.ioStatistics.incrementGauge(name, v);
    }

    public long incrementGauge(String name) {
        return this.incrementGauge(name, 1L);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("IOStatistics ", (Object)this.ioStatistics).toString();
    }

    public DurationTracker trackDuration(String key, long count) {
        return this.ioStatistics.trackDuration(key, count);
    }

    public IOStatisticsStore getIOStatistics() {
        return this.ioStatistics;
    }
}

