/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.view.Base2ExponentialHistogramAggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.view.DefaultAggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.view.DropAggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.view.ExplicitBucketHistogramAggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.view.LastValueAggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.view.SumAggregation;
import java.util.List;

public interface Aggregation {
    public static Aggregation drop() {
        return DropAggregation.getInstance();
    }

    public static Aggregation defaultAggregation() {
        return DefaultAggregation.getInstance();
    }

    public static Aggregation sum() {
        return SumAggregation.getInstance();
    }

    public static Aggregation lastValue() {
        return LastValueAggregation.getInstance();
    }

    public static Aggregation explicitBucketHistogram() {
        return ExplicitBucketHistogramAggregation.getDefault();
    }

    public static Aggregation explicitBucketHistogram(List<Double> bucketBoundaries) {
        return ExplicitBucketHistogramAggregation.create(bucketBoundaries);
    }

    public static Aggregation base2ExponentialBucketHistogram() {
        return Base2ExponentialHistogramAggregation.getDefault();
    }

    public static Aggregation base2ExponentialBucketHistogram(int maxBuckets, int maxScale) {
        return Base2ExponentialHistogramAggregation.create(maxBuckets, maxScale);
    }
}

