/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.certprovider;

import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.EnvoyServerProtoData;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.client.Bootstrapper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.CommonTlsContextUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.DynamicSslContextProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.certprovider.CertificateProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

abstract class CertProviderSslContextProvider
extends DynamicSslContextProvider
implements CertificateProvider.Watcher {
    @Nullable
    private final CertificateProviderStore.Handle certHandle;
    @Nullable
    private final CertificateProviderStore.Handle rootCertHandle;
    @Nullable
    private final CommonTlsContext.CertificateProviderInstance certInstance;
    @Nullable
    private final CommonTlsContext.CertificateProviderInstance rootCertInstance;
    @Nullable
    protected PrivateKey savedKey;
    @Nullable
    protected List<X509Certificate> savedCertChain;
    @Nullable
    protected List<X509Certificate> savedTrustedRoots;

    protected CertProviderSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.BaseTlsContext tlsContext, CertificateProviderStore certificateProviderStore) {
        super(tlsContext, staticCertValidationContext);
        Bootstrapper.CertificateProviderInfo certProviderInstanceConfig;
        this.certInstance = certInstance;
        this.rootCertInstance = rootCertInstance;
        String certInstanceName = null;
        this.certHandle = certInstance != null && certInstance.isInitialized() ? ((certProviderInstanceConfig = CertProviderSslContextProvider.getCertProviderConfig(certProviders, certInstanceName = certInstance.getInstanceName())) == null ? null : certificateProviderStore.createOrGetProvider(certInstance.getCertificateName(), certProviderInstanceConfig.pluginName(), certProviderInstanceConfig.config(), this, true)) : null;
        this.rootCertHandle = rootCertInstance != null && rootCertInstance.isInitialized() && !rootCertInstance.getInstanceName().equals(certInstanceName) ? ((certProviderInstanceConfig = CertProviderSslContextProvider.getCertProviderConfig(certProviders, rootCertInstance.getInstanceName())) == null ? null : certificateProviderStore.createOrGetProvider(rootCertInstance.getCertificateName(), certProviderInstanceConfig.pluginName(), certProviderInstanceConfig.config(), this, true)) : null;
    }

    private static Bootstrapper.CertificateProviderInfo getCertProviderConfig(@Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, String pluginInstanceName) {
        return certProviders != null ? certProviders.get(pluginInstanceName) : null;
    }

    @Nullable
    protected static CommonTlsContext.CertificateProviderInstance getCertProviderInstance(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasTlsCertificateProviderInstance()) {
            return CommonTlsContextUtil.convert(commonTlsContext.getTlsCertificateProviderInstance());
        }
        if (commonTlsContext.hasTlsCertificateCertificateProviderInstance()) {
            return commonTlsContext.getTlsCertificateCertificateProviderInstance();
        }
        return null;
    }

    @Nullable
    protected static CertificateValidationContext getStaticValidationContext(CommonTlsContext commonTlsContext) {
        CommonTlsContext.CombinedCertificateValidationContext combinedValidationContext;
        if (commonTlsContext.hasValidationContext()) {
            return commonTlsContext.getValidationContext();
        }
        if (commonTlsContext.hasCombinedValidationContext() && (combinedValidationContext = commonTlsContext.getCombinedValidationContext()).hasDefaultValidationContext()) {
            return combinedValidationContext.getDefaultValidationContext();
        }
        return null;
    }

    @Nullable
    protected static CommonTlsContext.CertificateProviderInstance getRootCertProviderInstance(CommonTlsContext commonTlsContext) {
        CertificateValidationContext certValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
        if (certValidationContext != null && certValidationContext.hasCaCertificateProviderInstance()) {
            return CommonTlsContextUtil.convert(certValidationContext.getCaCertificateProviderInstance());
        }
        if (commonTlsContext.hasCombinedValidationContext()) {
            CommonTlsContext.CombinedCertificateValidationContext combinedValidationContext = commonTlsContext.getCombinedValidationContext();
            if (combinedValidationContext.hasValidationContextCertificateProviderInstance()) {
                return combinedValidationContext.getValidationContextCertificateProviderInstance();
            }
        } else if (commonTlsContext.hasValidationContextCertificateProviderInstance()) {
            return commonTlsContext.getValidationContextCertificateProviderInstance();
        }
        return null;
    }

    @Override
    public final void updateCertificate(PrivateKey key, List<X509Certificate> certChain) {
        this.savedKey = key;
        this.savedCertChain = certChain;
        this.updateSslContextWhenReady();
    }

    @Override
    public final void updateTrustedRoots(List<X509Certificate> trustedRoots) {
        this.savedTrustedRoots = trustedRoots;
        this.updateSslContextWhenReady();
    }

    private void updateSslContextWhenReady() {
        if (this.isMtls()) {
            if (this.savedKey != null && this.savedTrustedRoots != null) {
                this.updateSslContext();
                this.clearKeysAndCerts();
            }
        } else if (this.isClientSideTls()) {
            if (this.savedTrustedRoots != null) {
                this.updateSslContext();
                this.clearKeysAndCerts();
            }
        } else if (this.isServerSideTls() && this.savedKey != null) {
            this.updateSslContext();
            this.clearKeysAndCerts();
        }
    }

    private void clearKeysAndCerts() {
        this.savedKey = null;
        this.savedTrustedRoots = null;
        this.savedCertChain = null;
    }

    protected final boolean isMtls() {
        return this.certInstance != null && this.rootCertInstance != null;
    }

    protected final boolean isClientSideTls() {
        return this.rootCertInstance != null && this.certInstance == null;
    }

    protected final boolean isServerSideTls() {
        return this.certInstance != null && this.rootCertInstance == null;
    }

    @Override
    protected final CertificateValidationContext generateCertificateValidationContext() {
        return this.staticCertificateValidationContext;
    }

    @Override
    public final void close() {
        if (this.certHandle != null) {
            this.certHandle.close();
        }
        if (this.rootCertHandle != null) {
            this.rootCertHandle.close();
        }
    }
}

