/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.json.JsonHttpContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.StorageRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.ComposeRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageRequestFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.List;

class StorageRequestToAccessBoundaryConverter {
    StorageRequestToAccessBoundaryConverter() {
    }

    public static <RequestT extends StorageRequest<?>> List<AccessBoundary> fromStorageObjectRequest(RequestT request) {
        if (request instanceof Storage.Objects.List) {
            return StorageRequestToAccessBoundaryConverter.translateObjectListRequest((Storage.Objects.List)request);
        }
        if (request instanceof Storage.Objects.Insert) {
            return StorageRequestToAccessBoundaryConverter.translateObjectInsertRequest((Storage.Objects.Insert)request);
        }
        if (request instanceof Storage.Objects.Compose) {
            return StorageRequestToAccessBoundaryConverter.translateObjectComposeRequest((Storage.Objects.Compose)request);
        }
        if (request instanceof StorageRequestFactory.ObjectsGetMetadata) {
            return StorageRequestToAccessBoundaryConverter.translateObjectGetMetadataRequest((StorageRequestFactory.ObjectsGetMetadata)request);
        }
        if (request instanceof StorageRequestFactory.ObjectsGetData) {
            return StorageRequestToAccessBoundaryConverter.translateObjectGetDataRequest((StorageRequestFactory.ObjectsGetData)request);
        }
        if (request instanceof Storage.Objects.Delete) {
            return StorageRequestToAccessBoundaryConverter.translateObjectDeleteRequest((Storage.Objects.Delete)request);
        }
        if (request instanceof Storage.Objects.Rewrite) {
            return StorageRequestToAccessBoundaryConverter.translateObjectRewriteRequest((Storage.Objects.Rewrite)request);
        }
        if (request instanceof Storage.Objects.Copy) {
            return StorageRequestToAccessBoundaryConverter.translateObjectCopyRequest((Storage.Objects.Copy)request);
        }
        if (request instanceof Storage.Objects.Patch) {
            return StorageRequestToAccessBoundaryConverter.translateObjectPatchRequest((Storage.Objects.Patch)request);
        }
        if (request instanceof Storage.Buckets.Get) {
            return StorageRequestToAccessBoundaryConverter.translateBucketGetRequest((Storage.Buckets.Get)request);
        }
        if (request instanceof Storage.Buckets.Insert) {
            return StorageRequestToAccessBoundaryConverter.translateBucketInsertRequest((Storage.Buckets.Insert)request);
        }
        if (request instanceof Storage.Buckets.Delete) {
            return StorageRequestToAccessBoundaryConverter.translateBucketDeleteRequest((Storage.Buckets.Delete)request);
        }
        if (request instanceof Storage.Buckets.List) {
            return StorageRequestToAccessBoundaryConverter.translateBucketListRequest();
        }
        throw new InvalidParameterException("StorageRequest not used by the connector: " + request.getClass().getCanonicalName());
    }

    private static List<AccessBoundary> translateObjectListRequest(Storage.Objects.List request) {
        String prefix = request.getPrefix();
        if (Strings.isNullOrEmpty(prefix)) {
            prefix = "/";
        }
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), prefix, AccessBoundary.Action.LIST_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectInsertRequest(Storage.Objects.Insert request) {
        String path = ((StorageObject)StorageRequestToAccessBoundaryConverter.getData(request)).getName();
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), path, AccessBoundary.Action.WRITE_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectComposeRequest(Storage.Objects.Compose request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ((ComposeRequest)StorageRequestToAccessBoundaryConverter.getData(request)).getSourceObjects().forEach(source -> listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), source.getName(), AccessBoundary.Action.READ_OBJECTS)));
        listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), request.getDestinationObject(), AccessBoundary.Action.WRITE_OBJECTS));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectGetDataRequest(StorageRequestFactory.ObjectsGetData request) {
        return ImmutableList.of(AccessBoundary.create(request.getBucket(), request.getObject(), AccessBoundary.Action.READ_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectGetMetadataRequest(StorageRequestFactory.ObjectsGetMetadata request) {
        return ImmutableList.of(AccessBoundary.create(request.getBucket(), request.getObject(), AccessBoundary.Action.GET_METADATA_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectDeleteRequest(Storage.Objects.Delete request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), request.getObject(), AccessBoundary.Action.DELETE_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectRewriteRequest(Storage.Objects.Rewrite request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(AccessBoundary.create(request.getSourceBucket(), request.getSourceObject(), AccessBoundary.Action.READ_OBJECTS));
        listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), request.getDestinationObject(), AccessBoundary.Action.WRITE_OBJECTS));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectCopyRequest(Storage.Objects.Copy request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(AccessBoundary.create(request.getSourceBucket(), request.getSourceObject(), AccessBoundary.Action.READ_OBJECTS));
        listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), request.getDestinationObject(), AccessBoundary.Action.WRITE_OBJECTS));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectPatchRequest(Storage.Objects.Patch request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), request.getObject(), AccessBoundary.Action.EDIT_OBJECTS));
    }

    private static List<AccessBoundary> translateBucketGetRequest(Storage.Buckets.Get request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), "/", AccessBoundary.Action.GET_BUCKETS));
    }

    private static List<AccessBoundary> translateBucketInsertRequest(Storage.Buckets.Insert request) {
        String bucketName = ((Bucket)StorageRequestToAccessBoundaryConverter.getData(request)).getName();
        return Collections.singletonList(AccessBoundary.create(bucketName, "/", AccessBoundary.Action.CREATE_BUCKETS));
    }

    private static List<AccessBoundary> translateBucketDeleteRequest(Storage.Buckets.Delete request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), "/", AccessBoundary.Action.DELETE_BUCKETS));
    }

    private static List<AccessBoundary> translateBucketListRequest() {
        return Collections.singletonList(AccessBoundary.create("", "", AccessBoundary.Action.LIST_BUCKETS));
    }

    private static Object getData(StorageRequest<?> request) {
        return ((JsonHttpContent)request.getHttpContent()).getData();
    }
}

