/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;

class GoogleCloudStorageClientWriteChannel
implements WritableByteChannel {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final StorageResourceId resourceId;
    private WritableByteChannel writableByteChannel;

    public GoogleCloudStorageClientWriteChannel(Storage storage, GoogleCloudStorageOptions storageOptions, StorageResourceId resourceId, CreateObjectOptions createOptions) throws IOException {
        this.resourceId = resourceId;
        BlobWriteSession blobWriteSession = GoogleCloudStorageClientWriteChannel.getBlobWriteSession(storage, resourceId, createOptions, storageOptions);
        this.writableByteChannel = blobWriteSession.open();
    }

    private static BlobInfo getBlobInfo(StorageResourceId resourceId, CreateObjectOptions createOptions) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(resourceId.getBucketName(), resourceId.getObjectName(), resourceId.getGenerationId())).setContentType(createOptions.getContentType()).setContentEncoding(createOptions.getContentEncoding()).setMetadata(GoogleCloudStorageImpl.encodeMetadata(createOptions.getMetadata())).build();
        return blobInfo;
    }

    private static BlobWriteSession getBlobWriteSession(Storage storage, StorageResourceId resourceId, CreateObjectOptions createOptions, GoogleCloudStorageOptions storageOptions) {
        return storage.blobWriteSession(GoogleCloudStorageClientWriteChannel.getBlobInfo(resourceId, createOptions), GoogleCloudStorageClientWriteChannel.generateWriteOptions(createOptions, storageOptions));
    }

    private static Storage.BlobWriteOption[] generateWriteOptions(CreateObjectOptions createOptions, GoogleCloudStorageOptions storageOptions) {
        ArrayList<Storage.BlobWriteOption> blobWriteOptions = new ArrayList<Storage.BlobWriteOption>();
        blobWriteOptions.add(Storage.BlobWriteOption.disableGzipContent());
        blobWriteOptions.add(Storage.BlobWriteOption.generationMatch());
        if (createOptions.getKmsKeyName() != null) {
            blobWriteOptions.add(Storage.BlobWriteOption.kmsKeyName(createOptions.getKmsKeyName()));
        }
        if (storageOptions.getWriteChannelOptions().isGrpcChecksumsEnabled()) {
            blobWriteOptions.add(Storage.BlobWriteOption.crc32cMatch());
        }
        if (storageOptions.getEncryptionKey() != null) {
            blobWriteOptions.add(Storage.BlobWriteOption.encryptionKey(storageOptions.getEncryptionKey().value()));
        }
        return blobWriteOptions.toArray(new Storage.BlobWriteOption[blobWriteOptions.size()]);
    }

    @Override
    public boolean isOpen() {
        return this.writableByteChannel != null && this.writableByteChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.isOpen()) {
                return;
            }
            this.writableByteChannel.close();
        }
        catch (Exception e) {
            throw new IOException(String.format("Upload failed for '%s'. reason=%s", this.resourceId, e.getMessage()), e);
        }
        finally {
            this.writableByteChannel = null;
        }
    }

    private int writeInternal(ByteBuffer byteBuffer) throws IOException {
        int bytesWritten = this.writableByteChannel.write(byteBuffer);
        ((GoogleLogger.Api)logger.atFinest()).log("%d bytes were written out of provided buffer of capacity %d", bytesWritten, byteBuffer.limit());
        return bytesWritten;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.writeInternal(src);
    }
}

