/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.gradle.plugin;

import com.google.cloud.artifactregistry.auth.CommandExecutor;
import com.google.cloud.artifactregistry.auth.CommandExecutorResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.process.ExecOutput;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;

public class ProviderFactoryCommandExecutor
implements CommandExecutor {
    private final ProviderFactory providerFactory;

    public ProviderFactoryCommandExecutor(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public CommandExecutorResult executeCommand(String command, String ... args) throws IOException {
        ExecOutput execOutput;
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(command);
        argList.addAll(Arrays.asList(args));
        try {
            execOutput = this.providerFactory.exec(execSpec -> execSpec.commandLine((Iterable)argList));
        }
        catch (ExecException e) {
            throw new IOException(e);
        }
        int exitCode = ((ExecResult)execOutput.getResult().get()).getExitValue();
        String stdOut = (String)execOutput.getStandardOutput().getAsText().get();
        String stdErr = (String)execOutput.getStandardError().getAsText().get();
        return new CommandExecutorResult(exitCode, stdOut, stdErr);
    }
}

