/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.auth;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.GenericData;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.artifactregistry.auth.CommandExecutor;
import com.google.cloud.artifactregistry.auth.CommandExecutorResult;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcloudCredentials
extends GoogleCredentials {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GcloudCredentials.class.getName());
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_TOKEN_EXPIRY = "token_expiry";
    private final CommandExecutor commandExecutor;

    public GcloudCredentials(AccessToken initialToken, CommandExecutor commandExecutor) {
        super(initialToken);
        this.commandExecutor = commandExecutor;
    }

    public static GcloudCredentials tryCreateGcloudCredentials(CommandExecutor commandExecutor) throws IOException {
        return new GcloudCredentials(GcloudCredentials.validateAccessToken(GcloudCredentials.getGcloudAccessToken(commandExecutor)), commandExecutor);
    }

    private static String gCloudCommand() {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        return isWindows ? "gcloud.cmd" : "gcloud";
    }

    public AccessToken refreshAccessToken() throws IOException {
        LOGGER.info("Refreshing gcloud credentials...");
        return GcloudCredentials.validateAccessToken(GcloudCredentials.getGcloudAccessToken(this.commandExecutor));
    }

    private static AccessToken validateAccessToken(AccessToken token) throws IOException {
        Date expiry = token.getExpirationTime();
        if (expiry.before(new Date())) {
            throw new IOException("AccessToken is expired - maybe run `gcloud auth login`");
        }
        return token;
    }

    private static AccessToken getGcloudAccessToken(CommandExecutor commandExecutor) throws IOException {
        try {
            String gcloud = GcloudCredentials.gCloudCommand();
            CommandExecutorResult commandExecutorResult = commandExecutor.executeCommand(gcloud, "config", "config-helper", "--format=json(credential)");
            int exitCode = commandExecutorResult.exitCode;
            String stdOut = commandExecutorResult.stdOut;
            if (exitCode != 0) {
                String stdErr = commandExecutorResult.stdErr;
                throw new IOException(String.format("gcloud exited with status: %d\nOutput:\n%s\nError Output:\n%s\n", exitCode, stdOut, stdErr));
            }
            GenericData result = (GenericData)JSON_FACTORY.fromString(stdOut, GenericData.class);
            Map credential = (Map)result.get((Object)"credential");
            if (credential == null) {
                throw new IOException("No credential returned from gcloud");
            }
            if (!credential.containsKey(KEY_ACCESS_TOKEN) || !credential.containsKey(KEY_TOKEN_EXPIRY)) {
                throw new IOException("Malformed response from gcloud");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date expiry = df.parse((String)credential.get(KEY_TOKEN_EXPIRY));
            return new AccessToken((String)credential.get(KEY_ACCESS_TOKEN), expiry);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse timestamp from gcloud output", e);
        }
    }
}

