/*
 * Decompiled with CFR 0.152.
 */
package com.google.capillary.android;

import android.content.Context;
import com.google.capillary.NoSuchKeyException;
import com.google.capillary.RsaEcdsaHybridDecrypt;
import com.google.capillary.android.AndroidKeyStoreRsaUtils;
import com.google.capillary.android.KeyManager;
import com.google.capillary.android.Utils;
import com.google.capillary.internal.WrappedRsaEcdsaPublicKey;
import com.google.crypto.tink.BinaryKeysetReader;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.signature.PublicKeyVerifyFactory;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

public final class RsaEcdsaKeyManager
extends KeyManager {
    private static final String KEY_CHAIN_ID_PREFIX = "rsa_ecdsa_";
    private static Map<String, RsaEcdsaKeyManager> instances = new HashMap<String, RsaEcdsaKeyManager>();
    private final KeyStore keyStore;
    private PublicKeyVerify senderVerifier;

    private RsaEcdsaKeyManager(Context context, Utils utils, String keychainId, InputStream senderVerificationKey) throws GeneralSecurityException, IOException {
        super(context, utils, KEY_CHAIN_ID_PREFIX + keychainId);
        KeysetHandle verificationKeyHandle = CleartextKeysetHandle.read((KeysetReader)BinaryKeysetReader.withInputStream((InputStream)senderVerificationKey));
        this.senderVerifier = PublicKeyVerifyFactory.getPrimitive((KeysetHandle)verificationKeyHandle);
        this.keyStore = utils.loadKeyStore();
    }

    public static synchronized RsaEcdsaKeyManager getInstance(Context context, String keychainId, InputStream senderVerificationKey) throws GeneralSecurityException, IOException {
        if (instances.containsKey(keychainId)) {
            RsaEcdsaKeyManager instance = instances.get(keychainId);
            instance.updateSenderVerifier(senderVerificationKey);
            return instance;
        }
        RsaEcdsaKeyManager newInstance = new RsaEcdsaKeyManager(context, Utils.getInstance(), keychainId, senderVerificationKey);
        instances.put(keychainId, newInstance);
        return newInstance;
    }

    private synchronized void updateSenderVerifier(InputStream senderVerificationKey) throws GeneralSecurityException, IOException {
        KeysetHandle verificationKeyHandle = CleartextKeysetHandle.read((KeysetReader)BinaryKeysetReader.withInputStream((InputStream)senderVerificationKey));
        this.senderVerifier = PublicKeyVerifyFactory.getPrimitive((KeysetHandle)verificationKeyHandle);
    }

    @Override
    synchronized void rawGenerateKeyPair(boolean isAuth) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AndroidKeyStoreRsaUtils.generateKeyPair(this.context, this.keychainId, isAuth);
    }

    @Override
    synchronized byte[] rawGetPublicKey(boolean isAuth) throws NoSuchKeyException, GeneralSecurityException {
        byte[] publicKeyBytes = AndroidKeyStoreRsaUtils.getPublicKey(this.keyStore, this.keychainId, isAuth).getEncoded();
        return WrappedRsaEcdsaPublicKey.newBuilder().setPadding(AndroidKeyStoreRsaUtils.getCompatibleRsaPadding().name()).setKeyBytes(ByteString.copyFrom((byte[])publicKeyBytes)).build().toByteArray();
    }

    @Override
    synchronized HybridDecrypt rawGetDecrypter(boolean isAuth) throws NoSuchKeyException, GeneralSecurityException {
        PrivateKey recipientPrivateKey = AndroidKeyStoreRsaUtils.getPrivateKey(this.keyStore, this.keychainId, isAuth);
        return new RsaEcdsaHybridDecrypt.Builder().withRecipientPrivateKey(recipientPrivateKey).withSenderVerifier(this.senderVerifier).withPadding(AndroidKeyStoreRsaUtils.getCompatibleRsaPadding()).build();
    }

    @Override
    synchronized void rawDeleteKeyPair(boolean isAuth) throws NoSuchKeyException, GeneralSecurityException {
        AndroidKeyStoreRsaUtils.deleteKeyPair(this.keyStore, this.keychainId, isAuth);
    }
}

