/*
 * Decompiled with CFR 0.152.
 */
package com.google.capillary.android;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.capillary.android.Utils;
import com.google.crypto.tink.subtle.Base64;
import java.util.LinkedList;
import java.util.List;

class CiphertextStorage {
    private static final String DATA_COUNT_KEY = "current_count";
    private final SharedPreferences dataSharedPreferences;
    private final SharedPreferences metaSharedPreferences;

    CiphertextStorage(Context context, Utils utils, String keychainId) {
        Context storageContext = utils.getDeviceProtectedStorageContext(context);
        String dataPrefName = String.format("%s_%s_data_preferences", this.getClass().getCanonicalName(), keychainId);
        String metaPrefName = String.format("%s_%s_meta_preferences", this.getClass().getCanonicalName(), keychainId);
        this.dataSharedPreferences = storageContext.getSharedPreferences(dataPrefName, 0);
        this.metaSharedPreferences = storageContext.getSharedPreferences(metaPrefName, 0);
    }

    synchronized void save(byte[] ciphertext) {
        String ciphertextString = Base64.encode((byte[])ciphertext);
        int nextCount = this.metaSharedPreferences.getInt(DATA_COUNT_KEY, 0) + 1;
        this.dataSharedPreferences.edit().putString(String.valueOf(nextCount), ciphertextString).apply();
        this.metaSharedPreferences.edit().putInt(DATA_COUNT_KEY, nextCount).apply();
    }

    List<byte[]> get() {
        LinkedList<byte[]> ciphertextList = new LinkedList<byte[]>();
        for (Object ciphertextString : this.dataSharedPreferences.getAll().values()) {
            byte[] ciphertextBytes = Base64.decode((String)ciphertextString.toString());
            ciphertextList.add(ciphertextBytes);
        }
        return ciphertextList;
    }

    synchronized void clear() {
        this.dataSharedPreferences.edit().clear().apply();
        this.metaSharedPreferences.edit().putInt(DATA_COUNT_KEY, 0).apply();
    }
}

