/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.wallet;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.script.Script;
import com.google.bitcoin.wallet.CoinSelection;
import com.google.bitcoin.wallet.CoinSelector;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTimeCoinSelector
implements CoinSelector {
    private static final Logger log = LoggerFactory.getLogger(KeyTimeCoinSelector.class);
    public static final int MAX_SIMULTANEOUS_INPUTS = 600;
    private final long unixTimeSeconds;
    private final Wallet wallet;
    private final boolean ignorePending;

    public KeyTimeCoinSelector(Wallet wallet, long unixTimeSeconds, boolean ignorePending) {
        this.unixTimeSeconds = unixTimeSeconds;
        this.wallet = wallet;
        this.ignorePending = ignorePending;
    }

    @Override
    public CoinSelection select(BigInteger target, LinkedList<TransactionOutput> candidates) {
        try {
            LinkedList gathered = Lists.newLinkedList();
            BigInteger valueGathered = BigInteger.ZERO;
            for (TransactionOutput output : candidates) {
                ECKey controllingKey;
                if (this.ignorePending && !this.isConfirmed(output)) continue;
                Script scriptPubKey = output.getScriptPubKey();
                if (scriptPubKey.isSentToRawPubKey()) {
                    controllingKey = this.wallet.findKeyFromPubKey(scriptPubKey.getPubKey());
                } else if (scriptPubKey.isSentToAddress()) {
                    controllingKey = this.wallet.findKeyFromPubHash(scriptPubKey.getPubKeyHash());
                } else {
                    log.info("Skipping tx output {} because it's not of simple form.", (Object)output);
                    continue;
                }
                Preconditions.checkNotNull((Object)controllingKey, (Object)"Coin selector given output as candidate for which we lack the key");
                if (controllingKey.getCreationTimeSeconds() >= this.unixTimeSeconds) continue;
                valueGathered = valueGathered.add(output.getValue());
                gathered.push(output);
                if (gathered.size() < 600) continue;
                log.warn("Reached {} inputs, going further would yield a tx that is too large, stopping here.", (Object)gathered.size());
                break;
            }
            return new CoinSelection(valueGathered, gathered);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isConfirmed(TransactionOutput output) {
        return output.getParentTransaction().getConfidence().getConfidenceType().equals((Object)TransactionConfidence.ConfidenceType.BUILDING);
    }
}

