/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.wallet;

import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.wallet.RiskAnalysis;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultRiskAnalysis
implements RiskAnalysis {
    public static final BigInteger MIN_ANALYSIS_NONDUST_OUTPUT = BigInteger.valueOf(546L);
    protected final Transaction tx;
    protected final List<Transaction> dependencies;
    protected final Wallet wallet;
    private Transaction nonStandard;
    protected Transaction nonFinal;
    protected boolean analyzed;
    public static Analyzer FACTORY = new Analyzer();

    private DefaultRiskAnalysis(Wallet wallet, Transaction tx, List<Transaction> dependencies) {
        this.tx = tx;
        this.dependencies = dependencies;
        this.wallet = wallet;
    }

    @Override
    public RiskAnalysis.Result analyze() {
        Preconditions.checkState((!this.analyzed ? 1 : 0) != 0);
        this.analyzed = true;
        RiskAnalysis.Result result = this.analyzeIsFinal();
        if (result != RiskAnalysis.Result.OK) {
            return result;
        }
        return this.analyzeIsStandard();
    }

    private RiskAnalysis.Result analyzeIsFinal() {
        long time;
        if (this.tx.getConfidence().getSource() == TransactionConfidence.Source.SELF) {
            return RiskAnalysis.Result.OK;
        }
        int height = this.wallet.getLastBlockSeenHeight();
        int adjustedHeight = height + 1;
        if (!this.tx.isFinal(adjustedHeight, time = this.wallet.getLastBlockSeenTimeSecs())) {
            this.nonFinal = this.tx;
            return RiskAnalysis.Result.NON_FINAL;
        }
        for (Transaction dep : this.dependencies) {
            if (dep.isFinal(adjustedHeight, time)) continue;
            this.nonFinal = dep;
            return RiskAnalysis.Result.NON_FINAL;
        }
        return RiskAnalysis.Result.OK;
    }

    private RiskAnalysis.Result analyzeIsStandard() {
        if (!this.wallet.getNetworkParameters().getId().equals("org.bitcoin.production")) {
            return RiskAnalysis.Result.OK;
        }
        this.nonStandard = this.isStandard(this.tx);
        if (this.nonStandard != null) {
            return RiskAnalysis.Result.NON_STANDARD;
        }
        for (Transaction dep : this.dependencies) {
            this.nonStandard = this.isStandard(dep);
            if (this.nonStandard == null) continue;
            return RiskAnalysis.Result.NON_STANDARD;
        }
        return RiskAnalysis.Result.OK;
    }

    public Transaction isStandard(Transaction tx) {
        if (tx.getVersion() > 1L || tx.getVersion() < 1L) {
            return tx;
        }
        for (TransactionOutput output : tx.getOutputs()) {
            if (MIN_ANALYSIS_NONDUST_OUTPUT.compareTo(output.getValue()) <= 0) continue;
            return tx;
        }
        return null;
    }

    @Nullable
    public Transaction getNonStandard() {
        return this.nonStandard;
    }

    @Nullable
    public Transaction getNonFinal() {
        return this.nonFinal;
    }

    public String toString() {
        if (!this.analyzed) {
            return "Pending risk analysis for " + this.tx.getHashAsString();
        }
        if (this.nonFinal != null) {
            return "Risky due to non-finality of " + this.nonFinal.getHashAsString();
        }
        if (this.nonStandard != null) {
            return "Risky due to non-standard tx " + this.nonStandard.getHashAsString();
        }
        return "Non-risky";
    }

    public static class Analyzer
    implements RiskAnalysis.Analyzer {
        @Override
        public DefaultRiskAnalysis create(Wallet wallet, Transaction tx, List<Transaction> dependencies) {
            return new DefaultRiskAnalysis(wallet, tx, dependencies);
        }
    }
}

