/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.wallet;

import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.params.RegTestParams;
import com.google.bitcoin.wallet.CoinSelection;
import com.google.bitcoin.wallet.CoinSelector;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;

public class DefaultCoinSelector
implements CoinSelector {
    @Override
    public CoinSelection select(BigInteger biTarget, LinkedList<TransactionOutput> candidates) {
        long target = biTarget.longValue();
        HashSet<TransactionOutput> selected = new HashSet<TransactionOutput>();
        ArrayList<TransactionOutput> sortedOutputs = new ArrayList<TransactionOutput>(candidates);
        if (!biTarget.equals(NetworkParameters.MAX_MONEY)) {
            DefaultCoinSelector.sortOutputs(sortedOutputs);
        }
        long total = 0L;
        for (TransactionOutput output : sortedOutputs) {
            if (total >= target) break;
            if (!this.shouldSelect(output.getParentTransaction())) continue;
            selected.add(output);
            total += output.getValue().longValue();
        }
        return new CoinSelection(BigInteger.valueOf(total), selected);
    }

    @VisibleForTesting
    static void sortOutputs(ArrayList<TransactionOutput> outputs) {
        Collections.sort(outputs, new Comparator<TransactionOutput>(){

            @Override
            public int compare(TransactionOutput a, TransactionOutput b) {
                int depth1 = 0;
                int depth2 = 0;
                TransactionConfidence conf1 = a.getParentTransaction().getConfidence();
                TransactionConfidence conf2 = b.getParentTransaction().getConfidence();
                if (conf1.getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                    depth1 = conf1.getDepthInBlocks();
                }
                if (conf2.getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                    depth2 = conf2.getDepthInBlocks();
                }
                BigInteger aValue = a.getValue();
                BigInteger bValue = b.getValue();
                BigInteger aCoinDepth = aValue.multiply(BigInteger.valueOf(depth1));
                BigInteger bCoinDepth = bValue.multiply(BigInteger.valueOf(depth2));
                int c1 = bCoinDepth.compareTo(aCoinDepth);
                if (c1 != 0) {
                    return c1;
                }
                int c2 = bValue.compareTo(aValue);
                if (c2 != 0) {
                    return c2;
                }
                BigInteger aHash = a.getParentTransaction().getHash().toBigInteger();
                BigInteger bHash = b.getParentTransaction().getHash().toBigInteger();
                return aHash.compareTo(bHash);
            }
        });
    }

    protected boolean shouldSelect(Transaction tx) {
        return DefaultCoinSelector.isSelectable(tx);
    }

    public static boolean isSelectable(Transaction tx) {
        TransactionConfidence confidence = tx.getConfidence();
        TransactionConfidence.ConfidenceType type = confidence.getConfidenceType();
        return type.equals((Object)TransactionConfidence.ConfidenceType.BUILDING) || type.equals((Object)TransactionConfidence.ConfidenceType.PENDING) && confidence.getSource().equals((Object)TransactionConfidence.Source.SELF) && (confidence.numBroadcastPeers() > 1 || tx.getParams() == RegTestParams.get());
    }
}

