/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.utils;

import com.google.bitcoin.core.AbstractBlockChain;
import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.params.UnitTestParams;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.MemoryBlockStore;
import com.google.bitcoin.utils.BriefLogFormatter;
import com.google.bitcoin.utils.TestUtils;
import java.io.IOException;
import java.math.BigInteger;
import javax.annotation.Nullable;

public class TestWithWallet {
    protected static final NetworkParameters params = UnitTestParams.get();
    protected ECKey myKey;
    protected Address myAddress;
    protected Wallet wallet;
    protected BlockChain chain;
    protected BlockStore blockStore;

    public void setUp() throws Exception {
        BriefLogFormatter.init();
        Wallet.SendRequest.DEFAULT_FEE_PER_KB = BigInteger.ZERO;
        this.myKey = new ECKey();
        this.myAddress = this.myKey.toAddress(params);
        this.wallet = new Wallet(params);
        this.wallet.addKey(this.myKey);
        this.blockStore = new MemoryBlockStore(params);
        this.chain = new BlockChain(params, this.wallet, this.blockStore);
    }

    public void tearDown() throws Exception {
        Wallet.SendRequest.DEFAULT_FEE_PER_KB = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Wallet wallet, Transaction tx, AbstractBlockChain.NewBlockType type) throws IOException, VerificationException {
        if (type == null) {
            if (wallet.isPendingTransactionRelevant(tx)) {
                wallet.receivePending(tx, null);
            }
        } else {
            TestUtils.BlockPair bp = TestUtils.createFakeBlock(this.blockStore, tx);
            wallet.receiveFromBlock(tx, bp.storedBlock, type, 0);
            if (type == AbstractBlockChain.NewBlockType.BEST_CHAIN) {
                wallet.notifyNewBestBlock(bp.storedBlock);
            }
        }
        return wallet.getTransaction(tx.getHash());
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Transaction tx, AbstractBlockChain.NewBlockType type) throws IOException, VerificationException {
        return this.sendMoneyToWallet(this.wallet, tx, type);
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Wallet wallet, BigInteger value, Address toAddress, AbstractBlockChain.NewBlockType type) throws IOException, VerificationException {
        return this.sendMoneyToWallet(wallet, TestUtils.createFakeTx(params, value, toAddress), type);
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Wallet wallet, BigInteger value, ECKey toPubKey, AbstractBlockChain.NewBlockType type) throws IOException, VerificationException {
        return this.sendMoneyToWallet(wallet, TestUtils.createFakeTx(params, value, toPubKey), type);
    }

    @Nullable
    protected Transaction sendMoneyToWallet(BigInteger value, AbstractBlockChain.NewBlockType type) throws IOException, VerificationException {
        return this.sendMoneyToWallet(this.wallet, TestUtils.createFakeTx(params, value, this.myAddress), type);
    }
}

