/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.utils;

import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionBroadcaster;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.utils.Threading;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;

public class MockTransactionBroadcaster
implements TransactionBroadcaster {
    private final ReentrantLock lock = Threading.lock("mock tx broadcaster");
    private final Wallet wallet;
    private final LinkedBlockingQueue<TxFuturePair> broadcasts = new LinkedBlockingQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockTransactionBroadcaster(Wallet wallet) {
        this.lock.lock();
        try {
            this.wallet = wallet;
            wallet.getPendingTransactions();
        }
        finally {
            this.lock.unlock();
        }
    }

    public SettableFuture<Transaction> broadcastTransaction(Transaction tx) {
        this.lock.lock();
        try {
            SettableFuture result = SettableFuture.create();
            this.broadcasts.put(new TxFuturePair(tx, (SettableFuture<Transaction>)result));
            Futures.addCallback((ListenableFuture)result, (FutureCallback)new FutureCallback<Transaction>(){

                public void onSuccess(Transaction result) {
                    try {
                        MockTransactionBroadcaster.this.wallet.receivePending(result, null);
                    }
                    catch (VerificationException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onFailure(Throwable t) {
                }
            });
            SettableFuture settableFuture = result;
            return settableFuture;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Transaction waitForTransaction() {
        return this.waitForTxFuture().tx;
    }

    public TxFuturePair waitForTxFuture() {
        try {
            return this.broadcasts.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.broadcasts.size();
    }

    public static class TxFuturePair {
        public Transaction tx;
        public SettableFuture<Transaction> future;

        public TxFuturePair(Transaction tx, SettableFuture<Transaction> future) {
            this.tx = tx;
            this.future = future;
        }
    }
}

